/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.ConfigurableEditor;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.SearchTextField;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsDialog
extends DialogWrapper
implements DataProvider {
    public static final String DIMENSION_KEY = "SettingsEditor";
    private final String myDimensionServiceKey;
    private final AbstractEditor myEditor;
    private boolean myApplyButtonNeeded;
    private boolean myResetButtonNeeded;

    public SettingsDialog(Project project2, String key2, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/openapi/options/newEditor/SettingsDialog", "<init>"));
        }
        super(project2, true);
        this.myDimensionServiceKey = key2;
        this.myEditor = new ConfigurableEditor(this.myDisposable, configurable);
        this.myApplyButtonNeeded = showApplyButton;
        this.myResetButtonNeeded = showResetButton;
        this.init(configurable, project2);
    }

    public SettingsDialog(@NotNull Component parent, String key2, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/options/newEditor/SettingsDialog", "<init>"));
        }
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/openapi/options/newEditor/SettingsDialog", "<init>"));
        }
        super(parent, true);
        this.myDimensionServiceKey = key2;
        this.myEditor = new ConfigurableEditor(this.myDisposable, configurable);
        this.myApplyButtonNeeded = showApplyButton;
        this.myResetButtonNeeded = showResetButton;
        this.init(configurable, null);
    }

    public SettingsDialog(@NotNull Project project2, @NotNull ConfigurableGroup[] groups, Configurable configurable, String filter) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/options/newEditor/SettingsDialog", "<init>"));
        }
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/openapi/options/newEditor/SettingsDialog", "<init>"));
        }
        super(project2, true);
        this.myDimensionServiceKey = DIMENSION_KEY;
        this.myEditor = new SettingsEditor(this.myDisposable, project2, groups, configurable, filter, this::treeViewFactory);
        this.myApplyButtonNeeded = true;
        this.init(null, project2);
    }

    protected SettingsTreeView treeViewFactory(SettingsFilter filter, ConfigurableGroup[] groups) {
        return new SettingsTreeView(filter, groups);
    }

    public void show() {
        TransactionGuard.getInstance().submitTransactionAndWait(() -> super.show());
    }

    private void init(Configurable configurable, @Nullable Project project2) {
        String name2 = configurable == null ? null : configurable.getDisplayName();
        String title = CommonBundle.settingsTitle();
        if (project2 != null && project2.isDefault()) {
            title = "Default " + title;
        }
        this.setTitle(name2 == null ? title : name2.replace('\n', ' '));
        ShortcutSet set2 = SettingsDialog.getFindActionShortcutSet();
        if (set2 != null) {
            new SearchTextField.FindAction().registerCustomShortcutSet(set2, (JComponent)this.getRootPane(), this.myDisposable);
        }
        this.init();
    }

    public Object getData(@NonNls String dataId) {
        if (this.myEditor instanceof DataProvider) {
            DataProvider provider = (DataProvider)this.myEditor;
            return provider.getData(dataId);
        }
        return null;
    }

    protected String getDimensionServiceKey() {
        return this.myDimensionServiceKey;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    public boolean isTypeAheadEnabled() {
        return true;
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/newEditor/SettingsDialog", "getStyle"));
        }
        return dialogStyle;
    }

    protected JComponent createCenterPanel() {
        return this.myEditor;
    }

    protected void tryAddOptionsListener(OptionsEditorColleague colleague) {
        if (this.myEditor instanceof SettingsEditor) {
            ((SettingsEditor)this.myEditor).addOptionsListener(colleague);
        }
    }

    @NotNull
    protected Action[] createActions() {
        String topic;
        Action reset;
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        actions.add(this.getCancelAction());
        Action apply2 = this.myEditor.getApplyAction();
        if (apply2 != null && this.myApplyButtonNeeded) {
            actions.add(apply2);
        }
        if ((reset = this.myEditor.getResetAction()) != null && this.myResetButtonNeeded) {
            actions.add(reset);
        }
        if ((topic = this.getHelpTopic()) != null) {
            actions.add(this.getHelpAction());
        }
        Action[] actionArray = actions.toArray(new Action[actions.size()]);
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/newEditor/SettingsDialog", "createActions"));
        }
        return actionArray;
    }

    protected String getHelpTopic() {
        return this.myEditor.getHelpTopic();
    }

    protected void doHelpAction() {
        String topic = this.getHelpTopic();
        if (topic != null) {
            HelpManager.getInstance().invokeHelp(topic);
        }
    }

    public void doOKAction() {
        if (this.myEditor.apply()) {
            ApplicationManager.getApplication().saveAll();
            super.doOKAction();
        }
    }

    public void doCancelAction(AWTEvent source) {
        if ((source instanceof KeyEvent || source instanceof ActionEvent) && !this.myEditor.cancel()) {
            return;
        }
        super.doCancelAction(source);
    }

    static ShortcutSet getFindActionShortcutSet() {
        AnAction action = ActionManager.getInstance().getAction("Find");
        return action == null ? null : action.getShortcutSet();
    }
}

