/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.SmoothProgressAdapter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressManagerImpl
extends CoreProgressManager
implements Disposable {
    private final Set<CoreProgressManager.CheckCanceledHook> myHooks = ContainerUtil.newConcurrentSet();

    public ProgressManagerImpl() {
        HeavyProcessLatch.INSTANCE.addUIActivityListener(new HeavyProcessLatch.HeavyProcessListener(){
            CoreProgressManager.CheckCanceledHook sleepHook = indicator -> ProgressManagerImpl.access$000();
            AtomicBoolean scheduled = new AtomicBoolean();
            Runnable addHookLater = () -> {
                this.scheduled.set(false);
                if (HeavyProcessLatch.INSTANCE.hasPrioritizedThread()) {
                    ProgressManagerImpl.this.addCheckCanceledHook(this.sleepHook);
                }
            };

            public void processStarted() {
                if (this.scheduled.compareAndSet(false, true)) {
                    AppExecutorUtil.getAppScheduledExecutorService().schedule(this.addHookLater, 5L, TimeUnit.MILLISECONDS);
                }
            }

            public void processFinished() {
                ProgressManagerImpl.this.removeCheckCanceledHook(this.sleepHook);
            }
        }, (Disposable)this);
    }

    @Override
    public void setCancelButtonText(String cancelButtonText) {
        ProgressIndicator original;
        ProgressIndicator progressIndicator = this.getProgressIndicator();
        if (progressIndicator != null && progressIndicator instanceof SmoothProgressAdapter && cancelButtonText != null && (original = ((SmoothProgressAdapter)progressIndicator).getOriginalProgressIndicator()) instanceof ProgressWindow) {
            ((ProgressWindow)original).setCancelButtonText(cancelButtonText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process2, ProgressIndicator progress) throws ProcessCanceledException {
        CoreProgressManager.CheckCanceledHook hook;
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "executeProcessUnderProgress"));
        }
        if (progress instanceof ProgressWindow) {
            this.myCurrentUnsafeProgressCount.incrementAndGet();
        }
        CoreProgressManager.CheckCanceledHook checkCanceledHook = hook = progress instanceof PingProgress && ApplicationManager.getApplication().isDispatchThread() ? p -> {
            ((PingProgress)progress).interact();
            return true;
        } : null;
        if (hook != null) {
            this.addCheckCanceledHook(hook);
        }
        try {
            super.executeProcessUnderProgress(process2, progress);
        }
        finally {
            if (progress instanceof ProgressWindow) {
                this.myCurrentUnsafeProgressCount.decrementAndGet();
            }
            if (hook != null) {
                this.removeCheckCanceledHook(hook);
            }
        }
    }

    public static void runWithAlwaysCheckingCanceled(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runWithAlwaysCheckingCanceled"));
        }
        Thread fake = new Thread("fake");
        try {
            threadsUnderCanceledIndicator.add(fake);
            runnable2.run();
        }
        finally {
            threadsUnderCanceledIndicator.remove(fake);
        }
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Task task, @Nullable JComponent parentComponent) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressSynchronously"));
        }
        long start = System.currentTimeMillis();
        boolean result2 = super.runProcessWithProgressSynchronously(task, parentComponent);
        if (result2) {
            JFrame frame;
            long end = System.currentTimeMillis();
            Task.NotificationInfo notificationInfo = task.notifyFinished();
            long time = end - start;
            if (notificationInfo != null && time > 5000L && (frame = WindowManager.getInstance().getFrame(task.getProject())) != null && !frame.hasFocus()) {
                ProgressManagerImpl.systemNotify(notificationInfo);
            }
        }
        return result2;
    }

    private static void systemNotify(@NotNull Task.NotificationInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "systemNotify"));
        }
        SystemNotifications.getInstance().notify(info.getNotificationName(), info.getNotificationTitle(), info.getNotificationText());
    }

    @Override
    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        Object progressIndicator = ApplicationManager.getApplication().isHeadlessEnvironment() ? new EmptyProgressIndicator() : new BackgroundableProcessIndicator(task);
        Future<?> future2 = this.runProcessWithProgressAsynchronously(task, (ProgressIndicator)progressIndicator, null);
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        return future2;
    }

    @Override
    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(final @NotNull Task.Backgroundable task, final @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation, final @NotNull ModalityState modalityState) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator instanceof Disposable) {
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)((Disposable)progressIndicator));
        }
        final CoreProgressManager.TaskRunnable process2 = new CoreProgressManager.TaskRunnable((Task)task, progressIndicator, continuation);
        CoreProgressManager.TaskContainer action = new CoreProgressManager.TaskContainer((Task)task){

            @Override
            public void run() {
                boolean processCanceled = false;
                Throwable exception = null;
                long start = System.currentTimeMillis();
                try {
                    ProgressManager.getInstance().runProcess(process2, progressIndicator);
                }
                catch (ProcessCanceledException e) {
                    processCanceled = true;
                }
                catch (Throwable e) {
                    exception = e;
                }
                long end = System.currentTimeMillis();
                boolean finalCanceled = processCanceled || progressIndicator.isCanceled();
                Throwable finalException = exception;
                if (!finalCanceled) {
                    Window window;
                    Task.NotificationInfo notificationInfo = task.notifyFinished();
                    long time = end - start;
                    if (notificationInfo != null && time > 5000L && ((window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null || notificationInfo.isShowWhenFocused())) {
                        ProgressManagerImpl.systemNotify(notificationInfo);
                    }
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (task == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/ProgressManagerImpl$2", "lambda$run$0"));
                    }
                    CoreProgressManager.finishTask((Task)task, finalCanceled, finalException);
                }, modalityState);
            }
        };
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread((Runnable)action);
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        return future2;
    }

    @Override
    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action, @Nullable ProgressIndicator indicator) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runInReadActionWithWriteActionPriority"));
        }
        return ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action, indicator);
    }

    void addCheckCanceledHook(@NotNull CoreProgressManager.CheckCanceledHook hook) {
        if (hook == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hook", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "addCheckCanceledHook"));
        }
        if (this.myHooks.add(hook)) {
            this.updateShouldCheckCanceled();
        }
    }

    void removeCheckCanceledHook(@NotNull CoreProgressManager.CheckCanceledHook hook) {
        if (hook == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hook", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "removeCheckCanceledHook"));
        }
        if (this.myHooks.remove(hook)) {
            this.updateShouldCheckCanceled();
        }
    }

    @Override
    @Nullable
    protected CoreProgressManager.CheckCanceledHook createCheckCanceledHook() {
        if (this.myHooks.isEmpty()) {
            return null;
        }
        CoreProgressManager.CheckCanceledHook[] activeHooks = (CoreProgressManager.CheckCanceledHook[])ArrayUtil.stripTrailingNulls((Object[])this.myHooks.toArray(new CoreProgressManager.CheckCanceledHook[0]));
        return activeHooks.length == 1 ? activeHooks[0] : indicator -> {
            boolean result2 = false;
            for (CoreProgressManager.CheckCanceledHook hook : activeHooks) {
                if (!hook.runHook(indicator)) continue;
                result2 = true;
            }
            return result2;
        };
    }

    private static boolean sleepIfNeededToGivePriorityToAnotherThread() {
        if (HeavyProcessLatch.INSTANCE.isInsideLowPriorityThread()) {
            LockSupport.parkNanos(1000000L);
            return true;
        }
        return false;
    }
}

