/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressIndicatorListenerAdapter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressSuspender {
    private static final Key<ProgressSuspender> PROGRESS_SUSPENDER = Key.create((String)"PROGRESS_SUSPENDER");
    private final Object myLock;
    private final Thread myThread;
    private static final Application ourApp = ApplicationManager.getApplication();
    private volatile boolean mySuspended;
    private final CoreProgressManager.CheckCanceledHook myHook;

    private ProgressSuspender(@NotNull ProgressIndicatorEx progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/openapi/progress/impl/ProgressSuspender", "<init>"));
        }
        this.myLock = new Object();
        this.myHook = this::freezeIfNeeded;
        assert (progress.isRunning());
        assert (ProgressIndicatorProvider.getGlobalProgressIndicator() == progress);
        this.myThread = Thread.currentThread();
        ((UserDataHolder)progress).putUserData(PROGRESS_SUSPENDER, (Object)this);
        new ProgressIndicatorListenerAdapter(){

            @Override
            public void cancelled() {
                ProgressSuspender.this.setSuspended(false);
            }
        }.installToProgress(progress);
    }

    public static void markSuspendable(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/ProgressSuspender", "markSuspendable"));
        }
        new ProgressSuspender((ProgressIndicatorEx)indicator);
    }

    @Nullable
    public static ProgressSuspender getSuspender(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/ProgressSuspender", "getSuspender"));
        }
        return indicator instanceof UserDataHolder ? (ProgressSuspender)((UserDataHolder)indicator).getUserData(PROGRESS_SUSPENDER) : null;
    }

    public boolean isSuspended() {
        return this.mySuspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspended(boolean suspended) {
        Object object = this.myLock;
        synchronized (object) {
            if (suspended == this.mySuspended) {
                return;
            }
            this.mySuspended = suspended;
            ProgressManagerImpl manager = (ProgressManagerImpl)ProgressManager.getInstance();
            if (suspended) {
                manager.addCheckCanceledHook(this.myHook);
            } else {
                manager.removeCheckCanceledHook(this.myHook);
                this.myLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean freezeIfNeeded(@Nullable ProgressIndicator current) {
        if (current == null || ourApp.isReadAccessAllowed() || !CoreProgressManager.isThreadUnderIndicator(current, this.myThread)) {
            return false;
        }
        Object object = this.myLock;
        synchronized (object) {
            while (this.mySuspended) {
                try {
                    this.myLock.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return true;
        }
    }
}

