/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ProgressIndicatorUtils {
    private ProgressIndicatorUtils() {
    }

    @NotNull
    public static ProgressIndicator forceWriteActionPriority(final @NotNull ProgressIndicator progress, @NotNull Disposable parentDisposable) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "forceWriteActionPriority"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "forceWriteActionPriority"));
        }
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void beforeWriteActionStart(@NotNull Object action) {
                if (action == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils$1", "beforeWriteActionStart"));
                }
                if (progress.isRunning()) {
                    progress.cancel();
                }
            }
        }, parentDisposable);
        ProgressIndicator progressIndicator = progress;
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "forceWriteActionPriority"));
        }
        return progressIndicator;
    }

    @NotNull
    public static CompletableFuture<?> submitWithWriteActionPriority(@NotNull ReadTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "submitWithWriteActionPriority"));
        }
        CompletableFuture<?> completableFuture = ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ProgressIndicatorBase(), task);
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "submitWithWriteActionPriority"));
        }
        return completableFuture;
    }

    public static void scheduleWithWriteActionPriority(@NotNull ReadTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        ProgressIndicatorUtils.submitWithWriteActionPriority(task);
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(@NotNull ProgressIndicator progressIndicator, @NotNull ReadTask readTask) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        if (readTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readTask", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        CompletableFuture<?> completableFuture = ProgressIndicatorUtils.scheduleWithWriteActionPriority(progressIndicator, PooledThreadExecutor.INSTANCE, readTask);
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        return completableFuture;
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(@NotNull Executor executor, @NotNull ReadTask task) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        CompletableFuture<?> completableFuture = ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ProgressIndicatorBase(), executor, task);
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        return completableFuture;
    }

    public static boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action, @Nullable ProgressIndicator progressIndicator) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "runInReadActionWithWriteActionPriority"));
        }
        Ref result2 = new Ref((Object)Boolean.FALSE);
        ProgressIndicatorUtils.runWithWriteActionPriority(() -> {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "lambda$runInReadActionWithWriteActionPriority$0"));
            }
            result2.set((Object)ApplicationManagerEx.getApplicationEx().tryRunReadAction(action));
        }, progressIndicator == null ? new ProgressIndicatorBase() : progressIndicator);
        return (Boolean)result2.get();
    }

    public static boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "runInReadActionWithWriteActionPriority"));
        }
        return ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runWithWriteActionPriority(@NotNull Runnable action, final @NotNull ProgressIndicator progressIndicator) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "runWithWriteActionPriority"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "runWithWriteActionPriority"));
        }
        ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            throw new IllegalStateException("Must not call from EDT");
        }
        if (application.isWriteActionPending()) {
            if (!progressIndicator.isCanceled()) {
                progressIndicator.cancel();
            }
            return false;
        }
        ApplicationAdapter listener2 = new ApplicationAdapter(){

            public void beforeWriteActionStart(@NotNull Object action) {
                if (action == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils$2", "beforeWriteActionStart"));
                }
                if (!progressIndicator.isCanceled()) {
                    progressIndicator.cancel();
                }
            }
        };
        boolean succeededWithAddingListener = application.tryRunReadAction(() -> application.addApplicationListener((ApplicationListener)listener2));
        if (!succeededWithAddingListener) {
            if (!progressIndicator.isCanceled()) {
                progressIndicator.cancel();
            }
            return false;
        }
        Ref wasCancelled = new Ref();
        try {
            ProgressManager.getInstance().runProcess(() -> {
                if (action == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "lambda$runWithWriteActionPriority$2"));
                }
                try {
                    action.run();
                }
                catch (ProcessCanceledException ignore) {
                    wasCancelled.set((Object)Boolean.TRUE);
                }
            }, progressIndicator);
        }
        finally {
            application.removeApplicationListener((ApplicationListener)listener2);
        }
        return wasCancelled.get() != Boolean.TRUE;
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(final @NotNull ProgressIndicator progressIndicator, @NotNull Executor executor, final @NotNull ReadTask readTask) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        if (readTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readTask", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        final CompletableFuture future2 = new CompletableFuture();
        final Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            if (progressIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "lambda$scheduleWithWriteActionPriority$4"));
            }
            if (readTask == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readTask", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "lambda$scheduleWithWriteActionPriority$4"));
            }
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "lambda$scheduleWithWriteActionPriority$4"));
            }
            if (application.isDisposed() || progressIndicator.isCanceled() || future2.isCancelled()) {
                future2.complete(null);
                return;
            }
            final ApplicationAdapter listener2 = new ApplicationAdapter(){

                public void beforeWriteActionStart(@NotNull Object action) {
                    if (action == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils$3", "beforeWriteActionStart"));
                    }
                    if (!progressIndicator.isCanceled()) {
                        progressIndicator.cancel();
                        readTask.onCanceled(progressIndicator);
                    }
                }
            };
            application.addApplicationListener((ApplicationListener)listener2);
            future2.whenComplete((o, throwable) -> application.removeApplicationListener((ApplicationListener)listener2));
            try {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ReadTask.Continuation continuation;
                        try {
                            continuation = ProgressIndicatorUtils.runUnderProgress(progressIndicator, readTask);
                        }
                        catch (Throwable e) {
                            future2.completeExceptionally(e);
                            throw e;
                        }
                        if (continuation == null) {
                            future2.complete(null);
                        } else if (!future2.isCancelled()) {
                            application.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (future2.isCancelled()) {
                                        return;
                                    }
                                    application.removeApplicationListener((ApplicationListener)listener2);
                                    try {
                                        if (!progressIndicator.isCanceled()) {
                                            continuation.getAction().run();
                                        }
                                    }
                                    finally {
                                        future2.complete(null);
                                    }
                                }

                                public String toString() {
                                    return "continuation of " + readTask;
                                }
                            }, continuation.getModalityState());
                        }
                    }

                    public String toString() {
                        return readTask.toString();
                    }
                });
            }
            catch (Error | RuntimeException e) {
                future2.completeExceptionally(e);
                throw e;
            }
        }, ModalityState.any());
        CompletableFuture completableFuture = future2;
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        return completableFuture;
    }

    private static ReadTask.Continuation runUnderProgress(@NotNull ProgressIndicator progressIndicator, @NotNull ReadTask task) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "runUnderProgress"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "runUnderProgress"));
        }
        return (ReadTask.Continuation)ProgressManager.getInstance().runProcess(() -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "lambda$runUnderProgress$5"));
            }
            if (progressIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "lambda$runUnderProgress$5"));
            }
            try {
                return task.runBackgroundProcess(progressIndicator);
            }
            catch (ProcessCanceledException ignore) {
                return null;
            }
        }, progressIndicator);
    }

    public static void yieldToPendingWriteActions() {
        ApplicationManager.getApplication().invokeAndWait(EmptyRunnable.INSTANCE, ModalityState.any());
    }
}

