/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkTableImpl;
import com.intellij.util.SystemProperties;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class JavaAwareProjectJdkTableImpl
extends ProjectJdkTableImpl {
    private final JavaSdk myJavaSdk;
    private Sdk myInternalJdk;

    public static JavaAwareProjectJdkTableImpl getInstanceEx() {
        return (JavaAwareProjectJdkTableImpl)((Object)ServiceManager.getService(ProjectJdkTable.class));
    }

    public JavaAwareProjectJdkTableImpl(@NotNull JavaSdk javaSdk) {
        if (javaSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaSdk", "com/intellij/openapi/projectRoots/impl/JavaAwareProjectJdkTableImpl", "<init>"));
        }
        this.myJavaSdk = javaSdk;
    }

    @NotNull
    public Sdk getInternalJdk() {
        if (this.myInternalJdk == null) {
            String jdkHome = SystemProperties.getJavaHome();
            String versionName = ProjectBundle.message((String)"sdk.java.name.template", (Object[])new Object[]{SystemProperties.getJavaVersion()});
            this.myInternalJdk = this.myJavaSdk.createJdk(versionName, jdkHome);
        }
        Sdk sdk = this.myInternalJdk;
        if (sdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaAwareProjectJdkTableImpl", "getInternalJdk"));
        }
        return sdk;
    }

    @Override
    public void removeJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/openapi/projectRoots/impl/JavaAwareProjectJdkTableImpl", "removeJdk"));
        }
        super.removeJdk(jdk);
        if (jdk.equals(this.myInternalJdk)) {
            this.myInternalJdk = null;
        }
    }

    @Override
    @NotNull
    public SdkTypeId getDefaultSdkType() {
        JavaSdk javaSdk = this.myJavaSdk;
        if (javaSdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaAwareProjectJdkTableImpl", "getDefaultSdkType"));
        }
        return javaSdk;
    }

    @Override
    public void loadState(Element element) {
        this.myInternalJdk = null;
        try {
            super.loadState(element);
        }
        finally {
            this.getInternalJdk();
        }
    }

    @Override
    protected String getSdkTypeName(String type2) {
        return type2 != null ? type2 : JavaSdk.getInstance().getName();
    }
}

