/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.impl.WindowsJavaFinder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JavaHomeFinder {
    @NotNull
    public static List<String> suggestHomePaths() {
        ArrayList<String> paths = new ArrayList<String>(new HashSet<String>(JavaHomeFinder.getFinder().findExistingJdks()));
        paths.sort((o1, o2) -> Comparing.compare((Comparable)JavaSdkVersion.fromVersionString((String)o2), (Comparable)JavaSdkVersion.fromVersionString((String)o1)));
        ArrayList<String> arrayList = paths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaHomeFinder", "suggestHomePaths"));
        }
        return arrayList;
    }

    @NotNull
    protected abstract List<String> findExistingJdks();

    private static JavaHomeFinder getFinder() {
        if (SystemInfo.isWindows) {
            return new WindowsJavaFinder();
        }
        if (SystemInfo.isMac) {
            return new MacFinder();
        }
        if (SystemInfo.isLinux) {
            return new DefaultFinder("/usr/java", "/opt/java", "/usr/lib/jvm");
        }
        if (SystemInfo.isSolaris) {
            return new DefaultFinder("/usr/jdk");
        }
        return new DefaultFinder(new String[0]);
    }

    protected static void scanFolder(File folder, List<String> result2) {
        if (JdkUtil.checkForJdk((File)folder)) {
            result2.add(folder.getAbsolutePath());
        }
        for (File file2 : (File[])ObjectUtils.notNull((Object)folder.listFiles(), (Object)ArrayUtil.EMPTY_FILE_ARRAY)) {
            if (!JdkUtil.checkForJdk((File)file2)) continue;
            result2.add(file2.getAbsolutePath());
        }
    }

    protected static File getJavaHome() {
        String property = SystemProperties.getJavaHome();
        if (property == null) {
            return null;
        }
        File javaHome = new File(property).getParentFile();
        return javaHome == null || !javaHome.isDirectory() ? null : javaHome;
    }

    private static class MacFinder
    extends DefaultFinder {
        public MacFinder() {
            super("/Library/Java/JavaVirtualMachines", "/System/Library/Java/JavaVirtualMachines");
        }

        @Override
        @NotNull
        public List<String> findExistingJdks() {
            String path;
            List<String> list2 = super.findExistingJdks();
            if (new File("/usr/libexec/java_home").canExecute() && (path = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"/usr/libexec/java_home"}))) != null && new File(path).isDirectory()) {
                list2.add(path);
            }
            List<String> list3 = list2;
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaHomeFinder$MacFinder", "findExistingJdks"));
            }
            return list3;
        }
    }

    protected static class DefaultFinder
    extends JavaHomeFinder {
        private final String[] myPaths;

        protected DefaultFinder(String ... paths) {
            File javaHome = DefaultFinder.getJavaHome();
            this.myPaths = javaHome == null ? paths : (String[])ArrayUtil.prepend((Object)javaHome.getAbsolutePath(), (Object[])paths);
        }

        @Override
        @NotNull
        public List<String> findExistingJdks() {
            ArrayList<String> result2 = new ArrayList<String>();
            for (String path : this.myPaths) {
                JavaHomeFinder.scanFolder(new File(path), result2);
            }
            ArrayList<String> arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaHomeFinder$DefaultFinder", "findExistingJdks"));
            }
            return arrayList;
        }
    }
}

