/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ConvertingIterator;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FilteringIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleLibraryTable
implements LibraryTable,
LibraryTable.ModifiableModel {
    private static final ModuleLibraryOrderEntryCondition MODULE_LIBRARY_ORDER_ENTRY_FILTER = new ModuleLibraryOrderEntryCondition();
    private static final OrderEntryToLibraryConvertor ORDER_ENTRY_TO_LIBRARY_CONVERTOR = new OrderEntryToLibraryConvertor();
    @NotNull
    private final RootModelImpl myRootModel;
    @NotNull
    private final ProjectRootManagerImpl myProjectRootManager;
    public static final LibraryTablePresentation MODULE_LIBRARY_TABLE_PRESENTATION = new LibraryTablePresentation(){

        public String getDisplayName(boolean plural) {
            return ProjectBundle.message((String)"module.library.display.name", (Object[])new Object[]{plural ? 2 : 1});
        }

        public String getDescription() {
            return ProjectBundle.message((String)"libraries.node.text.module", (Object[])new Object[0]);
        }

        public String getLibraryTableEditorTitle() {
            return ProjectBundle.message((String)"library.configure.module.title", (Object[])new Object[0]);
        }
    };

    ModuleLibraryTable(@NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/ModuleLibraryTable", "<init>"));
        }
        if (projectRootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootManager", "com/intellij/openapi/roots/impl/ModuleLibraryTable", "<init>"));
        }
        this.myRootModel = rootModel;
        this.myProjectRootManager = projectRootManager;
    }

    @NotNull
    public Library[] getLibraries() {
        ArrayList result2 = new ArrayList();
        Iterator<Library> libraryIterator = this.getLibraryIterator();
        ContainerUtil.addAll(result2, libraryIterator);
        Library[] libraryArray = result2.toArray(new Library[result2.size()]);
        if (libraryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleLibraryTable", "getLibraries"));
        }
        return libraryArray;
    }

    public Library createLibrary() {
        return this.createLibrary(null);
    }

    public Library createLibrary(String name2) {
        return this.createLibrary(name2, null);
    }

    public Library createLibrary(String name2, @Nullable PersistentLibraryKind type2) {
        return this.createLibrary(name2, type2, null);
    }

    public Library createLibrary(String name2, @Nullable PersistentLibraryKind kind2, @Nullable ProjectModelExternalSource externalSource) {
        ModuleLibraryOrderEntryImpl orderEntry = new ModuleLibraryOrderEntryImpl(name2, kind2, this.myRootModel, this.myProjectRootManager, externalSource);
        this.myRootModel.addOrderEntry(orderEntry);
        return orderEntry.getLibrary();
    }

    public void removeLibrary(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/ModuleLibraryTable", "removeLibrary"));
        }
        Iterator<OrderEntry> orderIterator = this.myRootModel.getOrderIterator();
        while (orderIterator.hasNext()) {
            LibraryOrderEntry libraryOrderEntry;
            OrderEntry orderEntry = orderIterator.next();
            if (!(orderEntry instanceof LibraryOrderEntry) || !(libraryOrderEntry = (LibraryOrderEntry)orderEntry).isModuleLevel() || !library.equals(libraryOrderEntry.getLibrary())) continue;
            this.myRootModel.removeOrderEntry(orderEntry);
            return;
        }
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        FilteringIterator filteringIterator = new FilteringIterator(this.myRootModel.getOrderIterator(), (Condition)MODULE_LIBRARY_ORDER_ENTRY_FILTER);
        ConvertingIterator convertingIterator = new ConvertingIterator((Iterator)filteringIterator, (Convertor)ORDER_ENTRY_TO_LIBRARY_CONVERTOR);
        if (convertingIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleLibraryTable", "getLibraryIterator"));
        }
        return convertingIterator;
    }

    public String getTableLevel() {
        return "module";
    }

    public LibraryTablePresentation getPresentation() {
        return MODULE_LIBRARY_TABLE_PRESENTATION;
    }

    @Nullable
    public Library getLibraryByName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/roots/impl/ModuleLibraryTable", "getLibraryByName"));
        }
        Iterator<Library> libraryIterator = this.getLibraryIterator();
        while (libraryIterator.hasNext()) {
            Library library = libraryIterator.next();
            if (!name2.equals(library.getName())) continue;
            return library;
        }
        return null;
    }

    public void addListener(@NotNull LibraryTable.Listener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/impl/ModuleLibraryTable", "addListener"));
        }
        throw new UnsupportedOperationException();
    }

    public void addListener(@NotNull LibraryTable.Listener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/impl/ModuleLibraryTable", "addListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/roots/impl/ModuleLibraryTable", "addListener"));
        }
        throw new UnsupportedOperationException("Method addListener is not yet implemented in " + this.getClass().getName());
    }

    public void removeListener(@NotNull LibraryTable.Listener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/impl/ModuleLibraryTable", "removeListener"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Module getModule() {
        Module module2 = this.myRootModel.getModule();
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleLibraryTable", "getModule"));
        }
        return module2;
    }

    public void commit() {
    }

    public void dispose() {
    }

    public boolean isChanged() {
        return this.myRootModel.isChanged();
    }

    @NotNull
    public LibraryTable.ModifiableModel getModifiableModel() {
        ModuleLibraryTable moduleLibraryTable = this;
        if (moduleLibraryTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleLibraryTable", "getModifiableModel"));
        }
        return moduleLibraryTable;
    }

    private static class OrderEntryToLibraryConvertor
    implements Convertor<LibraryOrderEntry, Library> {
        private OrderEntryToLibraryConvertor() {
        }

        public Library convert(LibraryOrderEntry o) {
            return o.getLibrary();
        }
    }

    private static class ModuleLibraryOrderEntryCondition
    implements Condition<OrderEntry> {
        private ModuleLibraryOrderEntryCondition() {
        }

        public boolean value(OrderEntry entry) {
            return entry instanceof LibraryOrderEntry && ((LibraryOrderEntry)entry).isModuleLevel() && ((LibraryOrderEntry)entry).getLibrary() != null;
        }
    }
}

