/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NonProjectDirectoryInfo
extends DirectoryInfo {
    public static final NonProjectDirectoryInfo IGNORED = new NonProjectDirectoryInfo("ignored"){

        @Override
        public boolean isIgnored() {
            return true;
        }
    };
    public static final NonProjectDirectoryInfo EXCLUDED = new NonProjectDirectoryInfo("excluded from project"){

        @Override
        public boolean isExcluded() {
            return true;
        }
    };
    public static final NonProjectDirectoryInfo NOT_UNDER_PROJECT_ROOTS = new NonProjectDirectoryInfo("not under project roots");
    public static final NonProjectDirectoryInfo INVALID = new NonProjectDirectoryInfo("invalid");
    public static final NonProjectDirectoryInfo NOT_SUPPORTED_VIRTUAL_FILE_IMPLEMENTATION = new NonProjectDirectoryInfo("not supported VirtualFile implementation");
    private final String myDebugName;

    private NonProjectDirectoryInfo(String debugName) {
        this.myDebugName = debugName;
    }

    @Override
    public boolean isInProject() {
        return false;
    }

    @Override
    public boolean isInProject(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/NonProjectDirectoryInfo", "isInProject"));
        }
        return false;
    }

    public String toString() {
        return "DirectoryInfo: " + this.myDebugName;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    @Override
    @Nullable
    public VirtualFile getSourceRoot() {
        return null;
    }

    @Override
    public VirtualFile getLibraryClassRoot() {
        return null;
    }

    @Override
    @Nullable
    public VirtualFile getContentRoot() {
        return null;
    }

    @Override
    public boolean isInModuleSource() {
        return false;
    }

    @Override
    public boolean isInLibrarySource() {
        return false;
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/NonProjectDirectoryInfo", "isInLibrarySource"));
        }
        return false;
    }

    @Override
    public boolean isExcluded() {
        return false;
    }

    @Override
    public boolean isExcluded(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/NonProjectDirectoryInfo", "isExcluded"));
        }
        return this.isExcluded();
    }

    @Override
    public boolean isInModuleSource(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/NonProjectDirectoryInfo", "isInModuleSource"));
        }
        return false;
    }

    @Override
    public Module getModule() {
        return null;
    }

    @Override
    public String getUnloadedModuleName() {
        return null;
    }

    @Override
    public int getSourceRootTypeId() {
        return 0;
    }
}

