/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public class ProjectPackageIndexImpl
extends PackageIndex {
    private final DirectoryIndex myDirectoryIndex;

    public ProjectPackageIndexImpl(DirectoryIndex directoryIndex) {
        this.myDirectoryIndex = directoryIndex;
    }

    @NotNull
    public VirtualFile[] getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/openapi/roots/impl/ProjectPackageIndexImpl", "getDirectoriesByPackageName"));
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])this.getDirsByPackageName(packageName, includeLibrarySources).toArray((Object[])VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectPackageIndexImpl", "getDirectoriesByPackageName"));
        }
        return virtualFileArray;
    }

    @NotNull
    public Query<VirtualFile> getDirsByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/openapi/roots/impl/ProjectPackageIndexImpl", "getDirsByPackageName"));
        }
        Query<VirtualFile> query = this.myDirectoryIndex.getDirectoriesByPackageName(packageName, includeLibrarySources);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectPackageIndexImpl", "getDirsByPackageName"));
        }
        return query;
    }
}

