/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryTableBase
implements PersistentStateComponent<Element>,
LibraryTable,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.libraries.LibraryTableBase");
    private final EventDispatcher<LibraryTable.Listener> myDispatcher = EventDispatcher.create(LibraryTable.Listener.class);
    private LibraryModel myModel = new LibraryModel();
    private boolean myFirstLoad = true;
    private volatile long myModificationCount;

    @NotNull
    public LibraryTable.ModifiableModel getModifiableModel() {
        LibraryModel libraryModel = new LibraryModel(this.myModel);
        if (libraryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "getModifiableModel"));
        }
        return libraryModel;
    }

    public Element getState() {
        Element element = new Element("state");
        try {
            this.myModel.writeExternal(element);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return element;
    }

    public void noStateLoaded() {
        this.myFirstLoad = false;
    }

    public void loadState(Element element) {
        if (this.myFirstLoad) {
            this.myModel.readExternal(element);
        } else {
            LibraryModel model = new LibraryModel(this.myModel);
            WriteAction.run(() -> {
                model.readExternal(element);
                this.commit(model);
            });
        }
        this.myFirstLoad = false;
    }

    public long getStateModificationCount() {
        return this.myModificationCount;
    }

    @NotNull
    public Library[] getLibraries() {
        Library[] libraryArray = this.myModel.getLibraries();
        if (libraryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "getLibraries"));
        }
        return libraryArray;
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        Iterator<Library> iterator = this.myModel.getLibraryIterator();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "getLibraryIterator"));
        }
        return iterator;
    }

    public Library getLibraryByName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "getLibraryByName"));
        }
        return this.myModel.getLibraryByName(name2);
    }

    public void addListener(@NotNull LibraryTable.Listener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addListener(@NotNull LibraryTable.Listener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "addListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeListener(@NotNull LibraryTable.Listener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "removeListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    private void fireLibraryAdded(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "fireLibraryAdded"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("fireLibraryAdded: " + library);
        }
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).afterLibraryAdded(library);
    }

    private void fireBeforeLibraryRemoved(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "fireBeforeLibraryRemoved"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("fireBeforeLibraryRemoved: " + library);
        }
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).beforeLibraryRemoved(library);
    }

    public void dispose() {
        for (Library library : this.getLibraries()) {
            Disposer.dispose((Disposable)library);
        }
    }

    public Library createLibrary() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        return this.createLibrary(null);
    }

    void fireLibraryRenamed(@NotNull LibraryImpl library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "fireLibraryRenamed"));
        }
        this.incrementModificationCount();
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).afterLibraryRenamed((Library)library);
    }

    private void incrementModificationCount() {
        if (Registry.is((String)"store.track.module.root.manager.changes", (boolean)false)) {
            LOG.error("library");
        }
        ++this.myModificationCount;
    }

    public Library createLibrary(String name2) {
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        Library library = modifiableModel.createLibrary(name2);
        modifiableModel.commit();
        return library;
    }

    public void removeLibrary(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "removeLibrary"));
        }
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        modifiableModel.removeLibrary(library);
        modifiableModel.commit();
    }

    private void commit(LibraryModel model) {
        this.myFirstLoad = false;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!model.isChanged()) {
            Disposer.dispose((Disposable)model);
            return;
        }
        this.incrementModificationCount();
        THashSet addedLibraries = ContainerUtil.newIdentityTroveSet((Collection)model.myLibraries);
        addedLibraries.removeAll(this.myModel.myLibraries);
        THashSet removedLibraries = ContainerUtil.newIdentityTroveSet((Collection)this.myModel.myLibraries);
        removedLibraries.removeAll(model.myLibraries);
        for (Library library : removedLibraries) {
            this.fireBeforeLibraryRemoved(library);
        }
        this.myModel.copyFrom(model);
        for (Library library : removedLibraries) {
            Disposer.dispose((Disposable)library);
            this.fireAfterLibraryRemoved(library);
        }
        for (Library library : addedLibraries) {
            this.fireLibraryAdded(library);
        }
        Disposer.dispose((Disposable)model);
    }

    private void fireAfterLibraryRemoved(Library library) {
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).afterLibraryRemoved(library);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myModel = new LibraryModel();
        this.myModel.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myModel.writeExternal(element);
    }

    public class LibraryModel
    implements LibraryTable.ModifiableModel,
    JDOMExternalizable,
    LibraryTable.Listener,
    Disposable {
        private final ArrayList<Library> myLibraries = new ArrayList();
        private volatile Map<String, Library> myLibraryByNameCache;
        private boolean myWritable;

        private LibraryModel() {
            LibraryTableBase.this.myDispatcher.addListener((EventListener)((Object)this));
            this.myWritable = false;
        }

        private LibraryModel(LibraryModel that) {
            LibraryTableBase.this.myDispatcher.addListener((EventListener)((Object)this));
            this.myWritable = true;
            this.myLibraries.addAll(that.myLibraries);
        }

        public void commit() {
            LibraryTableBase.this.commit(this);
            this.myWritable = false;
        }

        public void dispose() {
            LibraryTableBase.this.myDispatcher.removeListener((EventListener)((Object)this));
        }

        @NotNull
        public Iterator<Library> getLibraryIterator() {
            Iterator<Library> iterator = Collections.unmodifiableList(this.myLibraries).iterator();
            if (iterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel", "getLibraryIterator"));
            }
            return iterator;
        }

        @Nullable
        public Library getLibraryByName(@NotNull String name2) {
            Library library;
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel", "getLibraryByName"));
            }
            Map<String, Library> cache = this.myLibraryByNameCache;
            if (cache == null) {
                cache = new HashMap<String, Library>();
                for (Library library2 : this.myLibraries) {
                    cache.put(library2.getName(), library2);
                }
                this.myLibraryByNameCache = cache;
            }
            if ((library = cache.get(name2)) != null) {
                return library;
            }
            String libraryPrefix = "library.";
            String libPath = System.getProperty("library." + name2);
            if (libPath != null) {
                LibraryImpl libraryFromProperty = new LibraryImpl(name2, null, LibraryTableBase.this, null, null);
                libraryFromProperty.addRoot(libPath, OrderRootType.CLASSES);
                return libraryFromProperty;
            }
            return null;
        }

        @NotNull
        public Library[] getLibraries() {
            Library[] libraryArray = this.myLibraries.toArray(new Library[this.myLibraries.size()]);
            if (libraryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel", "getLibraries"));
            }
            return libraryArray;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myWritable);
        }

        public Library createLibrary(String name2) {
            return this.createLibrary(name2, null);
        }

        public Library createLibrary(String name2, @Nullable PersistentLibraryKind kind2) {
            return this.createLibrary(name2, kind2, null);
        }

        public Library createLibrary(String name2, @Nullable PersistentLibraryKind kind2, @Nullable ProjectModelExternalSource externalSource) {
            this.assertWritable();
            LibraryImpl library = new LibraryImpl(name2, kind2, LibraryTableBase.this, null, externalSource);
            this.myLibraries.add((Library)library);
            this.myLibraryByNameCache = null;
            return library;
        }

        public void removeLibrary(@NotNull Library library) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel", "removeLibrary"));
            }
            LibraryTableBase.this.incrementModificationCount();
            this.assertWritable();
            this.myLibraries.remove(library);
            this.myLibraryByNameCache = null;
        }

        public boolean isChanged() {
            if (!this.myWritable) {
                return false;
            }
            HashSet thisLibraries = new HashSet(this.myLibraries);
            HashSet thatLibraries = new HashSet(((LibraryTableBase)LibraryTableBase.this).myModel.myLibraries);
            return !thisLibraries.equals(thatLibraries);
        }

        public void readExternal(Element element) {
            this.myLibraries.clear();
            List libraryElements = element.getChildren("library");
            for (Element libraryElement : libraryElements) {
                LibraryImpl library = new LibraryImpl(LibraryTableBase.this, libraryElement, null);
                if (library.getName() != null) {
                    this.myLibraries.add((Library)library);
                    LibraryTableBase.this.fireLibraryAdded((Library)library);
                    continue;
                }
                Disposer.dispose((Disposable)library);
            }
            this.myLibraryByNameCache = null;
        }

        public void afterLibraryRenamed(@NotNull Library library) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel", "afterLibraryRenamed"));
            }
            this.myLibraryByNameCache = null;
        }

        public void writeExternal(Element element) {
            List libraries = ContainerUtil.findAll(this.myLibraries, library -> !((LibraryEx)library).isDisposed());
            ContainerUtil.sort((List)libraries, (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true));
            for (Library library2 : libraries) {
                if (library2.getName() == null) continue;
                library2.writeExternal(element);
            }
        }

        void copyFrom(LibraryModel model) {
            this.myLibraries.clear();
            this.myLibraries.addAll(model.myLibraries);
            this.myLibraryByNameCache = null;
        }
    }
}

