/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.InvalidDataException;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryTableImplUtil {
    @NonNls
    public static final String MODULE_LEVEL = "module";

    private LibraryTableImplUtil() {
    }

    @NotNull
    public static Library loadLibrary(@NotNull Element rootElement, @NotNull RootModelImpl rootModel) throws InvalidDataException {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/openapi/roots/impl/libraries/LibraryTableImplUtil", "loadLibrary"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/libraries/LibraryTableImplUtil", "loadLibrary"));
        }
        List children2 = rootElement.getChildren("library");
        if (children2.size() != 1) {
            throw new InvalidDataException();
        }
        Element element = (Element)children2.get(0);
        LibraryImpl libraryImpl = new LibraryImpl(null, element, (ModifiableRootModel)rootModel);
        if (libraryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryTableImplUtil", "loadLibrary"));
        }
        return libraryImpl;
    }

    @NotNull
    public static Library createModuleLevelLibrary(@Nullable String name2, PersistentLibraryKind kind2, @NotNull RootModelImpl rootModel, @Nullable ProjectModelExternalSource externalSource) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/libraries/LibraryTableImplUtil", "createModuleLevelLibrary"));
        }
        LibraryImpl libraryImpl = new LibraryImpl(name2, kind2, null, rootModel, externalSource);
        if (libraryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryTableImplUtil", "createModuleLevelLibrary"));
        }
        return libraryImpl;
    }
}

