/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.storage;

import com.intellij.ProjectTopics;
import com.intellij.application.options.PathMacrosCollector;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.configurationStore.StorageManagerListener;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClasspathStorage
extends StateStorageBase<Boolean> {
    private static final Key<Boolean> ERROR_NOTIFIED_KEY = Key.create((String)"ClasspathStorage.ERROR_NOTIFIED_KEY");
    private static final Logger LOG = Logger.getInstance(ClasspathStorage.class);
    private final ClasspathStorageProvider.ClasspathConverter myConverter;
    private final TrackingPathMacroSubstitutor myPathMacroSubstitutor;

    public ClasspathStorage(final @NotNull Module module2, @NotNull StateStorageManager storageManager2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "<init>"));
        }
        if (storageManager2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "<init>"));
        }
        String storageType = module2.getOptionValue("classpath");
        if (storageType == null) {
            throw new IllegalStateException("Classpath storage requires non-default storage type");
        }
        ClasspathStorageProvider provider = ClasspathStorage.getProvider(storageType);
        if (provider == null) {
            if (module2.getUserData(ERROR_NOTIFIED_KEY) == null) {
                Notification n = new Notification(StorageUtilKt.getNOTIFICATION_GROUP_ID(), "Cannot load module '" + module2.getName() + "'", "Support for " + storageType + " format is not installed.", NotificationType.ERROR);
                n.notify(module2.getProject());
                module2.putUserData(ERROR_NOTIFIED_KEY, (Object)Boolean.TRUE);
                LOG.info("Classpath storage provider " + storageType + " not found");
            }
            this.myConverter = new MissingClasspathConverter();
        } else {
            this.myConverter = provider.createConverter(module2);
        }
        this.myPathMacroSubstitutor = storageManager2.getMacroSubstitutor();
        final List<String> paths = this.myConverter.getFilePaths();
        MessageBusConnection busConnection = module2.getMessageBus().connect();
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/roots/impl/storage/ClasspathStorage$1", "after"));
                }
                if (paths.isEmpty()) {
                    return;
                }
                for (VFileEvent vFileEvent : events) {
                    if (!vFileEvent.isFromRefresh() || !(vFileEvent instanceof VFileContentChangeEvent)) continue;
                    String eventPath = vFileEvent.getPath();
                    for (String path : paths) {
                        if (!path.equals(eventPath)) continue;
                        ((StorageManagerListener)module2.getMessageBus().syncPublisher(StateStorageManagerKt.getSTORAGE_TOPIC())).storageFileChanged(vFileEvent, ClasspathStorage.this, (ComponentManager)module2);
                        return;
                    }
                }
            }
        });
        busConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void modulesRenamed(@NotNull Project project2, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/storage/ClasspathStorage$2", "modulesRenamed"));
                }
                if (modules == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/openapi/roots/impl/storage/ClasspathStorage$2", "modulesRenamed"));
                }
                if (oldNameProvider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNameProvider", "com/intellij/openapi/roots/impl/storage/ClasspathStorage$2", "modulesRenamed"));
                }
                for (Module renamedModule : modules) {
                    ClasspathStorageProvider provider;
                    if (!renamedModule.equals(module2) || (provider = ClasspathStorage.getProvider(ClassPathStorageUtil.getStorageType(module2))) == null) continue;
                    provider.moduleRenamed(module2, (String)oldNameProvider.fun((Object)module2), module2.getName());
                    provider.modulePathChanged(module2);
                }
            }
        });
    }

    @Override
    @Nullable
    public <S> S deserializeState(@Nullable Element serializedState, @NotNull Class<S> stateClass, @Nullable S mergeInto) {
        if (stateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateClass", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "deserializeState"));
        }
        if (serializedState == null) {
            return null;
        }
        ModuleRootManagerImpl.ModuleRootManagerState state = new ModuleRootManagerImpl.ModuleRootManagerState();
        state.readExternal(serializedState);
        return (S)state;
    }

    @Override
    protected boolean hasState(@NotNull Boolean storageData, @NotNull String componentName) {
        if (storageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "hasState"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "hasState"));
        }
        return storageData == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Element getSerializedState(@NotNull Boolean storageData, Object component, @NotNull String componentName, boolean archive) {
        if (storageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getSerializedState"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getSerializedState"));
        }
        if (storageData.booleanValue()) {
            return null;
        }
        Element element = new Element("component");
        ModifiableRootModel model = null;
        AccessToken token = ReadAction.start();
        try {
            model = ((ModuleRootManagerImpl)((Object)component)).getModifiableModel();
            model.clear();
            try {
                this.myConverter.readClasspath(model);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ((RootModelImpl)model).writeExternal(element);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                token.finish();
            }
            finally {
                if (model != null) {
                    model.dispose();
                }
            }
        }
        if (this.myPathMacroSubstitutor != null) {
            this.myPathMacroSubstitutor.expandPaths(element);
            this.myPathMacroSubstitutor.addUnknownMacros("NewModuleRootManager", PathMacrosCollector.getMacroNames(element));
        }
        this.getStorageDataRef().set(true);
        return element;
    }

    @Override
    @NotNull
    protected Boolean loadData() {
        Boolean bl = false;
        if (bl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "loadData"));
        }
        return bl;
    }

    @NotNull
    public StateStorage.ExternalizationSession startExternalization() {
        StateStorage.ExternalizationSession externalizationSession = this.myConverter.startExternalization();
        if (externalizationSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "startExternalization"));
        }
        return externalizationSession;
    }

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Set<String> componentNames) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
        componentNames.add("NewModuleRootManager");
        this.getStorageDataRef().set(false);
    }

    @Nullable
    public static ClasspathStorageProvider getProvider(@NotNull String type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getProvider"));
        }
        if (type2.equals("default")) {
            return null;
        }
        for (ClasspathStorageProvider provider : (ClasspathStorageProvider[])ClasspathStorageProvider.EXTENSION_POINT_NAME.getExtensions()) {
            if (!type2.equals(provider.getID())) continue;
            return provider;
        }
        return null;
    }

    @NotNull
    public static String getStorageRootFromOptions(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getStorageRootFromOptions"));
        }
        String moduleRoot = ModuleUtilCore.getModuleDirPath((Module)module2);
        String storageRef = module2.getOptionValue("classpath-dir");
        if (storageRef == null) {
            String string = moduleRoot;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getStorageRootFromOptions"));
            }
            return string;
        }
        storageRef = FileUtil.toSystemIndependentName((String)storageRef);
        if (SystemInfo.isWindows ? FileUtil.isAbsolutePlatformIndependent((String)storageRef) : FileUtil.isUnixAbsolutePath((String)storageRef)) {
            String string = storageRef;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getStorageRootFromOptions"));
            }
            return string;
        }
        String string = moduleRoot + '/' + storageRef;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getStorageRootFromOptions"));
        }
        return string;
    }

    public static void setStorageType(@NotNull ModuleRootModel model, @NotNull String storageId) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "setStorageType"));
        }
        if (storageId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageId", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "setStorageType"));
        }
        Module module2 = model.getModule();
        String oldStorageType = ClassPathStorageUtil.getStorageType(module2);
        if (oldStorageType.equals(storageId)) {
            return;
        }
        ClasspathStorageProvider provider = ClasspathStorage.getProvider(oldStorageType);
        if (provider != null) {
            provider.detach(module2);
        }
        module2.setOption("classpath", (provider = ClasspathStorage.getProvider(storageId)) == null ? null : storageId);
        module2.setOption("classpath-dir", provider == null ? null : provider.getContentRoot(model));
    }

    public static void modulePathChanged(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "modulePathChanged"));
        }
        ClasspathStorageProvider provider = ClasspathStorage.getProvider(ClassPathStorageUtil.getStorageType(module2));
        if (provider != null) {
            provider.modulePathChanged(module2);
        }
    }

    private static class MissingClasspathConverter
    implements ClasspathStorageProvider.ClasspathConverter {
        private MissingClasspathConverter() {
        }

        @Override
        @NotNull
        public List<String> getFilePaths() {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage$MissingClasspathConverter", "getFilePaths"));
            }
            return list2;
        }

        @Override
        @NotNull
        public StateStorage.ExternalizationSession startExternalization() {
            StateStorage.ExternalizationSession externalizationSession = new StateStorage.ExternalizationSession(){

                @Nullable
                public StateStorage.SaveSession createSaveSession() {
                    return null;
                }
            };
            if (externalizationSession == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage$MissingClasspathConverter", "startExternalization"));
            }
            return externalizationSession;
        }

        @Override
        public void readClasspath(@NotNull ModifiableRootModel model) throws IOException {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/roots/impl/storage/ClasspathStorage$MissingClasspathConverter", "readClasspath"));
            }
        }
    }
}

