/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryType<P extends LibraryProperties>
extends LibraryPresentationProvider<P> {
    public static final ExtensionPointName<LibraryType<?>> EP_NAME = ExtensionPointName.create((String)"com.intellij.library.type");
    public static final OrderRootType[] DEFAULT_EXTERNAL_ROOT_TYPES = new OrderRootType[]{OrderRootType.CLASSES};

    protected LibraryType(@NotNull PersistentLibraryKind<P> libraryKind) {
        if (libraryKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryKind", "com/intellij/openapi/roots/libraries/LibraryType", "<init>"));
        }
        super((LibraryKind)libraryKind);
    }

    @NotNull
    public PersistentLibraryKind<P> getKind() {
        PersistentLibraryKind persistentLibraryKind = (PersistentLibraryKind)super.getKind();
        if (persistentLibraryKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/LibraryType", "getKind"));
        }
        return persistentLibraryKind;
    }

    @Nullable
    public abstract String getCreateActionName();

    @Nullable
    public abstract NewLibraryConfiguration createNewLibrary(@NotNull JComponent var1, @Nullable VirtualFile var2, @NotNull Project var3);

    public boolean isSuitableModule(@NotNull Module module2, @NotNull FacetsProvider facetsProvider) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/libraries/LibraryType", "isSuitableModule"));
        }
        if (facetsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetsProvider", "com/intellij/openapi/roots/libraries/LibraryType", "isSuitableModule"));
        }
        return true;
    }

    @Nullable
    public LibraryRootsComponentDescriptor createLibraryRootsComponentDescriptor() {
        return null;
    }

    @Nullable
    public abstract LibraryPropertiesEditor createPropertiesEditor(@NotNull LibraryEditorComponent<P> var1);

    @Override
    public P detect(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "com/intellij/openapi/roots/libraries/LibraryType", "detect"));
        }
        return null;
    }

    public OrderRootType[] getExternalRootTypes() {
        return DEFAULT_EXTERNAL_ROOT_TYPES;
    }

    public static LibraryType findByKind(LibraryKind kind2) {
        for (LibraryType type2 : (LibraryType[])EP_NAME.getExtensions()) {
            if (type2.getKind() != kind2) continue;
            return type2;
        }
        throw new IllegalArgumentException("Library with kind " + kind2 + " is not registered");
    }
}

