/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ModificationOfImportedModelWarningComponent {
    private final JLabel myLabel = new JLabel();

    public ModificationOfImportedModelWarningComponent() {
        this.hideWarning();
    }

    public JLabel getLabel() {
        return this.myLabel;
    }

    public void showWarning(@NotNull String elementDescription, @NotNull ProjectModelExternalSource externalSource) {
        if (elementDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementDescription", "com/intellij/openapi/roots/ui/configuration/ModificationOfImportedModelWarningComponent", "showWarning"));
        }
        if (externalSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSource", "com/intellij/openapi/roots/ui/configuration/ModificationOfImportedModelWarningComponent", "showWarning"));
        }
        this.myLabel.setVisible(true);
        this.myLabel.setBorder((Border)JBUI.Borders.empty((int)5, (int)5));
        this.myLabel.setIcon(AllIcons.General.Warning);
        this.myLabel.setText(UIUtil.toHtml((String)ModificationOfImportedModelWarningComponent.getWarningText(elementDescription, externalSource)));
    }

    @NotNull
    public static String getWarningText(@NotNull String elementDescription, @NotNull ProjectModelExternalSource externalSource) {
        if (elementDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementDescription", "com/intellij/openapi/roots/ui/configuration/ModificationOfImportedModelWarningComponent", "getWarningText"));
        }
        if (externalSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSource", "com/intellij/openapi/roots/ui/configuration/ModificationOfImportedModelWarningComponent", "getWarningText"));
        }
        String string = elementDescription + " is imported from " + externalSource.getDisplayName() + ". Any changes made in its configuration may be lost after reimporting.";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/ModificationOfImportedModelWarningComponent", "getWarningText"));
        }
        return string;
    }

    public void hideWarning() {
        this.myLabel.setVisible(false);
    }
}

