/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.CompositeDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.navigation.History;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleElementsEditor
implements ModuleConfigurationEditor {
    @NotNull
    protected final Project myProject;
    protected JComponent myComponent;
    private final CompositeDisposable myDisposables;
    private final EventDispatcher<ModuleElementsEditorListener> myDispatcher;
    protected History myHistory;
    private final ModuleConfigurationState myState;

    protected ModuleElementsEditor(@NotNull ModuleConfigurationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/roots/ui/configuration/ModuleElementsEditor", "<init>"));
        }
        this.myDisposables = new CompositeDisposable();
        this.myDispatcher = EventDispatcher.create(ModuleElementsEditorListener.class);
        this.myProject = state.getProject();
        this.myState = state;
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    public void addListener(ModuleElementsEditorListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    protected void fireConfigurationChanged() {
        ((ModuleElementsEditorListener)this.myDispatcher.getMulticaster()).configurationChanged();
    }

    public boolean isModified() {
        return this.getModel() != null && this.getModel().isChanged();
    }

    protected ModifiableRootModel getModel() {
        return this.myState.getRootModel();
    }

    @NotNull
    protected ModuleConfigurationState getState() {
        ModuleConfigurationState moduleConfigurationState = this.myState;
        if (moduleConfigurationState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/ModuleElementsEditor", "getState"));
        }
        return moduleConfigurationState;
    }

    public void canApply() throws ConfigurationException {
    }

    public void apply() throws ConfigurationException {
    }

    public void reset() {
    }

    public void moduleCompileOutputChanged(String baseUrl, String moduleName) {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposables);
    }

    public final JComponent createComponent() {
        if (this.myComponent == null) {
            this.myComponent = this.createComponentImpl();
        }
        return this.myComponent;
    }

    public JComponent getComponent() {
        return this.createComponent();
    }

    protected void registerDisposable(Disposable disposable) {
        this.myDisposables.add(disposable);
    }

    protected abstract JComponent createComponentImpl();

    static interface ModuleElementsEditorListener
    extends EventListener {
        public void configurationChanged();
    }
}

