/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.ui.LibraryElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibrarySourceItem
extends PackagingSourceItem {
    private final Library myLibrary;

    public LibrarySourceItem(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem", "<init>"));
        }
        this.myLibrary = library;
    }

    public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem", "createPresentation"));
        }
        return new LibrarySourceItemPresentation(this.myLibrary, context);
    }

    public boolean equals(Object obj) {
        return obj instanceof LibrarySourceItem && this.myLibrary.equals(((LibrarySourceItem)((Object)obj)).myLibrary);
    }

    public int hashCode() {
        return this.myLibrary.hashCode();
    }

    @NotNull
    public Library getLibrary() {
        Library library = this.myLibrary;
        if (library == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem", "getLibrary"));
        }
        return library;
    }

    @NotNull
    public PackagingElementOutputKind getKindOfProducedElements() {
        PackagingElementOutputKind packagingElementOutputKind = LibraryPackagingElement.getKindForLibrary(this.myLibrary);
        if (packagingElementOutputKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem", "getKindOfProducedElements"));
        }
        return packagingElementOutputKind;
    }

    @NotNull
    public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem", "createElements"));
        }
        List list2 = PackagingElementFactory.getInstance().createLibraryElements(this.myLibrary);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem", "createElements"));
        }
        return list2;
    }

    private static class LibrarySourceItemPresentation
    extends SourceItemPresentation {
        private final Library myLibrary;
        private final ArtifactEditorContext myContext;

        public LibrarySourceItemPresentation(Library library, ArtifactEditorContext context) {
            this.myLibrary = library;
            this.myContext = context;
        }

        public boolean canNavigateToSource() {
            return this.myLibrary != null;
        }

        public void navigateToSource() {
            this.myContext.selectLibrary(this.myLibrary);
        }

        public String getPresentableName() {
            return LibraryUtil.getPresentableName((Library)this.myLibrary);
        }

        public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
            if (presentationData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationData", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem$LibrarySourceItemPresentation", "render"));
            }
            String name2 = this.myLibrary.getName();
            if (name2 != null) {
                presentationData.setIcon(PlatformIcons.LIBRARY_ICON);
                presentationData.addText(name2, mainAttributes);
                presentationData.addText(LibraryElementPresentation.getLibraryTableComment(this.myLibrary), commentAttributes);
            } else {
                if (((LibraryEx)this.myLibrary).isDisposed()) {
                    presentationData.addText("Invalid Library", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    return;
                }
                VirtualFile[] files = this.myLibrary.getFiles(OrderRootType.CLASSES);
                if (files.length > 0) {
                    VirtualFile file2 = files[0];
                    presentationData.setIcon(VirtualFilePresentation.getIcon((VirtualFile)file2));
                    presentationData.addText(file2.getName(), mainAttributes);
                } else {
                    presentationData.addText("Empty Library", SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
            }
        }

        public int getWeight() {
            return 10;
        }
    }
}

