/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraries.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryDetectionManager;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryPresentationManagerImpl
extends LibraryPresentationManager {
    private Map<LibraryKind, LibraryPresentationProvider<?>> myPresentationProviders;

    public static List<LibraryKind> getLibraryKinds(@NotNull Library library, @Nullable StructureConfigurableContext context) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "getLibraryKinds"));
        }
        SmartList result2 = new SmartList();
        PersistentLibraryKind kind2 = ((LibraryEx)library).getKind();
        if (kind2 != null) {
            result2.add(kind2);
        }
        VirtualFile[] files = LibraryPresentationManagerImpl.getLibraryFiles(library, context);
        LibraryDetectionManager.getInstance().processProperties(Arrays.asList(files), new LibraryDetectionManager.LibraryPropertiesProcessor((List)result2){
            final /* synthetic */ List val$result;
            {
                this.val$result = list2;
            }

            @Override
            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind kind2, @NotNull P properties) {
                if (kind2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$1", "processProperties"));
                }
                if (properties == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$1", "processProperties"));
                }
                this.val$result.add(kind2);
                return true;
            }
        });
        return result2;
    }

    @NotNull
    private static VirtualFile[] getLibraryFiles(@NotNull Library library, @Nullable StructureConfigurableContext context) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "getLibraryFiles"));
        }
        if (((LibraryEx)library).isDisposed()) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "getLibraryFiles"));
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] virtualFileArray = context != null ? context.getLibraryFiles(library, OrderRootType.CLASSES) : library.getFiles(OrderRootType.CLASSES);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "getLibraryFiles"));
        }
        return virtualFileArray;
    }

    private <P extends LibraryProperties> LibraryPresentationProvider<P> getPresentationProvider(LibraryKind kind2) {
        if (this.myPresentationProviders == null) {
            HashMap providers2 = new HashMap();
            for (LibraryType type2 : (LibraryType[])LibraryType.EP_NAME.getExtensions()) {
                providers2.put((LibraryKind)type2.getKind(), type2);
            }
            for (LibraryPresentationProvider provider : (LibraryPresentationProvider[])LibraryPresentationProvider.EP_NAME.getExtensions()) {
                providers2.put(provider.getKind(), provider);
            }
            this.myPresentationProviders = providers2;
        }
        return this.myPresentationProviders.get(kind2);
    }

    @Override
    @NotNull
    public Icon getNamedLibraryIcon(@NotNull Library library, @Nullable StructureConfigurableContext context) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "getNamedLibraryIcon"));
        }
        Icon icon = this.getCustomIcon(library, context);
        Icon icon2 = icon != null ? icon : PlatformIcons.LIBRARY_ICON;
        if (icon2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "getNamedLibraryIcon"));
        }
        return icon2;
    }

    @Override
    public Icon getCustomIcon(@NotNull Library library, StructureConfigurableContext context) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "getCustomIcon"));
        }
        LibraryEx libraryEx = (LibraryEx)library;
        PersistentLibraryKind kind2 = libraryEx.getKind();
        if (kind2 != null) {
            return LibraryType.findByKind((LibraryKind)kind2).getIcon(libraryEx.getProperties());
        }
        List<Icon> icons = this.getCustomIcons(library, context);
        if (icons.size() == 1) {
            return icons.get(0);
        }
        return null;
    }

    @Override
    @NotNull
    public List<Icon> getCustomIcons(@NotNull Library library, StructureConfigurableContext context) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "getCustomIcons"));
        }
        VirtualFile[] files = LibraryPresentationManagerImpl.getLibraryFiles(library, context);
        SmartList icons = new SmartList();
        LibraryDetectionManager.getInstance().processProperties(Arrays.asList(files), new LibraryDetectionManager.LibraryPropertiesProcessor((List)icons){
            final /* synthetic */ List val$icons;
            {
                this.val$icons = list2;
            }

            @Override
            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind kind2, @NotNull P properties) {
                if (kind2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$2", "processProperties"));
                }
                if (properties == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$2", "processProperties"));
                }
                LibraryPresentationProvider provider = LibraryPresentationManagerImpl.this.getPresentationProvider(kind2);
                if (provider != null) {
                    ContainerUtil.addIfNotNull((Collection)this.val$icons, (Object)provider.getIcon(properties));
                }
                return true;
            }
        });
        SmartList smartList = icons;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "getCustomIcons"));
        }
        return smartList;
    }

    @Override
    public boolean isLibraryOfKind(@NotNull List<VirtualFile> files, final @NotNull LibraryKind kind2) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "isLibraryOfKind"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "isLibraryOfKind"));
        }
        return !LibraryDetectionManager.getInstance().processProperties(files, new LibraryDetectionManager.LibraryPropertiesProcessor(){

            @Override
            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind processedKind, @NotNull P properties) {
                if (processedKind == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedKind", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$3", "processProperties"));
                }
                if (properties == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$3", "processProperties"));
                }
                return !kind2.equals(processedKind);
            }
        });
    }

    @Override
    public boolean isLibraryOfKind(@NotNull Library library, @NotNull LibrariesContainer librariesContainer, final @NotNull Set<? extends LibraryKind> acceptedKinds) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "isLibraryOfKind"));
        }
        if (librariesContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "librariesContainer", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "isLibraryOfKind"));
        }
        if (acceptedKinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "acceptedKinds", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "isLibraryOfKind"));
        }
        PersistentLibraryKind type2 = ((LibraryEx)library).getKind();
        if (type2 != null && acceptedKinds.contains(type2)) {
            return true;
        }
        VirtualFile[] files = librariesContainer.getLibraryFiles(library, OrderRootType.CLASSES);
        return !LibraryDetectionManager.getInstance().processProperties(Arrays.asList(files), new LibraryDetectionManager.LibraryPropertiesProcessor(){

            @Override
            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind processedKind, @NotNull P properties) {
                if (processedKind == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedKind", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$4", "processProperties"));
                }
                if (properties == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$4", "processProperties"));
                }
                return !acceptedKinds.contains(processedKind);
            }
        });
    }

    @Override
    @NotNull
    public List<String> getDescriptions(@NotNull Library library, StructureConfigurableContext context) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "getDescriptions"));
        }
        VirtualFile[] files = LibraryPresentationManagerImpl.getLibraryFiles(library, context);
        List<String> list2 = this.getDescriptions(files, Collections.emptySet());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "getDescriptions"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<String> getDescriptions(@NotNull VirtualFile[] classRoots, final Set<LibraryKind> excludedKinds) {
        if (classRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classRoots", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "getDescriptions"));
        }
        final SmartList result2 = new SmartList();
        LibraryDetectionManager.getInstance().processProperties(Arrays.asList(classRoots), new LibraryDetectionManager.LibraryPropertiesProcessor(){

            @Override
            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind kind2, @NotNull P properties) {
                LibraryPresentationProvider provider;
                if (kind2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$5", "processProperties"));
                }
                if (properties == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$5", "processProperties"));
                }
                if (!excludedKinds.contains(kind2) && (provider = LibraryPresentationManagerImpl.this.getPresentationProvider(kind2)) != null) {
                    ContainerUtil.addIfNotNull((Collection)result2, (Object)provider.getDescription(properties));
                }
                return true;
            }
        });
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "getDescriptions"));
        }
        return smartList;
    }

    @Override
    public List<Library> getLibraries(@NotNull Set<LibraryKind> kinds, @NotNull Project project2, @Nullable StructureConfigurableContext context) {
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "getLibraries"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl", "getLibraries"));
        }
        ArrayList<Library> libraries = new ArrayList<Library>();
        if (context != null) {
            Collections.addAll(libraries, context.getProjectLibrariesProvider().getModifiableModel().getLibraries());
            Collections.addAll(libraries, context.getGlobalLibrariesProvider().getModifiableModel().getLibraries());
        } else {
            LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
            Collections.addAll(libraries, registrar.getLibraryTable(project2).getLibraries());
            Collections.addAll(libraries, registrar.getLibraryTable().getLibraries());
        }
        Iterator iterator = libraries.iterator();
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            List<LibraryKind> libraryKinds = LibraryPresentationManagerImpl.getLibraryKinds(library, context);
            if (ContainerUtil.intersects(libraryKinds, kinds)) continue;
            iterator.remove();
        }
        return libraries;
    }
}

