/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.JarDirectories;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewLibraryEditor
extends LibraryEditorBase {
    private String myLibraryName;
    private final MultiMap<OrderRootType, LightFilePointer> myRoots;
    private final Set<LightFilePointer> myExcludedRoots;
    private final JarDirectories myJarDirectories = new JarDirectories();
    private LibraryType myType;
    private LibraryProperties myProperties;
    private boolean myKeepInvalidUrls = true;

    public NewLibraryEditor() {
        this(null, null);
    }

    public NewLibraryEditor(@Nullable LibraryType type2, @Nullable LibraryProperties properties) {
        this.myType = type2;
        this.myProperties = properties;
        this.myRoots = new MultiMap();
        this.myExcludedRoots = new LinkedHashSet<LightFilePointer>();
    }

    public boolean isKeepInvalidUrls() {
        return this.myKeepInvalidUrls;
    }

    public void setKeepInvalidUrls(boolean keepInvalidUrls) {
        this.myKeepInvalidUrls = keepInvalidUrls;
    }

    @Override
    public Collection<OrderRootType> getOrderRootTypes() {
        return this.myRoots.keySet();
    }

    @Override
    @Nullable
    public LibraryType<?> getType() {
        return this.myType;
    }

    @Override
    public void setType(@NotNull LibraryType<?> type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/ui/configuration/libraryEditor/NewLibraryEditor", "setType"));
        }
        this.myType = type2;
    }

    @Override
    public LibraryProperties getProperties() {
        return this.myProperties;
    }

    @Override
    public void setProperties(LibraryProperties properties) {
        this.myProperties = properties;
    }

    @Override
    public String getName() {
        return this.myLibraryName;
    }

    @Override
    public String[] getUrls(OrderRootType rootType) {
        return NewLibraryEditor.pointersToUrls(this.myRoots.get((Object)rootType));
    }

    private static String[] pointersToUrls(Collection<LightFilePointer> pointers) {
        ArrayList<String> urls = new ArrayList<String>(pointers.size());
        for (LightFilePointer pointer : pointers) {
            urls.add(pointer.getUrl());
        }
        return ArrayUtil.toStringArray(urls);
    }

    @Override
    public VirtualFile[] getFiles(OrderRootType rootType) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (LightFilePointer pointer : this.myRoots.get((Object)rootType)) {
            String url;
            VirtualFile file2 = pointer.getFile();
            if (file2 == null) continue;
            if (file2.isDirectory() && this.myJarDirectories.contains(rootType, url = file2.getUrl())) {
                LibraryImpl.collectJarFiles(file2, result2, this.myJarDirectories.isRecursive(rootType, url));
                continue;
            }
            result2.add(file2);
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    @Override
    public String[] getExcludedRootUrls() {
        return NewLibraryEditor.pointersToUrls(this.myExcludedRoots);
    }

    @Override
    public void setName(String name2) {
        this.myLibraryName = name2;
    }

    @Override
    public void addRoot(VirtualFile file2, OrderRootType rootType) {
        this.myRoots.putValue((Object)rootType, (Object)new LightFilePointer(file2));
    }

    @Override
    public void addRoot(String url, OrderRootType rootType) {
        this.myRoots.putValue((Object)rootType, (Object)new LightFilePointer(url));
    }

    @Override
    public void addJarDirectory(VirtualFile file2, boolean recursive, OrderRootType rootType) {
        this.addJarDirectory(file2.getUrl(), recursive, rootType);
    }

    @Override
    public void addExcludedRoot(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/ui/configuration/libraryEditor/NewLibraryEditor", "addExcludedRoot"));
        }
        this.myExcludedRoots.add(new LightFilePointer(url));
    }

    @Override
    public void removeExcludedRoot(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/ui/configuration/libraryEditor/NewLibraryEditor", "removeExcludedRoot"));
        }
        this.myExcludedRoots.remove(new LightFilePointer(url));
    }

    @Override
    public void addJarDirectory(String url, boolean recursive, OrderRootType rootType) {
        this.addRoot(url, rootType);
        this.myJarDirectories.add(rootType, url, recursive);
    }

    @Override
    public void removeRoot(String url, OrderRootType rootType) {
        this.myRoots.remove((Object)rootType, (Object)new LightFilePointer(url));
        Iterator<LightFilePointer> iterator = this.myExcludedRoots.iterator();
        while (iterator.hasNext()) {
            LightFilePointer pointer = iterator.next();
            if (this.isUnderRoots(pointer.getUrl())) continue;
            iterator.remove();
        }
        this.myJarDirectories.remove(rootType, url);
    }

    private boolean isUnderRoots(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/ui/configuration/libraryEditor/NewLibraryEditor", "isUnderRoots"));
        }
        for (LightFilePointer pointer : this.myRoots.values()) {
            if (!VfsUtilCore.isEqualOrAncestor((String)pointer.getUrl(), (String)url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChanges() {
        return true;
    }

    @Override
    public boolean isJarDirectory(String url, OrderRootType rootType) {
        return this.myJarDirectories.contains(rootType, url);
    }

    @Override
    public boolean isValid(String url, OrderRootType orderRootType) {
        Collection pointers = this.myRoots.get((Object)orderRootType);
        for (LightFilePointer pointer : pointers) {
            if (!pointer.getUrl().equals(url)) continue;
            return pointer.isValid();
        }
        return false;
    }

    public void applyTo(LibraryEx.ModifiableModelEx model) {
        model.setProperties(this.myProperties);
        this.exportRoots(arg_0 -> ((LibraryEx.ModifiableModelEx)model).getUrls(arg_0), (arg_0, arg_1) -> ((LibraryEx.ModifiableModelEx)model).isValid(arg_0, arg_1), (arg_0, arg_1) -> ((LibraryEx.ModifiableModelEx)model).removeRoot(arg_0, arg_1), (arg_0, arg_1) -> ((LibraryEx.ModifiableModelEx)model).addRoot(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((LibraryEx.ModifiableModelEx)model).addJarDirectory(arg_0, arg_1, arg_2));
    }

    public void applyTo(LibraryEditorBase editor) {
        editor.setProperties(this.myProperties);
        this.exportRoots(editor::getUrls, editor::isValid, editor::removeRoot, editor::addRoot, editor::addJarDirectory);
    }

    private void exportRoots(Function<OrderRootType, String[]> getUrls, BiFunction<String, OrderRootType, Boolean> isValid, BiConsumer<String, OrderRootType> removeRoot, BiConsumer<String, OrderRootType> addRoot, TriConsumer<String, Boolean, OrderRootType> addJarDir) {
        for (OrderRootType type2 : OrderRootType.getAllTypes()) {
            for (String url : getUrls.apply(type2)) {
                if (this.myKeepInvalidUrls && !isValid.apply(url, type2).booleanValue()) continue;
                removeRoot.accept(url, type2);
            }
        }
        for (OrderRootType type3 : this.myRoots.keySet()) {
            for (LightFilePointer pointer : this.myRoots.get((Object)type3)) {
                if (this.myJarDirectories.contains(type3, pointer.getUrl())) continue;
                addRoot.accept(pointer.getUrl(), type3);
            }
        }
        for (OrderRootType type4 : this.myJarDirectories.getRootTypes()) {
            for (String url : this.myJarDirectories.getDirectories(type4)) {
                addJarDir.accept(url, this.myJarDirectories.isRecursive(type4, url), type4);
            }
        }
    }

    @FunctionalInterface
    private static interface TriConsumer<T, U, P> {
        public void accept(T var1, U var2, P var3);
    }
}

