/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetInfo;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.facet.impl.ui.FacetEditorFacade;
import com.intellij.facet.impl.ui.FacetTreeModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nullable;

public class FacetEditorFacadeImpl
implements FacetEditorFacade {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.projectRoot.FacetEditorFacadeImpl");
    private final ModuleStructureConfigurable myStructureConfigurable;
    private final Runnable myTreeUpdater;
    private final Map<Facet, MasterDetailsComponent.MyNode> myNodes = new HashMap<Facet, MasterDetailsComponent.MyNode>();
    private final Map<Facet, FacetConfigurable> myConfigurables = new HashMap<Facet, FacetConfigurable>();

    public FacetEditorFacadeImpl(ModuleStructureConfigurable structureConfigurable, Runnable treeUpdater) {
        this.myStructureConfigurable = structureConfigurable;
        this.myTreeUpdater = treeUpdater;
    }

    public boolean addFacetsNodes(Module module2, MasterDetailsComponent.MyNode moduleNode) {
        boolean facetsExist = false;
        this.getFacetConfigurator().addFacetInfos(module2);
        FacetModel facetModel = this.getFacetConfigurator().getFacetModel(module2);
        for (Facet facet : facetModel.getSortedFacets()) {
            this.addFacetNode(facet, moduleNode);
            facetsExist = true;
        }
        return facetsExist;
    }

    private void addFacetNode(Facet facet) {
        MasterDetailsComponent.MyNode moduleNode = this.myStructureConfigurable.findModuleNode(facet.getModule());
        if (moduleNode == null) {
            return;
        }
        this.addFacetNode(facet, moduleNode);
        FacetStructureConfigurable facetStructureConfigurable = FacetStructureConfigurable.getInstance(this.myStructureConfigurable.getProject());
        MasterDetailsComponent.MyNode facetTypeNode = facetStructureConfigurable.getOrCreateFacetTypeNode(facet.getType());
        LOG.assertTrue(facetTypeNode != null, (Object)("Cannot found node for " + facet.getType()));
        facetStructureConfigurable.addFacetNodes(facetTypeNode, Collections.singletonList(facet), this);
    }

    private MasterDetailsComponent.MyNode addFacetNode(Facet facet, MasterDetailsComponent.MyNode moduleNode) {
        MasterDetailsComponent.MyNode existing = FacetEditorFacadeImpl.findFacetNode(facet, moduleNode);
        if (existing != null) {
            return existing;
        }
        FacetConfigurable facetConfigurable = this.getOrCreateConfigurable(facet);
        MasterDetailsComponent.MyNode facetNode = new MasterDetailsComponent.MyNode((NamedConfigurable)facetConfigurable);
        this.myNodes.put(facet, facetNode);
        MasterDetailsComponent.MyNode parent = moduleNode;
        Facet underlyingFacet = facet.getUnderlyingFacet();
        if (underlyingFacet != null) {
            parent = this.myNodes.get(underlyingFacet);
            LOG.assertTrue(parent != null);
        }
        this.myStructureConfigurable.addNode(facetNode, parent);
        return facetNode;
    }

    public FacetConfigurable getOrCreateConfigurable(Facet facet) {
        FacetConfigurable configurable = this.myConfigurables.get(facet);
        if (configurable == null) {
            configurable = new FacetConfigurable(facet, this.myStructureConfigurable.getContext(), this.myTreeUpdater);
            this.myConfigurables.put(facet, configurable);
        }
        return configurable;
    }

    @Nullable
    private static MasterDetailsComponent.MyNode findFacetNode(Facet facet, MasterDetailsComponent.MyNode moduleNode) {
        for (int i2 = 0; i2 < moduleNode.getChildCount(); ++i2) {
            Facet existingFacet;
            MasterDetailsComponent.MyNode configNode;
            NamedConfigurable config;
            TreeNode node = moduleNode.getChildAt(i2);
            if (!(node instanceof MasterDetailsComponent.MyNode) || !((config = (configNode = (MasterDetailsComponent.MyNode)node).getConfigurable()) instanceof FacetConfigurable) || (existingFacet = ((FacetConfigurable)config).getEditableObject()) == null || !existingFacet.equals((Object)facet)) continue;
            return configNode;
        }
        return null;
    }

    @Override
    public boolean nodeHasFacetOfType(FacetInfo facet, FacetTypeId typeId) {
        Module selectedModule = this.getSelectedModule();
        if (selectedModule == null) {
            return false;
        }
        FacetTreeModel facetTreeModel = this.getFacetConfigurator().getTreeModel(selectedModule);
        return facetTreeModel.hasFacetOfType(facet, typeId);
    }

    @Override
    public Facet createFacet(FacetInfo parent, FacetType type2) {
        return this.createAndAddFacet(type2, this.getSelectedModule(), this.getFacetConfigurator().getFacet(parent));
    }

    public Facet createAndAddFacet(FacetType type2, Module module2, Facet underlying) {
        Facet facet = this.getFacetConfigurator().createAndAddFacet(module2, type2, underlying);
        this.addFacetNode(facet);
        return facet;
    }

    @Override
    public Collection<FacetInfo> getFacetsByType(FacetType<?, ?> type2) {
        Module selectedModule = this.getSelectedModule();
        if (selectedModule == null) {
            return Collections.emptyList();
        }
        FacetModel facetModel = this.getFacetConfigurator().getFacetModel(selectedModule);
        Collection facets = facetModel.getFacetsByType(type2.getId());
        ArrayList<FacetInfo> infos = new ArrayList<FacetInfo>();
        for (Facet facet : facets) {
            FacetInfo facetInfo = this.getFacetConfigurator().getFacetInfo(facet);
            if (facetInfo == null) continue;
            infos.add(facetInfo);
        }
        return infos;
    }

    @Override
    @Nullable
    public FacetInfo getParent(FacetInfo facetInfo) {
        Module module2 = this.getFacetConfigurator().getFacet(facetInfo).getModule();
        return this.getFacetConfigurator().getTreeModel(module2).getParent(facetInfo);
    }

    private ProjectFacetsConfigurator getFacetConfigurator() {
        return this.myStructureConfigurable.getFacetConfigurator();
    }

    @Nullable
    private Facet getSelectedFacet() {
        Object selectedObject = this.myStructureConfigurable.getSelectedObject();
        if (selectedObject instanceof Facet) {
            return (Facet)selectedObject;
        }
        return null;
    }

    @Nullable
    private Module getSelectedModule() {
        Object selected = this.myStructureConfigurable.getSelectedObject();
        if (selected instanceof Module) {
            return (Module)selected;
        }
        if (selected instanceof Facet) {
            return ((Facet)selected).getModule();
        }
        return null;
    }

    @Override
    @Nullable
    public ModuleType getSelectedModuleType() {
        Module module2 = this.getSelectedModule();
        return module2 != null ? ModuleType.get((Module)module2) : null;
    }

    @Override
    @Nullable
    public FacetInfo getSelectedFacetInfo() {
        Facet facet = this.getSelectedFacet();
        return facet != null ? this.getFacetConfigurator().getFacetInfo(facet) : null;
    }

    public void clearMaps(boolean clearNodes) {
        this.myConfigurables.clear();
        if (clearNodes) {
            this.myNodes.clear();
        }
    }
}

