/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.ui.SdkEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkConfigurable
extends ProjectStructureElementConfigurable<Sdk>
implements Place.Navigator {
    private final ProjectJdkImpl myProjectJdk;
    private final SdkEditor mySdkEditor;
    private final SdkProjectStructureElement myProjectStructureElement;

    public JdkConfigurable(@NotNull ProjectJdkImpl projectJdk, @NotNull ProjectSdksModel sdksModel, @NotNull Runnable updateTree, @NotNull History history, @NotNull Project project2) {
        if (projectJdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectJdk", "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkConfigurable", "<init>"));
        }
        if (sdksModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdksModel", "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkConfigurable", "<init>"));
        }
        if (updateTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateTree", "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkConfigurable", "<init>"));
        }
        if (history == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "history", "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkConfigurable", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkConfigurable", "<init>"));
        }
        super(true, updateTree);
        this.myProjectJdk = projectJdk;
        this.mySdkEditor = this.createSdkEditor(project2, sdksModel, history, this.myProjectJdk);
        StructureConfigurableContext context = ModuleStructureConfigurable.getInstance(project2).getContext();
        this.myProjectStructureElement = new SdkProjectStructureElement(context, this.myProjectJdk);
    }

    protected SdkEditor createSdkEditor(@NotNull Project project2, ProjectSdksModel sdksModel, History history, ProjectJdkImpl projectJdk) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkConfigurable", "createSdkEditor"));
        }
        return new SdkEditor(project2, sdksModel, history, projectJdk);
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.myProjectStructureElement;
    }

    public void setDisplayName(String name2) {
        this.myProjectJdk.setName(name2);
    }

    public Sdk getEditableObject() {
        return this.myProjectJdk;
    }

    public String getBannerSlogan() {
        return ProjectBundle.message((String)"project.roots.jdk.banner.text", (Object[])new Object[]{this.myProjectJdk.getName()});
    }

    public String getDisplayName() {
        return this.myProjectJdk.getName();
    }

    public Icon getIcon(boolean open2) {
        return ((SdkType)this.myProjectJdk.getSdkType()).getIcon();
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return ((SdkType)this.myProjectJdk.getSdkType()).getHelpTopic();
    }

    public JComponent createOptionsPanel() {
        return this.mySdkEditor.createComponent();
    }

    public boolean isModified() {
        return this.mySdkEditor.isModified();
    }

    public void apply() throws ConfigurationException {
        this.mySdkEditor.apply();
    }

    public void reset() {
        this.mySdkEditor.reset();
    }

    public void disposeUIResources() {
        this.mySdkEditor.disposeUIResources();
    }

    public void setHistory(History history) {
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        return this.mySdkEditor.navigateTo(place, requestFocus);
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkConfigurable", "queryPlace"));
        }
        this.mySdkEditor.queryPlace(place);
    }
}

