/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import gnu.trove.THashMap;
import java.util.EventListener;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureConfigurableContext
implements Disposable,
LibraryEditorListener {
    private final ProjectStructureDaemonAnalyzer myDaemonAnalyzer;
    public final ModulesConfigurator myModulesConfigurator;
    public final Map<String, LibrariesModifiableModel> myLevel2Providers = new THashMap();
    private final EventDispatcher<LibraryEditorListener> myLibraryEditorListeners = EventDispatcher.create(LibraryEditorListener.class);
    private final Project myProject;

    public StructureConfigurableContext(Project project2, ModulesConfigurator modulesConfigurator) {
        this.myProject = project2;
        this.myModulesConfigurator = modulesConfigurator;
        Disposer.register((Disposable)project2, (Disposable)this);
        this.myDaemonAnalyzer = new ProjectStructureDaemonAnalyzer(this);
    }

    public VirtualFile[] getLibraryFiles(Library library, OrderRootType type2) {
        LibrariesModifiableModel librariesModel;
        LibraryTable.ModifiableModel modifiableModel;
        LibraryTable table = library.getTable();
        if (table != null && (modifiableModel = this.getModifiableLibraryTable(table)) instanceof LibrariesModifiableModel && (librariesModel = (LibrariesModifiableModel)modifiableModel).hasLibraryEditor(library)) {
            return librariesModel.getLibraryEditor(library).getFiles(type2);
        }
        return library.getFiles(type2);
    }

    public Project getProject() {
        return this.myProject;
    }

    public ProjectStructureDaemonAnalyzer getDaemonAnalyzer() {
        return this.myDaemonAnalyzer;
    }

    public void dispose() {
    }

    public ModulesConfigurator getModulesConfigurator() {
        return this.myModulesConfigurator;
    }

    public Module[] getModules() {
        return this.myModulesConfigurator.getModules();
    }

    public String getRealName(Module module2) {
        ModifiableModuleModel moduleModel = this.myModulesConfigurator.getModuleModel();
        String newName = moduleModel.getNewName(module2);
        return newName != null ? newName : module2.getName();
    }

    public void resetLibraries() {
        LibraryTablesRegistrar tablesRegistrar = LibraryTablesRegistrar.getInstance();
        this.myLevel2Providers.clear();
        this.myLevel2Providers.put("application", new LibrariesModifiableModel(tablesRegistrar.getLibraryTable(), this.myProject, this));
        this.myLevel2Providers.put("project", new LibrariesModifiableModel(tablesRegistrar.getLibraryTable(this.myProject), this.myProject, this));
        for (LibraryTable table : tablesRegistrar.getCustomLibraryTables()) {
            this.myLevel2Providers.put(table.getTableLevel(), new LibrariesModifiableModel(table, this.myProject, this));
        }
    }

    public void addLibraryEditorListener(LibraryEditorListener listener2) {
        this.myLibraryEditorListeners.addListener((EventListener)listener2);
    }

    public void addLibraryEditorListener(@NotNull LibraryEditorListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext", "addLibraryEditorListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext", "addLibraryEditorListener"));
        }
        this.myLibraryEditorListeners.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    public void libraryRenamed(@NotNull Library library, String oldName, String newName) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext", "libraryRenamed"));
        }
        ((LibraryEditorListener)this.myLibraryEditorListeners.getMulticaster()).libraryRenamed(library, oldName, newName);
    }

    public StructureLibraryTableModifiableModelProvider getGlobalLibrariesProvider() {
        return this.createModifiableModelProvider("application");
    }

    public StructureLibraryTableModifiableModelProvider createModifiableModelProvider(String level) {
        return new StructureLibraryTableModifiableModelProvider(level, this);
    }

    public StructureLibraryTableModifiableModelProvider getProjectLibrariesProvider() {
        return this.createModifiableModelProvider("project");
    }

    public LibraryTable.ModifiableModel getModifiableLibraryTable(@NotNull LibraryTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext", "getModifiableLibraryTable"));
        }
        String tableLevel = table.getTableLevel();
        if (tableLevel.equals("module")) {
            return table.getModifiableModel();
        }
        return this.myLevel2Providers.get(tableLevel);
    }

    @Nullable
    public Library getLibrary(String libraryName, String libraryLevel) {
        LibrariesModifiableModel model = this.myLevel2Providers.get(libraryLevel);
        return model == null ? null : StructureConfigurableContext.findLibraryModel(libraryName, model);
    }

    @Nullable
    private static Library findLibraryModel(@NotNull String libraryName, @NotNull LibrariesModifiableModel model) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext", "findLibraryModel"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext", "findLibraryModel"));
        }
        for (Library library : model.getLibraries()) {
            Library libraryModel = StructureConfigurableContext.findLibraryModel(library, model);
            if (libraryModel == null || !libraryName.equals(libraryModel.getName())) continue;
            return libraryModel;
        }
        return null;
    }

    @Nullable
    public Library getLibraryModel(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext", "getLibraryModel"));
        }
        LibraryTable libraryTable = library.getTable();
        if (libraryTable != null) {
            return StructureConfigurableContext.findLibraryModel(library, this.myLevel2Providers.get(libraryTable.getTableLevel()));
        }
        return library;
    }

    @Nullable
    private static Library findLibraryModel(Library library, LibrariesModifiableModel tableModel) {
        if (tableModel == null) {
            return library;
        }
        if (tableModel.wasLibraryRemoved(library)) {
            return null;
        }
        return tableModel.hasLibraryEditor(library) ? (Library)tableModel.getLibraryEditor(library).getModel() : library;
    }

    public void reset() {
        this.resetLibraries();
        this.myModulesConfigurator.resetModuleEditors();
        this.myDaemonAnalyzer.reset();
    }

    public void clear() {
        this.myLevel2Providers.clear();
    }
}

