/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.navigation.Place;
import org.jetbrains.annotations.NotNull;

public class PlaceInProjectStructureBase
extends PlaceInProjectStructure {
    private final Project myProject;
    private final Place myPlace;
    private final ProjectStructureElement myElement;
    private boolean myCanNavigate;

    public PlaceInProjectStructureBase(Project project2, Place place, ProjectStructureElement element) {
        this(project2, place, element, true);
    }

    public PlaceInProjectStructureBase(Project project2, Place place, ProjectStructureElement element, boolean navigate) {
        this.myProject = project2;
        this.myPlace = place;
        this.myElement = element;
        this.myCanNavigate = navigate;
    }

    @Override
    public String getPlacePath() {
        return null;
    }

    @Override
    public boolean canNavigate() {
        return this.myCanNavigate;
    }

    @Override
    @NotNull
    public ProjectStructureElement getContainingElement() {
        ProjectStructureElement projectStructureElement = this.myElement;
        if (projectStructureElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/PlaceInProjectStructureBase", "getContainingElement"));
        }
        return projectStructureElement;
    }

    @Override
    @NotNull
    public ActionCallback navigate() {
        ActionCallback actionCallback = ProjectStructureConfigurable.getInstance(this.myProject).navigateTo(this.myPlace, true);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/PlaceInProjectStructureBase", "navigate"));
        }
        return actionCallback;
    }
}

