/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectConfigurationProblems;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzerListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolderImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureValidator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureDaemonAnalyzer
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.projectRoot.validation.ProjectStructureDaemonAnalyzer");
    private final Map<ProjectStructureElement, ProjectStructureProblemsHolderImpl> myProblemHolders = new HashMap<ProjectStructureElement, ProjectStructureProblemsHolderImpl>();
    private final MultiValuesMap<ProjectStructureElement, ProjectStructureElementUsage> mySourceElement2Usages = new MultiValuesMap();
    private final MultiValuesMap<ProjectStructureElement, ProjectStructureElementUsage> myContainingElement2Usages = new MultiValuesMap();
    private final Set<ProjectStructureElement> myElementWithNotCalculatedUsages = new HashSet<ProjectStructureElement>();
    private final Set<ProjectStructureElement> myElementsToShowWarningIfUnused = new HashSet<ProjectStructureElement>();
    private final Map<ProjectStructureElement, ProjectStructureProblemDescription> myWarningsAboutUnused = new HashMap<ProjectStructureElement, ProjectStructureProblemDescription>();
    private final MergingUpdateQueue myAnalyzerQueue;
    private final MergingUpdateQueue myResultsUpdateQueue;
    private final EventDispatcher<ProjectStructureDaemonAnalyzerListener> myDispatcher = EventDispatcher.create(ProjectStructureDaemonAnalyzerListener.class);
    private final AtomicBoolean myStopped = new AtomicBoolean(false);
    private final ProjectConfigurationProblems myProjectConfigurationProblems;

    public ProjectStructureDaemonAnalyzer(StructureConfigurableContext context) {
        Disposer.register((Disposable)context, (Disposable)this);
        this.myProjectConfigurationProblems = new ProjectConfigurationProblems(this, context);
        this.myAnalyzerQueue = new MergingUpdateQueue("Project Structure Daemon Analyzer", 300, false, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myResultsUpdateQueue = new MergingUpdateQueue("Project Structure Analysis Results Updater", 300, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this, null, Alarm.ThreadToUse.SWING_THREAD);
    }

    private void doUpdate(ProjectStructureElement element, boolean check, boolean collectUsages) {
        if (this.myStopped.get()) {
            return;
        }
        if (check) {
            this.doCheck(element);
        }
        if (collectUsages) {
            this.doCollectUsages(element);
        }
    }

    private void doCheck(final ProjectStructureElement element) {
        final ProjectStructureProblemsHolderImpl problemsHolder = new ProjectStructureProblemsHolderImpl();
        new ReadAction(){

            protected void run(@NotNull Result result2) {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$1", "run"));
                }
                if (ProjectStructureDaemonAnalyzer.this.myStopped.get()) {
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("checking " + element);
                }
                ProjectStructureValidator.check(element, problemsHolder);
            }
        }.execute();
        this.myResultsUpdateQueue.queue((Update)new ProblemsComputedUpdate(element, problemsHolder));
    }

    private void doCollectUsages(final ProjectStructureElement element) {
        List usages = (List)new ReadAction<List<ProjectStructureElementUsage>>(){

            protected void run(@NotNull Result<List<ProjectStructureElementUsage>> result2) {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$2", "run"));
                }
                if (ProjectStructureDaemonAnalyzer.this.myStopped.get()) {
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("collecting usages in " + element);
                }
                result2.setResult((Object)ProjectStructureDaemonAnalyzer.getUsagesInElement(element));
            }
        }.execute().getResultObject();
        if (usages != null) {
            this.myResultsUpdateQueue.queue((Update)new UsagesCollectedUpdate(element, usages));
        }
    }

    private static List<ProjectStructureElementUsage> getUsagesInElement(ProjectStructureElement element) {
        return ProjectStructureValidator.getUsagesInElement(element);
    }

    private void updateUsages(ProjectStructureElement element, List<ProjectStructureElementUsage> usages) {
        this.removeUsagesInElement(element);
        for (ProjectStructureElementUsage usage : usages) {
            this.addUsage(usage);
        }
        this.myElementWithNotCalculatedUsages.remove(element);
        this.myResultsUpdateQueue.queue((Update)new ReportUnusedElementsUpdate());
    }

    public void queueUpdate(@NotNull ProjectStructureElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer", "queueUpdate"));
        }
        this.queueUpdate(element, true, true);
    }

    private void queueUpdate(@NotNull ProjectStructureElement element, boolean check, boolean collectUsages) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer", "queueUpdate"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("start " + (check ? "checking " : "") + (collectUsages ? "collecting usages " : "") + "for " + element);
        }
        if (collectUsages) {
            this.myElementWithNotCalculatedUsages.add(element);
        }
        if (element.shouldShowWarningIfUnused()) {
            this.myElementsToShowWarningIfUnused.add(element);
        }
        this.myAnalyzerQueue.queue((Update)new AnalyzeElementUpdate(element, check, collectUsages));
    }

    public void removeElement(ProjectStructureElement element) {
        this.removeElements(Collections.singletonList(element));
    }

    public void removeElements(@NotNull List<? extends ProjectStructureElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer", "removeElements"));
        }
        this.myElementWithNotCalculatedUsages.removeAll(elements);
        this.myElementsToShowWarningIfUnused.removeAll(elements);
        for (ProjectStructureElement projectStructureElement : elements) {
            this.myWarningsAboutUnused.remove(projectStructureElement);
            this.myProblemHolders.remove(projectStructureElement);
            Collection usages = this.mySourceElement2Usages.removeAll((Object)projectStructureElement);
            if (usages != null) {
                for (ProjectStructureElementUsage usage : usages) {
                    this.myProblemHolders.remove(usage.getContainingElement());
                }
            }
            this.removeUsagesInElement(projectStructureElement);
            ((ProjectStructureDaemonAnalyzerListener)this.myDispatcher.getMulticaster()).problemsChanged(projectStructureElement);
        }
        this.myResultsUpdateQueue.queue((Update)new ReportUnusedElementsUpdate());
    }

    private void reportUnusedElements() {
        if (!this.myElementWithNotCalculatedUsages.isEmpty()) {
            return;
        }
        for (ProjectStructureElement element : this.myElementsToShowWarningIfUnused) {
            Collection usages = this.mySourceElement2Usages.get((Object)element);
            ProjectStructureProblemDescription warning = usages == null || usages.isEmpty() ? element.createUnusedElementWarning() : null;
            ProjectStructureProblemDescription old = this.myWarningsAboutUnused.put(element, warning);
            ProjectStructureProblemsHolderImpl holder = this.myProblemHolders.get(element);
            if (holder == null) {
                holder = new ProjectStructureProblemsHolderImpl();
                this.myProblemHolders.put(element, holder);
            }
            if (old != null) {
                holder.removeProblem(old);
            }
            if (warning != null) {
                holder.registerProblem(warning);
            }
            if (old == null && warning == null) continue;
            ((ProjectStructureDaemonAnalyzerListener)this.myDispatcher.getMulticaster()).problemsChanged(element);
        }
    }

    private void removeUsagesInElement(ProjectStructureElement element) {
        Collection usages = this.myContainingElement2Usages.removeAll((Object)element);
        if (usages != null) {
            for (ProjectStructureElementUsage usage : usages) {
                this.mySourceElement2Usages.remove((Object)usage.getSourceElement(), (Object)usage);
            }
        }
    }

    private void addUsage(@NotNull ProjectStructureElementUsage usage) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer", "addUsage"));
        }
        this.mySourceElement2Usages.put((Object)usage.getSourceElement(), (Object)usage);
        this.myContainingElement2Usages.put((Object)usage.getContainingElement(), (Object)usage);
    }

    public void stop() {
        LOG.debug("analyzer stopped");
        this.myStopped.set(true);
        this.myAnalyzerQueue.cancelAllUpdates();
        this.myResultsUpdateQueue.cancelAllUpdates();
        this.clearCaches();
        this.myAnalyzerQueue.deactivate();
        this.myResultsUpdateQueue.deactivate();
    }

    public void clearCaches() {
        LOG.debug("clear caches");
        this.myProblemHolders.clear();
    }

    public void queueUpdateForAllElementsWithErrors() {
        ArrayList<ProjectStructureElement> toUpdate = new ArrayList<ProjectStructureElement>();
        for (Map.Entry<ProjectStructureElement, ProjectStructureProblemsHolderImpl> entry : this.myProblemHolders.entrySet()) {
            if (!entry.getValue().containsProblems()) continue;
            toUpdate.add(entry.getKey());
        }
        this.myProblemHolders.clear();
        LOG.debug("Adding to queue updates for " + toUpdate.size() + " problematic elements");
        for (ProjectStructureElement element : toUpdate) {
            this.queueUpdate(element);
        }
    }

    public void dispose() {
        this.myStopped.set(true);
        this.myAnalyzerQueue.cancelAllUpdates();
        this.myResultsUpdateQueue.cancelAllUpdates();
    }

    @Nullable
    public ProjectStructureProblemsHolderImpl getProblemsHolder(ProjectStructureElement element) {
        return this.myProblemHolders.get(element);
    }

    public Collection<ProjectStructureElementUsage> getUsages(ProjectStructureElement selected) {
        ProjectStructureElement[] elements;
        for (ProjectStructureElement element : elements = this.myElementWithNotCalculatedUsages.toArray(new ProjectStructureElement[this.myElementWithNotCalculatedUsages.size()])) {
            this.updateUsages(element, ProjectStructureDaemonAnalyzer.getUsagesInElement(element));
        }
        List<ProjectStructureElementUsage> usages = this.mySourceElement2Usages.get((Object)selected);
        return usages != null ? usages : Collections.emptyList();
    }

    public void addListener(ProjectStructureDaemonAnalyzerListener listener2) {
        LOG.debug("listener added " + listener2);
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void reset() {
        LOG.debug("analyzer started");
        this.myAnalyzerQueue.activate();
        this.myResultsUpdateQueue.activate();
        this.myAnalyzerQueue.queue(new Update("reset"){

            public void run() {
                ProjectStructureDaemonAnalyzer.this.myStopped.set(false);
            }
        });
    }

    public void clear() {
        this.myWarningsAboutUnused.clear();
        this.myElementsToShowWarningIfUnused.clear();
        this.mySourceElement2Usages.clear();
        this.myContainingElement2Usages.clear();
        this.myElementWithNotCalculatedUsages.clear();
        this.myProjectConfigurationProblems.clearProblems();
    }

    private class ReportUnusedElementsUpdate
    extends Update {
        private ReportUnusedElementsUpdate() {
            super((Object)"unused elements");
        }

        public void run() {
            ProjectStructureDaemonAnalyzer.this.reportUnusedElements();
        }
    }

    private class ProblemsComputedUpdate
    extends Update {
        private final ProjectStructureElement myElement;
        private final ProjectStructureProblemsHolderImpl myProblemsHolder;
        private final Object[] myEqualityObjects;

        public ProblemsComputedUpdate(ProjectStructureElement element, ProjectStructureProblemsHolderImpl problemsHolder) {
            super((Object)element);
            this.myElement = element;
            this.myProblemsHolder = problemsHolder;
            this.myEqualityObjects = new Object[]{element, "problems computed"};
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.myEqualityObjects == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$ProblemsComputedUpdate", "getEqualityObjects"));
            }
            return this.myEqualityObjects;
        }

        public void run() {
            ProjectStructureProblemDescription warning;
            if (ProjectStructureDaemonAnalyzer.this.myStopped.get()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("updating problems for " + this.myElement);
            }
            if ((warning = (ProjectStructureProblemDescription)ProjectStructureDaemonAnalyzer.this.myWarningsAboutUnused.get(this.myElement)) != null) {
                this.myProblemsHolder.registerProblem(warning);
            }
            ProjectStructureDaemonAnalyzer.this.myProblemHolders.put(this.myElement, this.myProblemsHolder);
            ((ProjectStructureDaemonAnalyzerListener)ProjectStructureDaemonAnalyzer.this.myDispatcher.getMulticaster()).problemsChanged(this.myElement);
        }
    }

    private class UsagesCollectedUpdate
    extends Update {
        private final ProjectStructureElement myElement;
        private final List<ProjectStructureElementUsage> myUsages;
        private final Object[] myEqualityObjects;

        public UsagesCollectedUpdate(ProjectStructureElement element, List<ProjectStructureElementUsage> usages) {
            super((Object)element);
            this.myElement = element;
            this.myUsages = usages;
            this.myEqualityObjects = new Object[]{element, "usages collected"};
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.myEqualityObjects == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$UsagesCollectedUpdate", "getEqualityObjects"));
            }
            return this.myEqualityObjects;
        }

        public void run() {
            if (ProjectStructureDaemonAnalyzer.this.myStopped.get()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("updating usages for " + this.myElement);
            }
            ProjectStructureDaemonAnalyzer.this.updateUsages(this.myElement, this.myUsages);
        }
    }

    private class AnalyzeElementUpdate
    extends Update {
        private final ProjectStructureElement myElement;
        private final boolean myCheck;
        private final boolean myCollectUsages;
        private final Object[] myEqualityObjects;

        public AnalyzeElementUpdate(ProjectStructureElement element, boolean check, boolean collectUsages) {
            super((Object)element);
            this.myElement = element;
            this.myCheck = check;
            this.myCollectUsages = collectUsages;
            this.myEqualityObjects = new Object[]{this.myElement, this.myCheck, this.myCollectUsages};
        }

        public boolean canEat(Update update2) {
            if (!(update2 instanceof AnalyzeElementUpdate)) {
                return false;
            }
            AnalyzeElementUpdate other = (AnalyzeElementUpdate)update2;
            return !(!this.myElement.equals(other.myElement) || other.myCheck && !this.myCheck || other.myCollectUsages && !this.myCollectUsages);
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.myEqualityObjects == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$AnalyzeElementUpdate", "getEqualityObjects"));
            }
            return this.myEqualityObjects;
        }

        public void run() {
            try {
                ProjectStructureDaemonAnalyzer.this.doUpdate(this.myElement, this.myCheck, this.myCollectUsages);
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
    }
}

