/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UserUpdateSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.xmlb.annotations.CollectionBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="UpdatesConfigurable", storages={@Storage(value="updates.xml", roamingType=RoamingType.DISABLED), @Storage(value="other.xml", deprecated=true)})
public class UpdateSettings
implements PersistentStateComponent<State>,
UserUpdateSettings {
    private final String myPackageManager = System.getProperty("ide.no.platform.update");
    private State myState = new State();

    public static UpdateSettings getInstance() {
        return (UpdateSettings)ServiceManager.getService(UpdateSettings.class);
    }

    public boolean isPlatformUpdateEnabled() {
        return this.myPackageManager == null;
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "getState"));
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "loadState"));
        }
        this.myState = state;
        this.myState.LAST_BUILD_CHECKED = StringUtil.nullize((String)this.myState.LAST_BUILD_CHECKED);
    }

    @Nullable
    public String getLastBuildChecked() {
        return this.myState.LAST_BUILD_CHECKED;
    }

    @NotNull
    public List<String> getStoredPluginHosts() {
        List<String> list2 = this.myState.pluginHosts;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "getStoredPluginHosts"));
        }
        return list2;
    }

    public boolean isCheckNeeded() {
        return this.myState.CHECK_NEEDED;
    }

    public void setCheckNeeded(boolean value2) {
        this.myState.CHECK_NEEDED = value2;
    }

    public List<String> getEnabledExternalUpdateSources() {
        return this.myState.enabledExternalComponentSources;
    }

    public List<String> getKnownExternalUpdateSources() {
        return this.myState.knownExternalComponentSources;
    }

    public Map<String, String> getExternalUpdateChannels() {
        return this.myState.externalUpdateChannels;
    }

    public boolean isSecureConnection() {
        return this.myState.SECURE_CONNECTION;
    }

    public void setSecureConnection(boolean value2) {
        this.myState.SECURE_CONNECTION = value2;
    }

    public long getLastTimeChecked() {
        return this.myState.LAST_TIME_CHECKED;
    }

    @Override
    @NotNull
    public List<String> getIgnoredBuildNumbers() {
        List<String> list2 = this.myState.ignoredBuildNumbers;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "getIgnoredBuildNumbers"));
        }
        return list2;
    }

    @Override
    @NotNull
    public ChannelStatus getSelectedChannelStatus() {
        ChannelStatus channelStatus = ChannelStatus.fromCode(this.myState.UPDATE_CHANNEL_TYPE);
        if (channelStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "getSelectedChannelStatus"));
        }
        return channelStatus;
    }

    public void setSelectedChannelStatus(@NotNull ChannelStatus channel) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "setSelectedChannelStatus"));
        }
        this.myState.UPDATE_CHANNEL_TYPE = channel.getCode();
    }

    @NotNull
    public List<ChannelStatus> getActiveChannels() {
        UpdateStrategyCustomization tweaker = UpdateStrategyCustomization.getInstance();
        List<ChannelStatus> list2 = Stream.of(ChannelStatus.values()).filter(ch -> ch == ChannelStatus.EAP || ch == ChannelStatus.RELEASE || tweaker.isChannelActive((ChannelStatus)((Object)ch))).collect(Collectors.toList());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "getActiveChannels"));
        }
        return list2;
    }

    @NotNull
    public ChannelStatus getSelectedActiveChannel() {
        ChannelStatus current;
        UpdateStrategyCustomization tweaker = UpdateStrategyCustomization.getInstance();
        ChannelStatus channelStatus = tweaker.isChannelActive(current = this.getSelectedChannelStatus()) ? current : this.getActiveChannels().stream().filter(ch -> ch.compareTo(current) > 0).findFirst().orElse(ChannelStatus.RELEASE);
        if (channelStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "getSelectedActiveChannel"));
        }
        return channelStatus;
    }

    public List<String> getPluginHosts() {
        ArrayList<String> hosts = new ArrayList<String>(this.myState.pluginHosts);
        String pluginHosts = System.getProperty("idea.plugin.hosts");
        if (pluginHosts != null) {
            ContainerUtil.addAll(hosts, (Object[])pluginHosts.split(";"));
        }
        return hosts;
    }

    public void forceCheckForUpdateAfterRestart() {
        this.myState.LAST_TIME_CHECKED = 0L;
    }

    public void saveLastCheckedInfo() {
        this.myState.LAST_TIME_CHECKED = System.currentTimeMillis();
        this.myState.LAST_BUILD_CHECKED = ApplicationInfo.getInstance().getBuild().asString();
    }

    public boolean canUseSecureConnection() {
        return this.myState.SECURE_CONNECTION && NetUtils.isSniEnabled();
    }

    public String getUpdateChannelType() {
        return this.myState.UPDATE_CHANNEL_TYPE;
    }

    public void setUpdateChannelType(@NotNull String value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "setUpdateChannelType"));
        }
        this.myState.UPDATE_CHANNEL_TYPE = value2;
    }

    public static class State {
        @CollectionBean
        public final List<String> pluginHosts = new SmartList();
        @CollectionBean
        public final List<String> ignoredBuildNumbers = new SmartList();
        @CollectionBean
        public final List<String> enabledExternalComponentSources = new SmartList();
        @CollectionBean
        public final List<String> knownExternalComponentSources = new SmartList();
        @CollectionBean
        public final Map<String, String> externalUpdateChannels = new HashMap<String, String>();
        public boolean CHECK_NEEDED = true;
        public long LAST_TIME_CHECKED = 0L;
        public String LAST_BUILD_CHECKED;
        public String UPDATE_CHANNEL_TYPE = ChannelStatus.RELEASE.getCode();
        public boolean SECURE_CONNECTION = true;
    }
}

