/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.actions.VcsAnnotateUtil;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.vfs.ContentRevisionVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateVcsVirtualFileAction {
    private static final Logger LOG = Logger.getInstance(AnnotateVcsVirtualFileAction.class);

    private static boolean isEnabled(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null || project2.isDisposed()) {
            return false;
        }
        VirtualFile[] selectedFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (selectedFiles == null || selectedFiles.length != 1) {
            return false;
        }
        VirtualFile file2 = selectedFiles[0];
        if (file2.isDirectory() || file2.getFileType().isBinary()) {
            return false;
        }
        if (VcsAnnotateUtil.getEditors(project2, file2).isEmpty()) {
            return false;
        }
        AnnotationData data = AnnotateVcsVirtualFileAction.extractData(project2, file2);
        if (data == null) {
            return false;
        }
        AnnotationProvider provider = data.vcs.getAnnotationProvider();
        return provider instanceof AnnotationProviderEx;
    }

    private static boolean isSuspended(AnActionEvent e) {
        VirtualFile file2 = ((VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY))[0];
        return VcsAnnotateUtil.getBackgroundableLock((Project)e.getRequiredData(CommonDataKeys.PROJECT), file2).isLocked();
    }

    private static boolean isAnnotated(AnActionEvent e) {
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile file2 = ((VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY))[0];
        List<Editor> editors = VcsAnnotateUtil.getEditors(project2, file2);
        return ContainerUtil.exists(editors, editor -> editor.getGutter().isAnnotationsShown());
    }

    private static void perform(AnActionEvent e, boolean selected) {
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile file2 = ((VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY))[0];
        List<Editor> editors = VcsAnnotateUtil.getEditors(project2, file2);
        if (!selected) {
            for (Editor editor : editors) {
                editor.getGutter().closeAllAnnotations();
            }
        } else {
            Editor editor = editors.get(0);
            AnnotateVcsVirtualFileAction.doAnnotate(project2, editor, file2);
        }
    }

    private static void doAnnotate(final @NotNull Project project2, final @NotNull Editor editor, final @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction", "doAnnotate"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction", "doAnnotate"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction", "doAnnotate"));
        }
        final AnnotationData data = AnnotateVcsVirtualFileAction.extractData(project2, file2);
        assert (data != null);
        final AnnotationProviderEx provider = (AnnotationProviderEx)data.vcs.getAnnotationProvider();
        assert (provider != null);
        final Ref fileAnnotationRef = new Ref();
        final Ref exceptionRef = new Ref();
        VcsAnnotateUtil.getBackgroundableLock(project2, file2).lock();
        Task.Backgroundable annotateTask = new Task.Backgroundable(project2, VcsBundle.message((String)"retrieving.annotations", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction$1", "run"));
                }
                try {
                    fileAnnotationRef.set((Object)provider.annotate(data.filePath, data.revisionNumber));
                }
                catch (VcsException e) {
                    exceptionRef.set((Object)e);
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Throwable t) {
                    exceptionRef.set((Object)new VcsException(t));
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                VcsAnnotateUtil.getBackgroundableLock(project2, file2).unlock();
                if (!exceptionRef.isNull()) {
                    LOG.warn((Throwable)exceptionRef.get());
                    AbstractVcsHelper.getInstance((Project)project2).showErrors(Collections.singletonList(exceptionRef.get()), VcsBundle.message((String)"message.title.annotate", (Object[])new Object[0]));
                }
                if (!fileAnnotationRef.isNull()) {
                    AnnotateToggleAction.doAnnotate(editor, project2, null, (FileAnnotation)fileAnnotationRef.get(), data.vcs);
                }
            }
        };
        ProgressManager.getInstance().run((Task)annotateTask);
    }

    @Nullable
    private static AnnotationData extractData(@NotNull Project project2, @NotNull VirtualFile file2) {
        ContentRevision revision;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction", "extractData"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction", "extractData"));
        }
        FilePath filePath = null;
        VcsRevisionNumber revisionNumber = null;
        if (file2 instanceof VcsVirtualFile) {
            filePath = VcsUtil.getFilePath((String)file2.getPath());
            revision = ((VcsVirtualFile)file2).getFileRevision();
            revisionNumber = revision != null ? revision.getRevisionNumber() : null;
        } else if (file2 instanceof ContentRevisionVirtualFile) {
            revision = ((ContentRevisionVirtualFile)file2).getContentRevision();
            filePath = revision.getFile();
            revisionNumber = revision.getRevisionNumber();
        }
        if (filePath == null || revisionNumber == null) {
            return null;
        }
        AbstractVcs vcs = VcsUtil.getVcsFor((Project)project2, (FilePath)filePath);
        return vcs != null ? new AnnotationData(vcs, filePath, revisionNumber) : null;
    }

    public static class Provider
    implements AnnotateToggleAction.Provider {
        @Override
        public boolean isEnabled(AnActionEvent e) {
            return AnnotateVcsVirtualFileAction.isEnabled(e);
        }

        @Override
        public boolean isSuspended(AnActionEvent e) {
            return AnnotateVcsVirtualFileAction.isSuspended(e);
        }

        @Override
        public boolean isAnnotated(AnActionEvent e) {
            return AnnotateVcsVirtualFileAction.isAnnotated(e);
        }

        @Override
        public void perform(AnActionEvent e, boolean selected) {
            AnnotateVcsVirtualFileAction.perform(e, selected);
        }
    }

    private static class AnnotationData {
        @NotNull
        public final AbstractVcs vcs;
        @NotNull
        public final FilePath filePath;
        @NotNull
        public final VcsRevisionNumber revisionNumber;

        public AnnotationData(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @NotNull VcsRevisionNumber revisionNumber) {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction$AnnotationData", "<init>"));
            }
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction$AnnotationData", "<init>"));
            }
            if (revisionNumber == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionNumber", "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction$AnnotationData", "<init>"));
            }
            this.vcs = vcs;
            this.filePath = filePath;
            this.revisionNumber = revisionNumber;
        }
    }
}

