/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vcs.changes.FictiveBackgroundable;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.Waiter;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CallbackData {
    private static final Logger LOG = Logger.getInstance(CallbackData.class);
    @NotNull
    private final Runnable myCallback;
    @NotNull
    private final Runnable myWrapperStarter;

    CallbackData(@NotNull Runnable callback, @NotNull Runnable wrapperStarter) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/vcs/changes/CallbackData", "<init>"));
        }
        if (wrapperStarter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapperStarter", "com/intellij/openapi/vcs/changes/CallbackData", "<init>"));
        }
        this.myCallback = callback;
        this.myWrapperStarter = wrapperStarter;
    }

    @NotNull
    public Runnable getCallback() {
        Runnable runnable2 = this.myCallback;
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/CallbackData", "getCallback"));
        }
        return runnable2;
    }

    @NotNull
    public Runnable getWrapperStarter() {
        Runnable runnable2 = this.myWrapperStarter;
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/CallbackData", "getWrapperStarter"));
        }
        return runnable2;
    }

    @NotNull
    public static CallbackData create(@NotNull Project project2, @NotNull InvokeAfterUpdateMode mode, @NotNull Runnable afterUpdate, @Nullable String title, @Nullable ModalityState state) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/CallbackData", "create"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/changes/CallbackData", "create"));
        }
        if (afterUpdate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterUpdate", "com/intellij/openapi/vcs/changes/CallbackData", "create"));
        }
        CallbackData callbackData = mode.isSilent() ? CallbackData.createSilent(project2, mode, afterUpdate) : CallbackData.createInteractive(project2, mode, afterUpdate, title, state);
        if (callbackData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/CallbackData", "create"));
        }
        return callbackData;
    }

    @NotNull
    private static CallbackData createSilent(@NotNull Project project2, @NotNull InvokeAfterUpdateMode mode, @NotNull Runnable afterUpdate) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/CallbackData", "createSilent"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/changes/CallbackData", "createSilent"));
        }
        if (afterUpdate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterUpdate", "com/intellij/openapi/vcs/changes/CallbackData", "createSilent"));
        }
        Consumer<Runnable> callbackCaller = mode.isCallbackOnAwt() ? arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0) : arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0);
        Runnable callback = () -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/CallbackData", "lambda$createSilent$0"));
            }
            if (mode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/changes/CallbackData", "lambda$createSilent$0"));
            }
            if (afterUpdate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterUpdate", "com/intellij/openapi/vcs/changes/CallbackData", "lambda$createSilent$0"));
            }
            CallbackData.logUpdateFinished(project2, mode);
            if (!project2.isDisposed()) {
                afterUpdate.run();
            }
        };
        CallbackData callbackData = new CallbackData(() -> callbackCaller.accept(callback), EmptyRunnable.INSTANCE);
        if (callbackData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/CallbackData", "createSilent"));
        }
        return callbackData;
    }

    @NotNull
    private static CallbackData createInteractive(@NotNull Project project2, @NotNull InvokeAfterUpdateMode mode, @NotNull Runnable afterUpdate, String title, @Nullable ModalityState state) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/CallbackData", "createInteractive"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/changes/CallbackData", "createInteractive"));
        }
        if (afterUpdate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterUpdate", "com/intellij/openapi/vcs/changes/CallbackData", "createInteractive"));
        }
        Object task = mode.isSynchronous() ? new Waiter(project2, afterUpdate, title, mode.isCancellable()) : new FictiveBackgroundable(project2, afterUpdate, title, mode.isCancellable(), state);
        Runnable callback = () -> CallbackData.lambda$createInteractive$2(project2, mode, (Task)task);
        CallbackData callbackData = new CallbackData(callback, () -> CallbackData.lambda$createInteractive$3((Task)task));
        if (callbackData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/CallbackData", "createInteractive"));
        }
        return callbackData;
    }

    private static void setDone(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/vcs/changes/CallbackData", "setDone"));
        }
        if (task instanceof Waiter) {
            ((Waiter)task).done();
        } else if (task instanceof FictiveBackgroundable) {
            ((FictiveBackgroundable)task).done();
        } else {
            throw new IllegalArgumentException("Unknown task type " + task.getClass());
        }
    }

    private static void logUpdateFinished(@NotNull Project project2, @NotNull InvokeAfterUpdateMode mode) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/CallbackData", "logUpdateFinished"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/changes/CallbackData", "logUpdateFinished"));
        }
        LOG.debug(mode + " changes update finished for project " + project2.getName());
    }

    private static /* synthetic */ void lambda$createInteractive$3(Task task) {
        ProgressManager.getInstance().run(task);
    }

    private static /* synthetic */ void lambda$createInteractive$2(@NotNull Project project2, @NotNull InvokeAfterUpdateMode mode, Task task) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/CallbackData", "lambda$createInteractive$2"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/changes/CallbackData", "lambda$createInteractive$2"));
        }
        CallbackData.logUpdateFinished(project2, mode);
        CallbackData.setDone(task);
    }
}

