/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerSerialization;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.DummyChangesView;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.FileHolderComposite;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.IgnoredFilesComponent;
import com.intellij.openapi.vcs.changes.IgnoredFilesCompositeHolder;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListsLoadedListener;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.Modifier;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.UpdateRequestsQueue;
import com.intellij.openapi.vcs.changes.UpdatingChangeListBuilder;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.changes.VcsConfirmationDialog;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeModifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeVfsListener;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.changes.VirtualFileHolder;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.changes.ui.CommitHelper;
import com.intellij.openapi.vcs.changes.ui.PlusMinusModify;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ChangeListManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ChangeListManagerImpl
extends ChangeListManagerEx
implements ProjectComponent,
ChangeListOwner,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeListManagerImpl");
    private static final String EXCLUDED_CONVERTED_TO_IGNORED_OPTION = "EXCLUDED_CONVERTED_TO_IGNORED";
    public static final Topic<LocalChangeListsLoadedListener> LISTS_LOADED = new Topic("LOCAL_CHANGE_LISTS_LOADED", LocalChangeListsLoadedListener.class);
    private final Project myProject;
    private final VcsConfiguration myConfig;
    private final ChangesViewI myChangesViewManager;
    private final FileStatusManager myFileStatusManager;
    private final ChangelistConflictTracker myConflictTracker;
    private VcsDirtyScopeManager myDirtyScopeManager;
    private final Scheduler myScheduler;
    private final EventDispatcher<ChangeListListener> myListeners;
    private final DelayedNotificator myDelayedNotificator;
    private final Object myDataLock;
    private final IgnoredFilesComponent myIgnoredIdeaLevel;
    private final UpdateRequestsQueue myUpdater;
    private final Modifier myModifier;
    private FileHolderComposite myComposite;
    private ChangeListWorker myWorker;
    private VcsException myUpdateException;
    private Factory<JComponent> myAdditionalInfo;
    private boolean myShowLocalChangesInvalidated;
    @NotNull
    private ProgressIndicator myUpdateChangesProgressIndicator;
    private volatile String myFreezeName;
    @NotNull
    private final Collection<LocalChangeList> myListsToBeDeleted;
    private boolean myModalNotificationsBlocked;
    private final List<CommitExecutor> myRegisteredCommitExecutors;
    private boolean myExcludedConvertedToIgnored;

    public static ChangeListManagerImpl getInstanceImpl(Project project2) {
        return (ChangeListManagerImpl)ChangeListManagerImpl.getInstance((Project)project2);
    }

    void setDirtyScopeManager(VcsDirtyScopeManager dirtyScopeManager) {
        this.myDirtyScopeManager = dirtyScopeManager;
    }

    public ChangeListManagerImpl(@NotNull Project project2, VcsConfiguration config) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "<init>"));
        }
        this.myScheduler = new Scheduler();
        this.myListeners = EventDispatcher.create(ChangeListListener.class);
        this.myDataLock = new Object();
        this.myUpdateChangesProgressIndicator = ChangeListManagerImpl.createProgressIndicator();
        this.myListsToBeDeleted = new HashSet<LocalChangeList>();
        this.myRegisteredCommitExecutors = new ArrayList<CommitExecutor>();
        this.myProject = project2;
        this.myConfig = config;
        this.myChangesViewManager = this.myProject.isDefault() ? new DummyChangesView(this.myProject) : ChangesViewManager.getInstance(this.myProject);
        this.myFileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        this.myConflictTracker = new ChangelistConflictTracker(project2, this, this.myFileStatusManager, EditorNotifications.getInstance((Project)project2));
        this.myIgnoredIdeaLevel = new IgnoredFilesComponent(this.myProject, true);
        this.myComposite = new FileHolderComposite(project2);
        this.myWorker = new ChangeListWorker(this.myProject, new MyChangesDeltaForwarder(this.myProject, this.myScheduler));
        this.myDelayedNotificator = new DelayedNotificator(this.myListeners, this.myScheduler);
        this.myUpdater = new UpdateRequestsQueue(this.myProject, this.myScheduler, () -> this.updateImmediately());
        this.myModifier = new Modifier(this.myWorker, this.myDelayedNotificator);
        this.myListeners.addListener((EventListener)new ChangeListAdapter(){

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
                LocalChangeList oldList = (LocalChangeList)oldDefaultList;
                if (oldDefaultList == null || oldList.hasDefaultName() || oldDefaultList.equals(newDefaultList)) {
                    return;
                }
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    ChangeListManagerImpl.this.scheduleAutomaticEmptyChangeListDeletion(oldList);
                }
            }
        });
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ProjectManager.getInstance().addProjectManagerListener(project2, new ProjectManagerListener(){

                public void projectClosing(Project project2) {
                    ChangeListManagerImpl.this.waitEverythingDoneInTestMode();
                }
            });
        }
    }

    public void scheduleAutomaticEmptyChangeListDeletion(@NotNull LocalChangeList oldList) {
        if (oldList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldList", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "scheduleAutomaticEmptyChangeListDeletion"));
        }
        if (oldList.isReadOnly() || !oldList.getChanges().isEmpty()) {
            return;
        }
        this.invokeAfterUpdate(() -> {
            if (oldList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldList", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$scheduleAutomaticEmptyChangeListDeletion$1"));
            }
            LocalChangeList actualList = this.getChangeList(oldList.getId());
            if (actualList == null || actualList.isDefault() || !actualList.getChanges().isEmpty()) {
                return;
            }
            if (this.myModalNotificationsBlocked && this.myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION) {
                this.myListsToBeDeleted.add(oldList);
            } else {
                this.deleteEmptyChangeLists(Collections.singletonList(actualList));
            }
        }, InvokeAfterUpdateMode.SILENT, null, null);
    }

    private void deleteEmptyChangeLists(@NotNull Collection<LocalChangeList> lists) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "deleteEmptyChangeLists"));
        }
        if (lists.isEmpty() || this.myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            return;
        }
        ChangeListRemoveConfirmation.processLists(this.myProject, false, lists, new ChangeListRemoveConfirmation(){

            @Override
            public boolean askIfShouldRemoveChangeLists(@NotNull List<? extends LocalChangeList> toAsk) {
                if (toAsk == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toAsk", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$3", "askIfShouldRemoveChangeLists"));
                }
                return ((ChangeListManagerImpl)ChangeListManagerImpl.this).myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY || ChangeListManagerImpl.showRemoveEmptyChangeListsProposal(ChangeListManagerImpl.this.myProject, ChangeListManagerImpl.this.myConfig, toAsk);
            }
        });
    }

    public static boolean showRemoveEmptyChangeListsProposal(@NotNull Project project2, final @NotNull VcsConfiguration config, @NotNull Collection<? extends ChangeList> lists) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "showRemoveEmptyChangeListsProposal"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "showRemoveEmptyChangeListsProposal"));
        }
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "showRemoveEmptyChangeListsProposal"));
        }
        if (lists.isEmpty()) {
            return false;
        }
        String question = lists.size() == 1 ? String.format("<html>The empty changelist '%s' is no longer active.<br>Do you want to remove it?</html>", StringUtil.first((String)lists.iterator().next().getName(), (int)30, (boolean)true)) : String.format("<html>Empty changelists<br/>%s are no longer active.<br>Do you want to remove them?</html>", StringUtil.join(lists, list2 -> StringUtil.first((String)list2.getName(), (int)30, (boolean)true), (String)"<br/>"));
        VcsConfirmationDialog dialog2 = new VcsConfirmationDialog(project2, "Remove Empty Changelist", "Remove", "Cancel", new VcsShowConfirmationOption(){

            public VcsShowConfirmationOption.Value getValue() {
                return config.REMOVE_EMPTY_INACTIVE_CHANGELISTS;
            }

            public void setValue(VcsShowConfirmationOption.Value value2) {
                config.REMOVE_EMPTY_INACTIVE_CHANGELISTS = value2;
            }

            public boolean isPersistent() {
                return true;
            }
        }, question, "&Remember my choice");
        return dialog2.showAndGet();
    }

    @Override
    public void blockModalNotifications() {
        this.myModalNotificationsBlocked = true;
    }

    @Override
    public void unblockModalNotifications() {
        this.myModalNotificationsBlocked = false;
        this.deleteEmptyChangeLists(this.myListsToBeDeleted);
        this.myListsToBeDeleted.clear();
    }

    public void projectOpened() {
        this.initializeForNewProject();
        VcsListener vcsListener = new VcsListener(){

            public void directoryMappingChanged() {
                VcsDirtyScopeManager.getInstance((Project)ChangeListManagerImpl.this.myProject).markEverythingDirty();
            }
        };
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myUpdater.initialized();
            this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)vcsListener);
        } else {
            ((ProjectLevelVcsManagerImpl)vcsManager).addInitializationRequest(VcsInitObject.CHANGE_LIST_MANAGER, (Runnable)((DumbAwareRunnable)() -> {
                this.myUpdater.initialized();
                this.broadcastStateAfterLoad();
                this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)vcsListener);
            }));
            this.myConflictTracker.startTracking();
        }
    }

    private void broadcastStateAfterLoad() {
        List<LocalChangeList> listCopy = this.getChangeListsCopy();
        if (!this.myProject.isDisposed()) {
            ((LocalChangeListsLoadedListener)this.myProject.getMessageBus().syncPublisher(LISTS_LOADED)).processLoadedLists(listCopy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeForNewProject() {
        Object object = this.myDataLock;
        synchronized (object) {
            if (!Registry.is((String)"ide.hide.excluded.files") && !this.myExcludedConvertedToIgnored) {
                this.convertExcludedToIgnored();
                this.myExcludedConvertedToIgnored = true;
            }
        }
    }

    void convertExcludedToIgnored() {
        for (DirectoryIndexExcludePolicy policy : (DirectoryIndexExcludePolicy[])DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            for (VirtualFile file2 : policy.getExcludeRootsForProject()) {
                this.addDirectoryToIgnoreImplicitly(file2.getPath());
            }
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (String url : ModuleRootManager.getInstance((Module)module2).getExcludeRootUrls()) {
                VirtualFile file3 = virtualFileManager.findFileByUrl(url);
                if (file3 != null && !fileIndex.isExcluded(file3)) continue;
                this.addDirectoryToIgnoreImplicitly(VfsUtilCore.urlToPath((String)url));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosed() {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myUpdateChangesProgressIndicator.cancel();
        }
        this.myUpdater.stop();
        this.myConflictTracker.stopTracking();
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("ChangeListManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getComponentName"));
        }
        return "ChangeListManager";
    }

    public void invokeAfterUpdate(@NotNull Runnable afterUpdate, @NotNull InvokeAfterUpdateMode mode, @Nullable String title, @Nullable ModalityState state) {
        if (afterUpdate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterUpdate", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "invokeAfterUpdate"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "invokeAfterUpdate"));
        }
        this.myUpdater.invokeAfterUpdate(afterUpdate, mode, title, null, state);
    }

    public void invokeAfterUpdate(@NotNull Runnable afterUpdate, @NotNull InvokeAfterUpdateMode mode, @Nullable String title, @Nullable Consumer<VcsDirtyScopeManager> dirtyScopeManagerFiller, @Nullable ModalityState state) {
        if (afterUpdate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterUpdate", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "invokeAfterUpdate"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "invokeAfterUpdate"));
        }
        this.myUpdater.invokeAfterUpdate(afterUpdate, mode, title, dirtyScopeManagerFiller, state);
    }

    @Override
    public void freeze(@NotNull String reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "freeze"));
        }
        this.myUpdater.setIgnoreBackgroundOperation(true);
        Semaphore sem = new Semaphore();
        sem.down();
        this.invokeAfterUpdate(() -> {
            if (reason == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$freeze$4"));
            }
            this.myUpdater.setIgnoreBackgroundOperation(false);
            this.myUpdater.pause();
            this.myFreezeName = reason;
            sem.up();
        }, InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, "", ModalityState.defaultModalityState());
        boolean free = false;
        while (!free) {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            if (pi != null) {
                pi.checkCanceled();
            }
            free = sem.waitFor(500L);
        }
    }

    @Override
    public void unfreeze() {
        this.myUpdater.go();
        this.myFreezeName = null;
    }

    public String isFreezed() {
        return this.myFreezeName;
    }

    public void executeOnUpdaterThread(@NotNull Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "executeOnUpdaterThread"));
        }
        this.myScheduler.submit(r);
    }

    public void scheduleUpdate() {
        this.myUpdater.schedule();
    }

    public void scheduleUpdate(boolean updateUnversionedFiles) {
        this.myUpdater.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterOutIgnoredFiles(List<VcsDirtyScope> scopes) {
        HashSet<VirtualFile> refreshFiles = new HashSet<VirtualFile>();
        try {
            Iterator iterator = this.myDataLock;
            synchronized (iterator) {
                IgnoredFilesCompositeHolder fileHolder = this.myComposite.getIgnoredFileHolder();
                Iterator<VcsDirtyScope> iterator2 = scopes.iterator();
                while (iterator2.hasNext()) {
                    VcsModifiableDirtyScope scope = (VcsModifiableDirtyScope)iterator2.next();
                    VcsDirtyScopeModifier modifier = scope.getModifier();
                    if (modifier == null) continue;
                    fileHolder.notifyVcsStarted(scope.getVcs());
                    this.filterOutIgnoredFiles(modifier.getDirtyFilesIterator(), fileHolder, refreshFiles);
                    for (VirtualFile root : modifier.getAffectedVcsRoots()) {
                        this.filterOutIgnoredFiles(modifier.getDirtyDirectoriesIterator(root), fileHolder, refreshFiles);
                    }
                    modifier.recheckDirtyKeys();
                    if (!scope.isEmpty()) continue;
                    iterator2.remove();
                }
            }
        }
        catch (AssertionError | Exception ex) {
            LOG.error((Throwable)ex);
        }
        for (VirtualFile file2 : refreshFiles) {
            this.myFileStatusManager.fileStatusChanged(file2);
        }
    }

    private void filterOutIgnoredFiles(Iterator<FilePath> iterator, IgnoredFilesCompositeHolder fileHolder, Set<VirtualFile> refreshFiles) {
        while (iterator.hasNext()) {
            VirtualFile file2 = iterator.next().getVirtualFile();
            if (file2 == null || !this.isIgnoredFile(file2)) continue;
            iterator.remove();
            fileHolder.addFile(file2);
            refreshFiles.add(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImmediately() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (!vcsManager.hasActiveVcss()) {
            return;
        }
        VcsInvalidated invalidated = this.myDirtyScopeManager.retrieveScopes();
        if (this.checkScopeIsEmpty(invalidated)) {
            this.myDirtyScopeManager.changesProcessed();
            return;
        }
        boolean wasEverythingDirty = invalidated.isEverythingDirty();
        List scopes = invalidated.getScopes();
        try {
            boolean takeChanges;
            DataHolder dataHolder;
            if (this.myUpdater.isStopped()) {
                return;
            }
            ProgressIndicator indicator = ChangeListManagerImpl.createProgressIndicator();
            Object object = this.myDataLock;
            synchronized (object) {
                dataHolder = new DataHolder(this.myComposite.copy(), this.myWorker.copy(), wasEverythingDirty);
                this.myModifier.enterUpdate();
                if (wasEverythingDirty) {
                    this.myUpdateException = null;
                    this.myAdditionalInfo = null;
                }
                this.myUpdateChangesProgressIndicator = indicator;
                if (LOG.isDebugEnabled()) {
                    String scopeInString = StringUtil.join((Collection)scopes, scope -> scope.toString(), (String)"->\n");
                    LOG.debug("refresh procedure started, everything: " + wasEverythingDirty + " dirty scope: " + scopeInString + "\ncurrent changes: " + this.myWorker);
                }
            }
            dataHolder.notifyStart();
            this.myChangesViewManager.scheduleRefresh();
            ProgressManager.getInstance().runProcess(() -> this.iterateScopes(dataHolder, scopes, wasEverythingDirty, indicator), indicator);
            Iterator iterator = this.myDataLock;
            synchronized (iterator) {
                takeChanges = this.myUpdateException == null;
            }
            if (takeChanges) {
                this.updateIgnoredFiles(dataHolder.getComposite());
            }
            this.clearCurrentRevisionsCache(invalidated);
            ApplicationManager.getApplication().runReadAction(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                Object object = this.myDataLock;
                synchronized (object) {
                    dataHolder.notifyEnd();
                    if (takeChanges) {
                        ChangeListWorker oldWorker = this.myWorker;
                        this.myWorker = dataHolder.getChangeListWorker();
                        this.myWorker.onAfterWorkerSwitch(oldWorker);
                        this.myModifier.finishUpdate(this.myWorker);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("refresh procedure finished, unversioned size: " + dataHolder.getComposite().getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles().size() + "\nchanges: " + this.myWorker);
                        }
                        boolean statusChanged = !this.myComposite.equals(dataHolder.getComposite());
                        this.myComposite = dataHolder.getComposite();
                        if (statusChanged) {
                            this.myDelayedNotificator.unchangedFileStatusChanged();
                        }
                    } else {
                        this.myModifier.finishUpdate(null);
                    }
                    this.myShowLocalChangesInvalidated = false;
                }
            });
            for (VcsDirtyScope scope2 : scopes) {
                AbstractVcs vcs = scope2.getVcs();
                if (vcs == null || !vcs.isTrackingUnchangedContent()) continue;
                scope2.iterateExistingInsideScope(file2 -> {
                    LastUnchangedContentTracker.markUntouched(file2);
                    return true;
                });
            }
            this.myChangesViewManager.scheduleRefresh();
        }
        catch (ProcessCanceledException dataHolder2) {
            this.myDirtyScopeManager.changesProcessed();
            Object dataHolder2 = this.myDataLock;
            synchronized (dataHolder2) {
                this.myDelayedNotificator.changeListUpdateDone();
                this.myChangesViewManager.scheduleRefresh();
            }
        }
        catch (AssertionError | Exception ex) {
            LOG.error((Throwable)ex);
        }
        finally {
            this.myDirtyScopeManager.changesProcessed();
            Object object = this.myDataLock;
            synchronized (object) {
                this.myDelayedNotificator.changeListUpdateDone();
                this.myChangesViewManager.scheduleRefresh();
            }
        }
    }

    private boolean checkScopeIsEmpty(VcsInvalidated invalidated) {
        if (invalidated == null) {
            return true;
        }
        if (invalidated.isEverythingDirty()) {
            return false;
        }
        if (invalidated.isEmpty()) {
            return true;
        }
        this.filterOutIgnoredFiles(invalidated.getScopes());
        return invalidated.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateScopes(DataHolder dataHolder, List<VcsDirtyScope> scopes, boolean wasEverythingDirty, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "iterateScopes"));
        }
        ChangeListManagerGate gate = dataHolder.getChangeListWorker().createGate();
        Getter disposedGetter = () -> this.myProject.isDisposed() || this.myUpdater.isStopped();
        UpdatingChangeListBuilder builder = new UpdatingChangeListBuilder(dataHolder.getChangeListWorker(), dataHolder.getComposite(), (Getter<Boolean>)disposedGetter, this, gate);
        for (VcsDirtyScope scope : scopes) {
            indicator.checkCanceled();
            AbstractVcs vcs = scope.getVcs();
            if (vcs == null) continue;
            scope.setWasEverythingDirty(wasEverythingDirty);
            this.myChangesViewManager.setBusy(true);
            this.actualUpdate(builder, scope, vcs, dataHolder, gate, indicator);
            Object object = this.myDataLock;
            synchronized (object) {
                if (this.myUpdateException != null) {
                    break;
                }
            }
        }
        Object object = this.myDataLock;
        synchronized (object) {
            if (this.myAdditionalInfo == null) {
                this.myAdditionalInfo = builder.getAdditionalInfo();
            }
        }
    }

    private void clearCurrentRevisionsCache(VcsInvalidated invalidated) {
        ContentRevisionCache cache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getContentRevisionCache();
        if (invalidated.isEverythingDirty()) {
            cache.clearAllCurrent();
        } else {
            cache.clearScope(invalidated.getScopes());
        }
    }

    @NotNull
    private static ProgressIndicator createProgressIndicator() {
        EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator();
        if (emptyProgressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "createProgressIndicator"));
        }
        return emptyProgressIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualUpdate(@NotNull UpdatingChangeListBuilder builder, @NotNull VcsDirtyScope scope, @NotNull AbstractVcs vcs, @NotNull DataHolder dataHolder, @NotNull ChangeListManagerGate gate, @NotNull ProgressIndicator indicator) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "actualUpdate"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "actualUpdate"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "actualUpdate"));
        }
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "actualUpdate"));
        }
        if (gate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gate", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "actualUpdate"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "actualUpdate"));
        }
        dataHolder.notifyStartProcessingChanges((VcsModifiableDirtyScope)scope);
        try {
            ChangeProvider changeProvider = vcs.getChangeProvider();
            if (changeProvider != null) {
                builder.setCurrent(scope);
                changeProvider.getChanges(scope, (ChangelistBuilder)builder, indicator, gate);
            }
        }
        catch (VcsException e) {
            this.handleUpdateException(e);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.debug(t);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        finally {
            if (!this.myUpdater.isStopped()) {
                dataHolder.notifyDoneProcessingChanges();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpdateException(VcsException e) {
        LOG.info((Throwable)e);
        if (e instanceof VcsConnectionProblem) {
            ApplicationManager.getApplication().invokeLater(() -> ((VcsConnectionProblem)e).attemptQuickFix(false));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
            if (helper instanceof AbstractVcsHelperImpl && ((AbstractVcsHelperImpl)helper).handleCustom(e)) {
                return;
            }
            e.printStackTrace();
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myUpdateException = e;
        }
    }

    public static boolean isUnder(Change change, VcsDirtyScope scope) {
        ContentRevision before = change.getBeforeRevision();
        ContentRevision after2 = change.getAfterRevision();
        return before != null && scope.belongsTo(before.getFile()) || after2 != null && scope.belongsTo(after2.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<LocalChangeList> getChangeListsCopy() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List list2 = ContainerUtil.map(this.myWorker.getChangeLists(), LocalChangeList::copy);
        // MONITOREXIT : object
        if (list2 != null) return list2;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangeListsCopy"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<LocalChangeList> getChangeLists() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<LocalChangeList> list2 = this.getChangeListsCopy();
        // MONITOREXIT : object
        if (list2 != null) return list2;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangeLists"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<File> getAffectedPaths() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<File> list2 = this.myWorker.getAffectedPaths();
        // MONITOREXIT : object
        if (list2 != null) return list2;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getAffectedPaths"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<VirtualFile> getAffectedFiles() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<VirtualFile> list2 = this.myWorker.getAffectedFiles();
        // MONITOREXIT : object
        if (list2 != null) return list2;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getAffectedFiles"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<Change> getAllChanges() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        Collection<Change> collection = this.myWorker.getAllChanges();
        // MONITOREXIT : object
        if (collection != null) return collection;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getAllChanges"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<VirtualFile> getUnversionedFiles() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<VirtualFile> list2 = this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles();
        // MONITOREXIT : object
        if (list2 != null) return list2;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedFiles"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<VirtualFile> getModifiedWithoutEditing() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<VirtualFile> list2 = this.myComposite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING).getFiles();
        // MONITOREXIT : object
        if (list2 != null) return list2;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getModifiedWithoutEditing"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<VirtualFile> getIgnoredFiles() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(this.myComposite.getIgnoredFileHolder().values());
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getIgnoredFiles"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isIgnoredInUpdateMode() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getIgnoredFileHolder().isInUpdatingMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VirtualFile> getLockedFolders() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getVFHolder(FileHolder.HolderType.LOCKED).getFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<VirtualFile, LogicalLock> getLogicallyLockedFolders() {
        Object object = this.myDataLock;
        synchronized (object) {
            return new HashMap<VirtualFile, LogicalLock>(this.myComposite.getLogicallyLockedFileHolder().getMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLogicallyLocked(VirtualFile file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getLogicallyLockedFileHolder().containsKey(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContainedInLocallyDeleted(FilePath filePath) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getDeletedFileHolder().isContainedInLocallyDeleted(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocallyDeletedChange> getDeletedFiles() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getDeletedFileHolder().getFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultiMap<String, VirtualFile> getSwitchedFilesMap() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getSwitchedFileHolder().getBranchToFileMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Map<VirtualFile, String> getSwitchedRoots() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getRootSwitchFileHolder().getFilesMapCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcsException getUpdateException() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myUpdateException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Factory<JComponent> getAdditionalUpdateInfo() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myAdditionalInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileAffected(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "isFileAffected"));
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getStatus(file2) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList findChangeList(String name2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListCopyByName(name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeList getChangeList(String id) {
        Object object = this.myDataLock;
        synchronized (object) {
            LocalChangeList list2 = this.myWorker.getChangeListById(id);
            return list2 != null ? list2.copy() : null;
        }
    }

    public LocalChangeList addChangeList(@NotNull String name2, @Nullable String comment) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addChangeList"));
        }
        return this.addChangeList(name2, comment, null);
    }

    @Override
    @NotNull
    public LocalChangeList addChangeList(@NotNull String name2, @Nullable String comment, @Nullable Object data) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addChangeList"));
        }
        LocalChangeList localChangeList = (LocalChangeList)ReadAction.compute(() -> {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$addChangeList$11"));
            }
            Object object = this.myDataLock;
            synchronized (object) {
                LocalChangeList changeList = this.myModifier.addChangeList(name2, comment, data);
                this.myChangesViewManager.scheduleRefresh();
                return changeList.copy();
            }
        });
        if (localChangeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addChangeList"));
        }
        return localChangeList;
    }

    public void removeChangeList(String name2) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.removeChangeList(name2);
                this.myChangesViewManager.scheduleRefresh();
            }
        });
    }

    public void removeChangeList(LocalChangeList list2) {
        this.removeChangeList(list2.getName());
    }

    public void setDefaultChangeList(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "setDefaultChangeList"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (list2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$setDefaultChangeList$13"));
            }
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.setDefault(list2.getName());
            }
        });
        this.myChangesViewManager.scheduleRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public LocalChangeList getDefaultChangeList() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        LocalChangeList localChangeList = this.myWorker.getDefaultList().copy();
        // MONITOREXIT : object
        if (localChangeList != null) return localChangeList;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getDefaultChangeList"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Collection<LocalChangeList> getInvolvedListsFilterChanges(@NotNull Collection<Change> changes, @NotNull List<Change> validChanges) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getInvolvedListsFilterChanges"));
        }
        if (validChanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validChanges", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getInvolvedListsFilterChanges"));
        }
        Object object = this.myDataLock;
        // MONITORENTER : object
        Collection<LocalChangeList> changelists = this.myWorker.getInvolvedListsFilterChanges(changes, validChanges);
        List list2 = ContainerUtil.map(changelists, LocalChangeList::copy);
        // MONITOREXIT : object
        if (list2 != null) return list2;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getInvolvedListsFilterChanges"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList getChangeList(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangeList"));
        }
        Object object = this.myDataLock;
        synchronized (object) {
            LocalChangeList list2 = this.myWorker.getChangeListForChange(change);
            return list2 != null ? list2.copy() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChangeListNameIfOnlyOne(Change[] changes) {
        Object object = this.myDataLock;
        synchronized (object) {
            LocalChangeList list2 = this.myWorker.getChangeListIfOnlyOne(changes);
            return list2 != null ? list2.getName() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LocalChangeList getIdentityChangeList(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getIdentityChangeList"));
        }
        Object object = this.myDataLock;
        synchronized (object) {
            List<LocalChangeList> lists = this.myWorker.getChangeLists();
            for (LocalChangeList list2 : lists) {
                for (Change oldChange : list2.getChanges()) {
                    if (oldChange != change) continue;
                    return list2.copy();
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInUpdate() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myModifier.isInsideUpdate() || this.myShowLocalChangesInvalidated;
        }
    }

    @Nullable
    public Change getChange(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChange"));
        }
        return this.getChange(VcsUtil.getFilePath((VirtualFile)file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeList getChangeList(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangeList"));
        }
        Object object = this.myDataLock;
        synchronized (object) {
            LocalChangeList list2 = this.myWorker.getChangeListFor(file2);
            return list2 != null ? list2.copy() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Change getChange(FilePath file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeForPath(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnversioned(VirtualFile file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).containsFile(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public FileStatus getStatus(@NotNull VirtualFile file2) {
        boolean switched;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
        }
        Object object = this.myDataLock;
        // MONITORENTER : object
        if (this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).containsFile(file2)) {
            FileStatus fileStatus = FileStatus.UNKNOWN;
            // MONITOREXIT : object
            if (fileStatus != null) return fileStatus;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
        }
        if (this.myComposite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING).containsFile(file2)) {
            FileStatus fileStatus = FileStatus.HIJACKED;
            // MONITOREXIT : object
            if (fileStatus != null) return fileStatus;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
        }
        if (this.myComposite.getIgnoredFileHolder().containsFile(file2)) {
            FileStatus fileStatus = FileStatus.IGNORED;
            // MONITOREXIT : object
            if (fileStatus != null) return fileStatus;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
        }
        FileStatus status = (FileStatus)ObjectUtils.notNull((Object)this.myWorker.getStatus(file2), (Object)FileStatus.NOT_CHANGED);
        if (FileStatus.NOT_CHANGED.equals(status) && (switched = this.myComposite.getSwitchedFileHolder().containsFile(file2))) {
            FileStatus fileStatus = FileStatus.SWITCHED;
            // MONITOREXIT : object
            if (fileStatus != null) return fileStatus;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
        }
        FileStatus fileStatus = status;
        // MONITOREXIT : object
        if (fileStatus != null) return fileStatus;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
    }

    @NotNull
    public Collection<Change> getChangesIn(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangesIn"));
        }
        Collection<Change> collection = this.getChangesIn(VcsUtil.getFilePath((VirtualFile)dir));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangesIn"));
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ThreeState haveChangesUnder(@NotNull VirtualFile vf) {
        if (vf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vf", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "haveChangesUnder"));
        }
        if (vf.isValid() && vf.isDirectory()) {
            Object object = this.myDataLock;
            // MONITORENTER : object
            ThreeState threeState = this.myWorker.haveChangesUnder(vf);
            // MONITOREXIT : object
            if (threeState != null) return threeState;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "haveChangesUnder"));
        }
        ThreeState threeState = ThreeState.NO;
        if (threeState != null) return threeState;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "haveChangesUnder"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<Change> getChangesIn(@NotNull FilePath dirPath) {
        if (dirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirPath", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangesIn"));
        }
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<Change> list2 = this.myWorker.getChangesIn(dirPath);
        // MONITOREXIT : object
        if (list2 != null) return list2;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangesIn"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AbstractVcs getVcsFor(@NotNull Change change) {
        VcsKey key2;
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getVcsFor"));
        }
        Object object = this.myDataLock;
        synchronized (object) {
            key2 = this.myWorker.getVcsFor(change);
        }
        return key2 != null ? ProjectLevelVcsManager.getInstance((Project)this.myProject).findVcsByName(key2.getName()) : null;
    }

    @Override
    public void moveChangesTo(LocalChangeList list2, Change ... changes) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.moveChangesTo(list2.getName(), changes);
            }
        });
        this.myChangesViewManager.scheduleRefresh();
    }

    @Override
    public void addUnversionedFiles(LocalChangeList list2, @NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addUnversionedFiles"));
        }
        this.addUnversionedFiles(list2, files, ChangeListManagerImpl.getDefaultUnversionedFileCondition(), null);
    }

    @Deprecated
    @NotNull
    public List<VcsException> addUnversionedFiles(LocalChangeList list2, @NotNull List<VirtualFile> files, @NotNull Condition<FileStatus> statusChecker, @Nullable Consumer<List<Change>> changesConsumer) {
        boolean syncUpdateRequired;
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addUnversionedFiles"));
        }
        if (statusChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusChecker", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addUnversionedFiles"));
        }
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        HashSet allProcessedFiles = new HashSet();
        ChangesUtil.processVirtualFilesByVcs((Project)this.myProject, files, (vcs, items) -> {
            if (statusChecker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusChecker", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$addUnversionedFiles$15"));
            }
            final CheckinEnvironment environment = vcs.getCheckinEnvironment();
            if (environment != null) {
                final Set<VirtualFile> descendants = this.getUnversionedDescendantsRecursively(items, statusChecker);
                Set<VirtualFile> parents = this.getUnversionedParents(vcs, items, statusChecker);
                final ArrayList result2 = ContainerUtil.newArrayList();
                ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, "Adding Files to VCS...", true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$6", "run"));
                        }
                        indicator.setIndeterminate(true);
                        List exs = environment.scheduleUnversionedFilesForAddition((List)ContainerUtil.newArrayList((Iterable)descendants));
                        if (exs != null) {
                            ContainerUtil.addAll((Collection)result2, (Iterable)exs);
                        }
                    }
                });
                allProcessedFiles.addAll(descendants);
                allProcessedFiles.addAll(parents);
                exceptions.addAll(result2);
            }
        });
        if (!exceptions.isEmpty()) {
            StringBuilder message2 = new StringBuilder(VcsBundle.message((String)"error.adding.files.prompt", (Object[])new Object[0]));
            for (VcsException ex : exceptions) {
                message2.append("\n").append(ex.getMessage());
            }
            Messages.showErrorDialog((Project)this.myProject, (String)message2.toString(), (String)VcsBundle.message((String)"error.adding.files.title", (Object[])new Object[0]));
        }
        for (VirtualFile file2 : allProcessedFiles) {
            this.myFileStatusManager.fileStatusChanged(file2);
        }
        VcsDirtyScopeManager.getInstance((Project)this.myProject).filesDirty(allProcessedFiles, null);
        Ref foundChanges = Ref.create();
        boolean moveRequired = !list2.isDefault();
        boolean bl = syncUpdateRequired = changesConsumer != null;
        if (moveRequired || syncUpdateRequired) {
            InvokeAfterUpdateMode updateMode = syncUpdateRequired ? InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE : InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE;
            this.invokeAfterUpdate(() -> {
                ApplicationManager.getApplication().runReadAction(() -> {
                    Object object = this.myDataLock;
                    synchronized (object) {
                        List newChanges = ContainerUtil.filter((Collection)this.getDefaultChangeList().getChanges(), change -> {
                            FilePath path = ChangesUtil.getAfterPath((Change)change);
                            return path != null && allProcessedFiles.contains(path.getVirtualFile());
                        });
                        foundChanges.set((Object)newChanges);
                        if (moveRequired && !newChanges.isEmpty()) {
                            this.moveChangesTo(list2, newChanges.toArray(new Change[newChanges.size()]));
                        }
                    }
                });
                this.myChangesViewManager.scheduleRefresh();
            }, updateMode, VcsBundle.message((String)"change.lists.manager.add.unversioned", (Object[])new Object[0]), null);
            if (changesConsumer != null) {
                changesConsumer.consume(foundChanges.get());
            }
        } else {
            this.myChangesViewManager.scheduleRefresh();
        }
        ArrayList<VcsException> arrayList = exceptions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addUnversionedFiles"));
        }
        return arrayList;
    }

    @NotNull
    public static Condition<FileStatus> getDefaultUnversionedFileCondition() {
        Condition condition2 = status -> status == FileStatus.UNKNOWN;
        if (condition2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getDefaultUnversionedFileCondition"));
        }
        return condition2;
    }

    @NotNull
    private Set<VirtualFile> getUnversionedDescendantsRecursively(@NotNull List<VirtualFile> items, @NotNull Condition<FileStatus> condition2) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedDescendantsRecursively"));
        }
        if (condition2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedDescendantsRecursively"));
        }
        HashSet result2 = ContainerUtil.newHashSet();
        Processor addToResultProcessor = file2 -> {
            if (condition2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$getUnversionedDescendantsRecursively$20"));
            }
            if (condition2.value((Object)this.getStatus((VirtualFile)file2))) {
                result2.add(file2);
            }
            return true;
        };
        for (VirtualFile item : items) {
            VcsRootIterator.iterateVfUnderVcsRoot(this.myProject, item, (Processor<VirtualFile>)addToResultProcessor);
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedDescendantsRecursively"));
        }
        return hashSet;
    }

    @NotNull
    private Set<VirtualFile> getUnversionedParents(@NotNull AbstractVcs vcs, @NotNull Collection<VirtualFile> items, @NotNull Condition<FileStatus> condition2) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedParents"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedParents"));
        }
        if (condition2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedParents"));
        }
        if (!vcs.areDirectoriesVersionedItems()) {
            Set<VirtualFile> set2 = Collections.emptySet();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedParents"));
            }
            return set2;
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (VirtualFile item : items) {
            for (VirtualFile parent = item.getParent(); parent != null && condition2.value((Object)this.getStatus(parent)); parent = parent.getParent()) {
                result2.add(parent);
            }
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedParents"));
        }
        return hashSet;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public void addChangeListListener(@NotNull ChangeListListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addChangeListListener"));
        }
        this.myListeners.addListener((EventListener)listener2);
    }

    public void removeChangeListListener(@NotNull ChangeListListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "removeChangeListListener"));
        }
        this.myListeners.removeListener((EventListener)listener2);
    }

    public void registerCommitExecutor(@NotNull CommitExecutor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "registerCommitExecutor"));
        }
        this.myRegisteredCommitExecutors.add(executor);
    }

    public void commitChanges(@NotNull LocalChangeList changeList, @NotNull List<Change> changes) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "commitChanges"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "commitChanges"));
        }
        this.doCommit(changeList, changes, false);
    }

    private boolean doCommit(LocalChangeList changeList, List<Change> changes, boolean synchronously) {
        FileDocumentManager.getInstance().saveAllDocuments();
        return new CommitHelper(this.myProject, (ChangeList)changeList, changes, changeList.getName(), StringUtil.isEmpty((String)changeList.getComment()) ? changeList.getName() : changeList.getComment(), new ArrayList<CheckinHandler>(), false, synchronously, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null, false, null).doCommit();
    }

    public boolean commitChangesSynchronouslyWithResult(@NotNull LocalChangeList changeList, @NotNull List<Change> changes) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "commitChangesSynchronouslyWithResult"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "commitChangesSynchronouslyWithResult"));
        }
        return this.doCommit(changeList, changes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(Element element) {
        if (this.myProject.isDefault()) {
            return;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            ChangeListManagerSerialization.readExternal(element, this.myIgnoredIdeaLevel, this.myWorker);
        }
        this.myExcludedConvertedToIgnored = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)EXCLUDED_CONVERTED_TO_IGNORED_OPTION));
        this.myConflictTracker.loadState(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element getState() {
        ChangeListWorker worker;
        IgnoredFilesComponent ignoredFilesComponent;
        Element element = new Element("state");
        if (this.myProject.isDefault()) {
            return element;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            ignoredFilesComponent = this.myIgnoredIdeaLevel.copy();
            worker = this.myWorker.copy();
        }
        ChangeListManagerSerialization.writeExternal(element, ignoredFilesComponent, worker);
        JDOMExternalizerUtil.writeField((Element)element, (String)EXCLUDED_CONVERTED_TO_IGNORED_OPTION, (String)Boolean.toString(this.myExcludedConvertedToIgnored), (String)Boolean.toString(false));
        this.myConflictTracker.saveState(element);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopenFiles(@NotNull List<FilePath> paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "reopenFiles"));
        }
        ReadonlyStatusHandlerImpl readonlyStatusHandler = (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject);
        boolean savedOption = readonlyStatusHandler.getState().SHOW_DIALOG;
        readonlyStatusHandler.getState().SHOW_DIALOG = false;
        try {
            readonlyStatusHandler.ensureFilesWritable(ContainerUtil.mapNotNull(paths, FilePath::getVirtualFile));
        }
        finally {
            readonlyStatusHandler.getState().SHOW_DIALOG = savedOption;
        }
    }

    @NotNull
    public List<CommitExecutor> getRegisteredExecutors() {
        List<CommitExecutor> list2 = Collections.unmodifiableList(this.myRegisteredCommitExecutors);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getRegisteredExecutors"));
        }
        return list2;
    }

    public void addFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        if (filesToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToIgnore", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addFilesToIgnore"));
        }
        this.myIgnoredIdeaLevel.add(filesToIgnore);
        this.scheduleUnversionedUpdate();
    }

    public void addDirectoryToIgnoreImplicitly(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addDirectoryToIgnoreImplicitly"));
        }
        this.myIgnoredIdeaLevel.addIgnoredDirectoryImplicitly(path, this.myProject);
    }

    public void removeImplicitlyIgnoredDirectory(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "removeImplicitlyIgnoredDirectory"));
        }
        this.myIgnoredIdeaLevel.removeImplicitlyIgnoredDirectory(path, this.myProject);
    }

    public IgnoredFilesComponent getIgnoredFilesComponent() {
        return this.myIgnoredIdeaLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUnversionedUpdate() {
        Collection<VirtualFile> ignored;
        List<VirtualFile> unversioned;
        Object object = this.myDataLock;
        synchronized (object) {
            unversioned = this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles();
            ignored = this.myComposite.getIgnoredFileHolder().values();
        }
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        int ourPiecesLimit = 100;
        if (unversioned.size() + ignored.size() > 100) {
            vcsDirtyScopeManager.markEverythingDirty();
        } else {
            ArrayList<VirtualFile> dirs = new ArrayList<VirtualFile>();
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            for (VirtualFile vf : ContainerUtil.concat((Iterable[])new Iterable[]{unversioned, ignored})) {
                if (vf.isDirectory()) {
                    dirs.add(vf);
                    continue;
                }
                files.add(vf);
            }
            vcsDirtyScopeManager.filesDirty(files, dirs);
        }
    }

    public void setFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        if (filesToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToIgnore", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "setFilesToIgnore"));
        }
        this.myIgnoredIdeaLevel.set(filesToIgnore);
        this.scheduleUnversionedUpdate();
    }

    private void updateIgnoredFiles(FileHolderComposite composite) {
        VirtualFileHolder vfHolder = composite.getVFHolder(FileHolder.HolderType.UNVERSIONED);
        List<VirtualFile> unversionedFiles = vfHolder.getFiles();
        this.exchangeWithIgnored(composite, vfHolder, unversionedFiles);
        VirtualFileHolder vfModifiedHolder = composite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING);
        List<VirtualFile> modifiedFiles = vfModifiedHolder.getFiles();
        this.exchangeWithIgnored(composite, vfModifiedHolder, modifiedFiles);
    }

    private void exchangeWithIgnored(FileHolderComposite composite, VirtualFileHolder vfHolder, List<VirtualFile> unversionedFiles) {
        for (VirtualFile file2 : unversionedFiles) {
            if (!this.isIgnoredFile(file2)) continue;
            vfHolder.removeFile(file2);
            composite.getIgnoredFileHolder().addFile(file2);
        }
    }

    @NotNull
    public IgnoredFileBean[] getFilesToIgnore() {
        IgnoredFileBean[] ignoredFileBeanArray = this.myIgnoredIdeaLevel.getFilesToIgnore();
        if (ignoredFileBeanArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getFilesToIgnore"));
        }
        return ignoredFileBeanArray;
    }

    public boolean isIgnoredFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "isIgnoredFile"));
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file2);
        return ContainerUtil.exists((Object[])IgnoredFileProvider.IGNORE_FILE.getExtensions(), it -> it.isIgnoredFile(this.myProject, filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getSwitchedBranch(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getSwitchedBranch"));
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getSwitchedFileHolder().getBranchForFile(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public String getDefaultListName() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        String string = this.myWorker.getDefaultList().getName();
        // MONITOREXIT : object
        if (string != null) return string;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getDefaultListName"));
    }

    public boolean setReadOnly(String name2, boolean value2) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.setReadOnly(name2, value2);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        if (fromName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromName", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "editName"));
        }
        if (toName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toName", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "editName"));
        }
        return (Boolean)ReadAction.compute(() -> {
            if (fromName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromName", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$editName$23"));
            }
            if (toName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toName", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$editName$23"));
            }
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.editName(fromName, toName);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    public String editComment(@NotNull String fromName, String newComment) {
        if (fromName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromName", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "editComment"));
        }
        return (String)ReadAction.compute(() -> {
            if (fromName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromName", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$editComment$24"));
            }
            Object object = this.myDataLock;
            synchronized (object) {
                String oldComment = this.myModifier.editComment(fromName, newComment);
                this.myChangesViewManager.scheduleRefresh();
                return oldComment;
            }
        });
    }

    public void waitUntilRefreshed() {
        VcsDirtyScopeVfsListener.getInstance(this.myProject).flushDirt();
        this.myUpdater.waitUntilRefreshed();
        this.waitUpdateAlarm();
    }

    private void waitUpdateAlarm() {
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.myScheduler.submit(() -> semaphore.up());
        semaphore.waitFor();
    }

    public void stopEveryThingIfInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        Future future2 = (Future)this.myScheduler.myLastTask.get();
        if (future2 != null) {
            future2.cancel(true);
            this.myScheduler.myLastTask.compareAndSet(future2, null);
        }
    }

    public void waitEverythingDoneInTestMode() {
        Future future2;
        assert (ApplicationManager.getApplication().isUnitTestMode());
        while ((future2 = (Future)this.myScheduler.myLastTask.get()) != null) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                UIUtil.dispatchAllInvocationEvents();
            }
            try {
                future2.get(10L, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error((Throwable)e);
            }
            catch (CancellationException | TimeoutException exception) {
            }
        }
    }

    public void forceGoInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myUpdater.forceGo();
    }

    public boolean ensureUpToDate(boolean canBeCanceled) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.updateImmediately();
            return true;
        }
        VcsDirtyScopeVfsListener.getInstance(this.myProject).flushDirt();
        this.myUpdater.waitUntilRefreshed();
        this.waitUpdateAlarm();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChangeListsNumber() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListsNumber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showLocalChangesInvalidated() {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myShowLocalChangesInvalidated = true;
        }
    }

    public ChangelistConflictTracker getConflictTracker() {
        return this.myConflictTracker;
    }

    public boolean isFreezedWithNotification(@Nullable String modalTitle) {
        String freezeReason = this.isFreezed();
        if (freezeReason == null) {
            return false;
        }
        if (modalTitle != null) {
            Messages.showErrorDialog((Project)this.myProject, (String)freezeReason, (String)modalTitle);
        } else {
            VcsBalloonProblemNotifier.showOverChangesView(this.myProject, freezeReason, MessageType.WARNING, new NamedRunnable[0]);
        }
        return true;
    }

    static class Scheduler {
        private final AtomicReference<Future> myLastTask = new AtomicReference();
        private final ScheduledExecutorService myExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"ChangeListManagerImpl pool", (int)1);

        Scheduler() {
        }

        /*
         * WARNING - void declaration
         */
        public void schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit timeUnit) {
            void unit;
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$Scheduler", "schedule"));
            }
            if (timeUnit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$Scheduler", "schedule"));
            }
            this.myLastTask.set(this.myExecutor.schedule(command, delay, (TimeUnit)unit));
        }

        public void submit(@NotNull Runnable command) {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$Scheduler", "submit"));
            }
            this.myLastTask.set(this.myExecutor.submit(command));
        }
    }

    private static class MyChangesDeltaForwarder
    implements PlusMinusModify<BaseRevision> {
        private final RemoteRevisionsCache myRevisionsCache;
        private final ProjectLevelVcsManager myVcsManager;
        private final Project myProject;
        private final Scheduler myScheduler;

        public MyChangesDeltaForwarder(Project project2, @NotNull Scheduler scheduler) {
            if (scheduler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheduler", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$MyChangesDeltaForwarder", "<init>"));
            }
            this.myProject = project2;
            this.myScheduler = scheduler;
            this.myRevisionsCache = RemoteRevisionsCache.getInstance(project2);
            this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        }

        @Override
        public void modify(BaseRevision was, BaseRevision become) {
            this.myScheduler.submit(() -> {
                AbstractVcs vcs = this.getVcs(was);
                if (vcs != null) {
                    this.myRevisionsCache.plus((Pair<String, AbstractVcs>)Pair.create((Object)was.getPath(), (Object)vcs));
                }
                ((VcsAnnotationRefresher)this.myProject.getMessageBus().syncPublisher(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).dirty(become);
            });
        }

        @Override
        public void plus(BaseRevision baseRevision) {
            this.myScheduler.submit(() -> {
                AbstractVcs vcs = this.getVcs(baseRevision);
                if (vcs != null) {
                    this.myRevisionsCache.plus((Pair<String, AbstractVcs>)Pair.create((Object)baseRevision.getPath(), (Object)vcs));
                }
                ((VcsAnnotationRefresher)this.myProject.getMessageBus().syncPublisher(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).dirty(baseRevision);
            });
        }

        @Override
        public void minus(BaseRevision baseRevision) {
            this.myScheduler.submit(() -> {
                AbstractVcs vcs = this.getVcs(baseRevision);
                if (vcs != null) {
                    this.myRevisionsCache.minus((Pair<String, AbstractVcs>)Pair.create((Object)baseRevision.getPath(), (Object)vcs));
                }
                ((VcsAnnotationRefresher)this.myProject.getMessageBus().syncPublisher(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).dirty(baseRevision.getPath());
            });
        }

        @Nullable
        private AbstractVcs getVcs(@NotNull BaseRevision baseRevision) {
            if (baseRevision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseRevision", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$MyChangesDeltaForwarder", "getVcs"));
            }
            VcsKey vcsKey = baseRevision.getVcs();
            if (vcsKey != null) {
                return this.myVcsManager.findVcsByName(vcsKey.getName());
            }
            return this.myVcsManager.getVcsFor(baseRevision.getFilePath());
        }
    }

    public static class DefaultIgnoredFileProvider
    implements IgnoredFileProvider {
        public boolean isIgnoredFile(@NotNull Project project2, @NotNull FilePath filePath) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DefaultIgnoredFileProvider", "isIgnoredFile"));
            }
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DefaultIgnoredFileProvider", "isIgnoredFile"));
            }
            return ChangeListManagerImpl.getInstanceImpl(project2).myIgnoredIdeaLevel.isIgnoredFile(filePath);
        }
    }

    private class DataHolder {
        private final boolean myWasEverythingDirty;
        private final FileHolderComposite myComposite;
        private final ChangeListWorker myChangeListWorker;

        private DataHolder(FileHolderComposite composite, ChangeListWorker changeListWorker, boolean wasEverythingDirty) {
            this.myComposite = composite;
            this.myChangeListWorker = changeListWorker;
            this.myWasEverythingDirty = wasEverythingDirty;
        }

        private void notifyStart() {
            if (this.myWasEverythingDirty) {
                this.myComposite.cleanAll();
                this.myChangeListWorker.notifyStartProcessingChanges(null);
            }
        }

        private void notifyStartProcessingChanges(@NotNull VcsModifiableDirtyScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DataHolder", "notifyStartProcessingChanges"));
            }
            if (!this.myWasEverythingDirty) {
                this.myComposite.cleanAndAdjustScope(scope);
                this.myChangeListWorker.notifyStartProcessingChanges(scope);
            }
            this.myComposite.notifyVcsStarted(scope.getVcs());
        }

        private void notifyDoneProcessingChanges() {
            if (!this.myWasEverythingDirty) {
                this.myChangeListWorker.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator);
            }
        }

        void notifyEnd() {
            if (this.myWasEverythingDirty) {
                this.myChangeListWorker.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator);
            }
        }

        public FileHolderComposite getComposite() {
            return this.myComposite;
        }

        ChangeListWorker getChangeListWorker() {
            return this.myChangeListWorker;
        }
    }
}

