/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFilesComponent;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ChangeListManagerSerialization {
    @NonNls
    private static final String ATT_ID = "id";
    @NonNls
    private static final String ATT_NAME = "name";
    @NonNls
    private static final String ATT_COMMENT = "comment";
    @NonNls
    private static final String ATT_DEFAULT = "default";
    @NonNls
    private static final String ATT_READONLY = "readonly";
    @NonNls
    private static final String ATT_VALUE_TRUE = "true";
    @NonNls
    private static final String ATT_CHANGE_TYPE = "type";
    @NonNls
    private static final String ATT_CHANGE_BEFORE_PATH = "beforePath";
    @NonNls
    private static final String ATT_CHANGE_AFTER_PATH = "afterPath";
    @NonNls
    private static final String ATT_PATH = "path";
    @NonNls
    private static final String ATT_MASK = "mask";
    @NonNls
    private static final String NODE_LIST = "list";
    @NonNls
    private static final String NODE_IGNORED = "ignored";
    @NonNls
    private static final String NODE_CHANGE = "change";
    @NonNls
    private static final String MANUALLY_REMOVED_FROM_IGNORED = "manually-removed-from-ignored";
    @NonNls
    private static final String DIRECTORY_TAG = "directory";

    ChangeListManagerSerialization() {
    }

    public static void writeExternal(@NotNull Element element, @NotNull IgnoredFilesComponent ignoredFilesComponent, @NotNull ChangeListWorker worker) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "writeExternal"));
        }
        if (ignoredFilesComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredFilesComponent", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "writeExternal"));
        }
        if (worker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "worker", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "writeExternal"));
        }
        for (LocalChangeList list2 : worker.getChangeLists()) {
            element.addContent(ChangeListManagerSerialization.writeChangeList(list2));
        }
        for (IgnoredFileBean bean : ignoredFilesComponent.getFilesToIgnore()) {
            element.addContent(ChangeListManagerSerialization.writeFileToIgnore(bean));
        }
        Set<String> manuallyRemovedFromIgnored = ignoredFilesComponent.getDirectoriesManuallyRemovedFromIgnored();
        if (!manuallyRemovedFromIgnored.isEmpty()) {
            Element list3 = new Element(MANUALLY_REMOVED_FROM_IGNORED);
            for (String path : manuallyRemovedFromIgnored) {
                list3.addContent(new Element(DIRECTORY_TAG).setAttribute(ATT_PATH, path));
            }
            element.addContent(list3);
        }
    }

    public static void readExternal(@NotNull Element element, @NotNull IgnoredFilesComponent ignoredIdeaLevel, @NotNull ChangeListWorker worker) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "readExternal"));
        }
        if (ignoredIdeaLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredIdeaLevel", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "readExternal"));
        }
        if (worker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "worker", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "readExternal"));
        }
        ArrayList<LocalChangeListImpl> lists = new ArrayList<LocalChangeListImpl>();
        for (Element listNode : element.getChildren(NODE_LIST)) {
            lists.add(ChangeListManagerSerialization.readChangeList(listNode, worker.getProject()));
        }
        worker.setChangeLists(ChangeListManagerSerialization.removeDuplicatedLists(lists));
        ignoredIdeaLevel.clear();
        for (Element ignoredNode : element.getChildren(NODE_IGNORED)) {
            ChangeListManagerSerialization.readFileToIgnore(ignoredNode, worker.getProject(), ignoredIdeaLevel);
        }
        Element manuallyRemovedFromIgnoredTag = element.getChild(MANUALLY_REMOVED_FROM_IGNORED);
        HashSet<String> manuallyRemovedFromIgnoredPaths = new HashSet<String>();
        if (manuallyRemovedFromIgnoredTag != null) {
            for (Element tag : manuallyRemovedFromIgnoredTag.getChildren(DIRECTORY_TAG)) {
                manuallyRemovedFromIgnoredPaths.add(tag.getAttributeValue(ATT_PATH));
            }
        }
        ignoredIdeaLevel.setDirectoriesManuallyRemovedFromIgnored(manuallyRemovedFromIgnoredPaths);
    }

    @NotNull
    private static Collection<LocalChangeListImpl> removeDuplicatedLists(@NotNull List<LocalChangeListImpl> lists) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "removeDuplicatedLists"));
        }
        boolean hasDefault = false;
        HashMap<String, LocalChangeListImpl> map2 = new HashMap<String, LocalChangeListImpl>();
        for (LocalChangeListImpl list2 : lists) {
            LocalChangeListImpl otherList;
            if (list2.isDefault()) {
                if (hasDefault) {
                    list2.setDefault(false);
                }
                hasDefault = true;
            }
            if ((otherList = (LocalChangeListImpl)((Object)map2.get(list2.getName()))) == null) {
                map2.put(list2.getName(), list2);
                continue;
            }
            for (Change change : list2.getChanges()) {
                otherList.addChange(change);
            }
            if (!list2.isDefault()) continue;
            otherList.setDefault(true);
        }
        Collection<LocalChangeListImpl> collection = map2.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "removeDuplicatedLists"));
        }
        return collection;
    }

    @NotNull
    private static Element writeChangeList(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NODE_LIST, "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "writeChangeList"));
        }
        Element listNode = new Element(NODE_LIST);
        if (list2.isDefault()) {
            listNode.setAttribute(ATT_DEFAULT, ATT_VALUE_TRUE);
        }
        if (list2.isReadOnly()) {
            listNode.setAttribute(ATT_READONLY, ATT_VALUE_TRUE);
        }
        listNode.setAttribute(ATT_ID, list2.getId());
        listNode.setAttribute(ATT_NAME, list2.getName());
        String comment = list2.getComment();
        if (comment != null) {
            listNode.setAttribute(ATT_COMMENT, comment);
        }
        List changes = ContainerUtil.sorted((Collection)list2.getChanges(), Comparator.comparing(Change::toString));
        for (Change change : changes) {
            listNode.addContent(ChangeListManagerSerialization.writeChange(change));
        }
        Element element = listNode;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "writeChangeList"));
        }
        return element;
    }

    @NotNull
    private static LocalChangeListImpl readChangeList(@NotNull Element listNode, @NotNull Project project2) {
        if (listNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listNode", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "readChangeList"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "readChangeList"));
        }
        String id = listNode.getAttributeValue(ATT_ID);
        String name2 = listNode.getAttributeValue(ATT_NAME);
        String comment = listNode.getAttributeValue(ATT_COMMENT);
        LocalChangeListImpl list2 = LocalChangeListImpl.createEmptyChangeListImpl(project2, name2, id);
        list2.setCommentImpl(comment);
        for (Element changeNode : listNode.getChildren(NODE_CHANGE)) {
            list2.addChange(ChangeListManagerSerialization.readChange(changeNode));
        }
        if (ATT_VALUE_TRUE.equals(listNode.getAttributeValue(ATT_DEFAULT))) {
            list2.setDefault(true);
        }
        if (ATT_VALUE_TRUE.equals(listNode.getAttributeValue(ATT_READONLY))) {
            list2.setReadOnlyImpl(true);
        }
        LocalChangeListImpl localChangeListImpl = list2;
        if (localChangeListImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "readChangeList"));
        }
        return localChangeListImpl;
    }

    @NotNull
    private static Element writeFileToIgnore(@NotNull IgnoredFileBean bean) {
        String mask;
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "writeFileToIgnore"));
        }
        Element fileNode = new Element(NODE_IGNORED);
        String path = bean.getPath();
        if (path != null) {
            fileNode.setAttribute(ATT_PATH, path);
        }
        if ((mask = bean.getMask()) != null) {
            fileNode.setAttribute(ATT_MASK, mask);
        }
        Element element = fileNode;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "writeFileToIgnore"));
        }
        return element;
    }

    private static void readFileToIgnore(@NotNull Element ignoredNode, @NotNull Project project2, @NotNull IgnoredFilesComponent ignoredFilesComponent) {
        String mask;
        if (ignoredNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredNode", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "readFileToIgnore"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "readFileToIgnore"));
        }
        if (ignoredFilesComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredFilesComponent", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "readFileToIgnore"));
        }
        String path = ignoredNode.getAttributeValue(ATT_PATH);
        if (path != null) {
            ignoredFilesComponent.add(path.endsWith("/") || path.endsWith(File.separator) ? IgnoredBeanFactory.ignoreUnderDirectory((String)path, (Project)project2) : IgnoredBeanFactory.ignoreFile((String)path, (Project)project2));
        }
        if ((mask = ignoredNode.getAttributeValue(ATT_MASK)) != null) {
            ignoredFilesComponent.add(IgnoredBeanFactory.withMask((String)mask));
        }
    }

    @NotNull
    private static Element writeChange(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NODE_CHANGE, "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "writeChange"));
        }
        Element changeNode = new Element(NODE_CHANGE);
        changeNode.setAttribute(ATT_CHANGE_TYPE, change.getType().name());
        ContentRevision bRev = change.getBeforeRevision();
        ContentRevision aRev = change.getAfterRevision();
        changeNode.setAttribute(ATT_CHANGE_BEFORE_PATH, bRev != null ? bRev.getFile().getPath() : "");
        changeNode.setAttribute(ATT_CHANGE_AFTER_PATH, aRev != null ? aRev.getFile().getPath() : "");
        Element element = changeNode;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "writeChange"));
        }
        return element;
    }

    @NotNull
    private static Change readChange(@NotNull Element changeNode) {
        if (changeNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeNode", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "readChange"));
        }
        String bRev = changeNode.getAttributeValue(ATT_CHANGE_BEFORE_PATH);
        String aRev = changeNode.getAttributeValue(ATT_CHANGE_AFTER_PATH);
        Change change = new Change((ContentRevision)(StringUtil.isEmpty((String)bRev) ? null : new FakeRevision(bRev)), (ContentRevision)(StringUtil.isEmpty((String)aRev) ? null : new FakeRevision(aRev)));
        if (change == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "readChange"));
        }
        return change;
    }
}

