/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.vcs.changes.DiffPreviewUpdateProcessor;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PreviewDiffSplitterComponent
extends JBSplitter {
    @NotNull
    private final JComponent myFirstComponent;
    @NotNull
    private final DiffPreviewUpdateProcessor myProcessor;
    private boolean myDetailsOn;

    public PreviewDiffSplitterComponent(@NotNull JComponent firstComponent, @NotNull DiffPreviewUpdateProcessor processor2, @NotNull String splitterDimensionKey, boolean detailsOn) {
        if (firstComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstComponent", "com/intellij/openapi/vcs/changes/PreviewDiffSplitterComponent", "<init>"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/vcs/changes/PreviewDiffSplitterComponent", "<init>"));
        }
        if (splitterDimensionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitterDimensionKey", "com/intellij/openapi/vcs/changes/PreviewDiffSplitterComponent", "<init>"));
        }
        super(splitterDimensionKey, 0.5f);
        this.myFirstComponent = firstComponent;
        this.myProcessor = processor2;
        this.setHonorComponentsMinimumSize(false);
        this.setFirstComponent(firstComponent);
        this.setDetailsOn(detailsOn);
    }

    public void updatePreview() {
        if (this.isDetailsOn()) {
            this.myProcessor.refresh();
        } else {
            this.myProcessor.clear();
        }
    }

    private void updateVisibility() {
        this.setSecondComponent(this.myDetailsOn ? this.myProcessor.getComponent() : null);
        this.myFirstComponent.setBorder(this.myDetailsOn ? IdeBorderFactory.createBorder((int)4) : null);
        this.revalidate();
        this.repaint();
    }

    public boolean isDetailsOn() {
        return this.myDetailsOn;
    }

    public void setDetailsOn(boolean detailsOn) {
        this.myDetailsOn = detailsOn;
        this.updatePreview();
        if (this.myDetailsOn == (this.getSecondComponent() == null)) {
            this.updateVisibility();
        }
    }
}

