/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.SpecificFilesViewDialog;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnversionedViewDialog
extends SpecificFilesViewDialog {
    private AnAction myDeleteActionWithCustomShortcut;

    public UnversionedViewDialog(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "<init>"));
        }
        super(project2, "Unversioned Files", ChangesListView.UNVERSIONED_FILES_DATA_KEY, ChangeListManagerImpl.getInstanceImpl(project2).getUnversionedFiles());
    }

    @Override
    protected void addCustomActions(@NotNull DefaultActionGroup group, @NotNull ActionToolbar actionToolbar) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "addCustomActions"));
        }
        if (actionToolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionToolbar", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "addCustomActions"));
        }
        List<AnAction> actions = UnversionedViewDialog.registerUnversionedActionsShortcuts(actionToolbar.getToolbarDataContext(), (JComponent)((Object)this.myView));
        this.myDeleteActionWithCustomShortcut = EmptyAction.registerWithShortcutSet((String)"ChangesView.DeleteUnversioned.From.Dialog", (ShortcutSet)CommonShortcuts.getDelete(), (JComponent)((Object)this.myView));
        actions.add(this.myDeleteActionWithCustomShortcut);
        this.refreshViewAfterActionPerformed(actions);
        group.add((AnAction)UnversionedViewDialog.getUnversionedActionGroup());
        DefaultActionGroup secondGroup = new DefaultActionGroup();
        secondGroup.addAll(UnversionedViewDialog.getUnversionedActionGroup());
        this.myView.setMenuActions((ActionGroup)secondGroup);
    }

    private void refreshViewAfterActionPerformed(final @NotNull List<AnAction> actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "refreshViewAfterActionPerformed"));
        }
        ActionManager.getInstance().addAnActionListener((AnActionListener)new AnActionListener.Adapter(){

            public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                if (actions.contains(action)) {
                    UnversionedViewDialog.this.refreshView();
                    if (UnversionedViewDialog.this.myDeleteActionWithCustomShortcut.equals(action)) {
                        SpecificFilesViewDialog.refreshChanges(UnversionedViewDialog.this.myProject, SpecificFilesViewDialog.getBrowserBase(UnversionedViewDialog.this.myView));
                    }
                }
            }
        }, this.myDisposable);
    }

    @NotNull
    public static ActionGroup getUnversionedActionGroup() {
        ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction("Unversioned.Files.Dialog");
        if (actionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "getUnversionedActionGroup"));
        }
        return actionGroup;
    }

    @NotNull
    public static List<AnAction> registerUnversionedActionsShortcuts(@NotNull DataContext dataContext, @NotNull JComponent component) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "registerUnversionedActionsShortcuts"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "registerUnversionedActionsShortcuts"));
        }
        ActionManager manager = ActionManager.getInstance();
        ArrayList actions = ContainerUtil.newArrayList();
        Utils.expandActionGroup(LaterInvocator.isInModalContext(), UnversionedViewDialog.getUnversionedActionGroup(), actions, new PresentationFactory(), dataContext, "", manager);
        for (AnAction action : actions) {
            action.registerCustomShortcutSet(action.getShortcutSet(), component);
        }
        ArrayList arrayList = actions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "registerUnversionedActionsShortcuts"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<VirtualFile> getFiles() {
        List<VirtualFile> list2 = ((ChangeListManagerImpl)this.myChangeListManager).getUnversionedFiles();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "getFiles"));
        }
        return list2;
    }
}

