/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.CurrentRevisionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCurrentRevisionProxy
implements ByteBackedContentRevision {
    @NotNull
    private final DiffProvider myDiffProvider;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsKey myVcsKey;

    @Nullable
    public static VcsCurrentRevisionProxy create(@NotNull VirtualFile file2, @NotNull Project project2) {
        DiffProvider diffProvider;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy", "create"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy", "create"));
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project2).getVcsFor(file2);
        if (vcs != null && (diffProvider = vcs.getDiffProvider()) != null) {
            return new VcsCurrentRevisionProxy(diffProvider, file2, project2, vcs.getKeyInstanceMethod());
        }
        return null;
    }

    private VcsCurrentRevisionProxy(@NotNull DiffProvider diffProvider, @NotNull VirtualFile file2, @NotNull Project project2, @NotNull VcsKey vcsKey) {
        if (diffProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffProvider", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy", "<init>"));
        }
        if (vcsKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsKey", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy", "<init>"));
        }
        this.myDiffProvider = diffProvider;
        this.myFile = file2;
        this.myProject = project2;
        this.myVcsKey = vcsKey;
    }

    @Nullable
    public String getContent() throws VcsException {
        return ContentRevisionCache.getAsString((byte[])this.getContentAsBytes(), (FilePath)this.getFile(), (Charset)this.myFile.getCharset());
    }

    @Nullable
    public byte[] getContentAsBytes() throws VcsException {
        return (byte[])this.getVcsRevision().second;
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)this.myFile);
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy", "getFile"));
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber;
        try {
            vcsRevisionNumber = (VcsRevisionNumber)this.getVcsRevision().first;
        }
        catch (VcsException ex) {
            VcsRevisionNumber vcsRevisionNumber2 = VcsRevisionNumber.NULL;
            if (vcsRevisionNumber2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy", "getRevisionNumber"));
            }
            return vcsRevisionNumber2;
        }
        if (vcsRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy", "getRevisionNumber"));
        }
        return vcsRevisionNumber;
    }

    @NotNull
    private Pair<VcsRevisionNumber, byte[]> getVcsRevision() throws VcsException {
        Pair pair2;
        try {
            pair2 = ContentRevisionCache.getOrLoadCurrentAsBytes((Project)this.myProject, (FilePath)this.getFile(), (VcsKey)this.myVcsKey, (CurrentRevisionProvider)new CurrentRevisionProvider(){

                public VcsRevisionNumber getCurrentRevision() throws VcsException {
                    return VcsCurrentRevisionProxy.this.getCurrentRevisionNumber();
                }

                public Pair<VcsRevisionNumber, byte[]> get() throws VcsException, IOException {
                    return VcsCurrentRevisionProxy.this.loadContent();
                }
            });
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
        if (pair2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy", "getVcsRevision"));
        }
        return pair2;
    }

    @NotNull
    private VcsRevisionNumber getCurrentRevisionNumber() throws VcsException {
        VcsRevisionNumber currentRevision = this.myDiffProvider.getCurrentRevision(this.myFile);
        if (currentRevision == null) {
            throw new VcsException("Failed to fetch current revision");
        }
        VcsRevisionNumber vcsRevisionNumber = currentRevision;
        if (vcsRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy", "getCurrentRevisionNumber"));
        }
        return vcsRevisionNumber;
    }

    @NotNull
    private Pair<VcsRevisionNumber, byte[]> loadContent() throws VcsException {
        byte[] bytes;
        VcsRevisionNumber currentRevision = this.getCurrentRevisionNumber();
        ContentRevision contentRevision = this.myDiffProvider.createFileContent(currentRevision, this.myFile);
        if (contentRevision == null) {
            throw new VcsException("Failed to create content for current revision");
        }
        if (contentRevision instanceof ByteBackedContentRevision) {
            bytes = ((ByteBackedContentRevision)contentRevision).getContentAsBytes();
        } else {
            String content = contentRevision.getContent();
            if (content == null) {
                throw new VcsException("Can't get revision content");
            }
            bytes = content.getBytes(this.myFile.getCharset());
        }
        Pair pair2 = Pair.create((Object)currentRevision, (Object)bytes);
        if (pair2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy", "loadContent"));
        }
        return pair2;
    }
}

