/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class Waiter
extends Task.Modal {
    private static final Logger LOG = Logger.getInstance(Waiter.class);
    @NotNull
    private final Runnable myRunnable;
    @NotNull
    private final AtomicBoolean myStarted;
    @NotNull
    private final Semaphore mySemaphore;

    public Waiter(@NotNull Project project2, @NotNull Runnable runnable2, String title, boolean cancellable) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/Waiter", "<init>"));
        }
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/vcs/changes/Waiter", "<init>"));
        }
        super(project2, VcsBundle.message((String)"change.list.manager.wait.lists.synchronization", (Object[])new Object[]{title}), cancellable);
        this.myStarted = new AtomicBoolean();
        this.mySemaphore = new Semaphore();
        this.myRunnable = runnable2;
        this.mySemaphore.down();
        this.setCancelText("Skip");
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/Waiter", "run"));
        }
        indicator.setIndeterminate(true);
        indicator.setText2(VcsBundle.message((String)"commit.wait.util.synched.text", (Object[])new Object[0]));
        if (!this.myStarted.compareAndSet(false, true)) {
            LOG.error("Waiter running under progress being started again.");
        } else {
            while (!this.mySemaphore.waitFor(500L)) {
                indicator.checkCanceled();
            }
        }
    }

    public void onCancel() {
        this.onSuccess();
    }

    public void onSuccess() {
        if (!this.myProject.isDisposed()) {
            this.myRunnable.run();
            ChangesViewManager.getInstance(this.myProject).scheduleRefresh();
        }
    }

    public void done() {
        this.mySemaphore.up();
    }
}

