/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.IgnoreUnversionedDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.UtilKt;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class IgnoreUnversionedAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/IgnoreUnversionedAction", "actionPerformed"));
        }
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        if (!ChangeListManager.getInstance((Project)project2).isFreezedWithNotification(null)) {
            List<VirtualFile> files = ((Stream)e.getRequiredData(ChangesListView.UNVERSIONED_FILES_DATA_KEY)).collect(Collectors.toList());
            ChangesBrowserBase browser = (ChangesBrowserBase)e.getData(ChangesBrowserBase.DATA_KEY);
            Runnable callback = browser == null ? null : () -> {
                browser.rebuildList();
                browser.getViewer().excludeChanges(files);
            };
            IgnoreUnversionedDialog.ignoreSelectedFiles(project2, files, callback);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/IgnoreUnversionedAction", "update"));
        }
        e.getPresentation().setEnabled(e.getProject() != null && !UtilKt.isEmpty((Stream)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY)));
    }
}

