/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.migrate;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContentImpl;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.LineCol;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrateToNewDiffUtil {
    @NotNull
    public static DiffRequest convertRequest(@NotNull com.intellij.openapi.diff.DiffRequest oldRequest) {
        if (oldRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRequest", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil", "convertRequest"));
        }
        DiffRequest request = MigrateToNewDiffUtil.convertRequestFair(oldRequest);
        if (request != null) {
            DiffRequest diffRequest = request;
            if (diffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil", "convertRequest"));
            }
            return diffRequest;
        }
        ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest((DiffRequestProducer)new MyDiffRequestProducer(oldRequest), "Can't convert from old-style request");
        if (errorDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil", "convertRequest"));
        }
        return errorDiffRequest;
    }

    @Nullable
    private static DiffRequest convertRequestFair(@NotNull com.intellij.openapi.diff.DiffRequest oldRequest) {
        if (oldRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRequest", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil", "convertRequestFair"));
        }
        if (oldRequest.getOnOkRunnable() != null) {
            return null;
        }
        com.intellij.openapi.diff.DiffContent[] contents = oldRequest.getContents();
        String[] titles = oldRequest.getContentTitles();
        ArrayList<DiffContent> newContents = new ArrayList<DiffContent>(contents.length);
        for (int i2 = 0; i2 < contents.length; ++i2) {
            DiffContent convertedContent = MigrateToNewDiffUtil.convertContent(oldRequest.getProject(), contents[i2]);
            if (convertedContent == null) {
                return null;
            }
            newContents.add(convertedContent);
        }
        SimpleDiffRequest newRequest = new SimpleDiffRequest(oldRequest.getWindowTitle(), newContents, Arrays.asList(titles));
        DiffNavigationContext navigationContext = (DiffNavigationContext)oldRequest.getGenericData().get(DiffTool.SCROLL_TO_LINE.getName());
        if (navigationContext != null) {
            newRequest.putUserData(DiffUserDataKeysEx.NAVIGATION_CONTEXT, (Object)navigationContext);
        }
        return newRequest;
    }

    @Nullable
    private static DiffContent convertContent(@Nullable Project project2, final @NotNull com.intellij.openapi.diff.DiffContent oldContent) {
        if (oldContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldContent", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil", "convertContent"));
        }
        if (oldContent.isEmpty()) {
            return new EmptyContent();
        }
        if (oldContent.isBinary()) {
            VirtualFile file2 = oldContent.getFile();
            if (file2 == null) {
                return null;
            }
            return new FileContentImpl(project2, file2);
        }
        final Document document = oldContent.getDocument();
        if (document == null) {
            return null;
        }
        return new DocumentContentImpl(project2, document, oldContent.getContentType(), oldContent.getFile(), oldContent.getLineSeparator(), null, null){

            @Override
            @Nullable
            public Navigatable getNavigatable(@NotNull LineCol position) {
                if (position == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$1", "getNavigatable"));
                }
                return oldContent.getOpenFileDescriptor(position.toOffset(document));
            }

            public void onAssigned(boolean isAssigned) {
                oldContent.onAssigned(isAssigned);
            }
        };
    }

    private static class MyDiffRequestProducer
    implements DiffRequestProducer {
        @NotNull
        private final com.intellij.openapi.diff.DiffRequest myRequest;

        public MyDiffRequestProducer(@NotNull com.intellij.openapi.diff.DiffRequest request) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyDiffRequestProducer", "<init>"));
            }
            this.myRequest = request;
        }

        @NotNull
        public String getName() {
            String string = StringUtil.notNullize((String)this.myRequest.getWindowTitle());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyDiffRequestProducer", "getName"));
            }
            return string;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyDiffRequestProducer", "process"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyDiffRequestProducer", "process"));
            }
            ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest((DiffRequestProducer)this, "Can't convert from old-style request");
            if (errorDiffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyDiffRequestProducer", "process"));
            }
            return errorDiffRequest;
        }
    }
}

