/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListDecorator;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public class CommittedChangeListRenderer
extends ColoredTreeCellRenderer {
    private final IssueLinkRenderer myRenderer;
    private final List<CommittedChangeListDecorator> myDecorators;
    private final Project myProject;
    private int myDateWidth;
    private int myFontSize;

    public CommittedChangeListRenderer(Project project2, List<CommittedChangeListDecorator> decorators) {
        this.myProject = project2;
        this.myRenderer = new IssueLinkRenderer(project2, (SimpleColoredComponent)this);
        this.myDecorators = decorators;
        this.myDateWidth = 0;
        this.myFontSize = -1;
    }

    public static String getDateOfChangeList(@NotNull Date date) {
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date", "com/intellij/openapi/vcs/changes/committed/CommittedChangeListRenderer", "getDateOfChangeList"));
        }
        return DateFormatUtil.formatPrettyDateTime((Date)date);
    }

    public static Pair<String, Boolean> getDescriptionOfChangeList(String text2) {
        return new Pair((Object)text2.replaceAll("\n", " // "), (Object)text2.contains("\n"));
    }

    public static String truncateDescription(String initDescription, FontMetrics fontMetrics, int maxWidth) {
        String description = initDescription;
        int descWidth = fontMetrics.stringWidth(description);
        while (description.length() > 0 && descWidth > maxWidth) {
            description = CommittedChangeListRenderer.trimLastWord(description);
            descWidth = fontMetrics.stringWidth(description + " ");
        }
        return description;
    }

    public void customizeCellRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.customize(tree, value2, selected, expanded, leaf, row, hasFocus);
    }

    public void customize(JComponent tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
        if (node.getUserObject() instanceof CommittedChangeList) {
            CommittedChangeList changeList = (CommittedChangeList)node.getUserObject();
            this.renderChangeList(tree, changeList);
        } else if (node.getUserObject() != null) {
            this.append(node.getUserObject().toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    public void renderChangeList(JComponent tree, CommittedChangeList changeList) {
        CachingCommittedChangesProvider provider;
        Container parent = tree.getParent();
        int rowX = CommittedChangeListRenderer.getRowX(this.myTree, 2);
        int availableWidth = parent == null ? 100 : parent.getWidth() - rowX;
        FontMetrics fontMetrics = tree.getFontMetrics(tree.getFont());
        FontMetrics boldMetrics = tree.getFontMetrics(tree.getFont().deriveFont(1));
        FontMetrics italicMetrics = tree.getFontMetrics(tree.getFont().deriveFont(2));
        if (this.myDateWidth <= 0 || fontMetrics.getFont().getSize() != this.myFontSize) {
            this.myDateWidth = Math.max(fontMetrics.stringWidth(", Yesterday 00:00 PM "), fontMetrics.stringWidth(", 00/00/00 00:00 PM "));
            this.myDateWidth = Math.max(this.myDateWidth, fontMetrics.stringWidth(CommittedChangeListRenderer.getDateOfChangeList(new Date(2000, 11, 31))));
            this.myFontSize = fontMetrics.getFont().getSize();
        }
        int dateCommitterSize = this.myDateWidth + boldMetrics.stringWidth(changeList.getCommitterName());
        Pair<String, Boolean> descriptionInfo = CommittedChangeListRenderer.getDescriptionOfChangeList(changeList.getName().trim());
        boolean truncated = (Boolean)descriptionInfo.getSecond();
        String description = (String)descriptionInfo.getFirst();
        for (CommittedChangeListDecorator decorator : this.myDecorators) {
            Icon icon = decorator.decorate(changeList);
            if (icon == null) continue;
            this.setIcon(icon);
        }
        int descMaxWidth = availableWidth - dateCommitterSize - 8;
        boolean partial = changeList instanceof ReceivedChangeList && ((ReceivedChangeList)changeList).isPartial();
        int descWidth = 0;
        int partialMarkerWidth = 0;
        if (partial) {
            String partialMarker = VcsBundle.message((String)"committed.changes.partial.list", (Object[])new Object[0]) + " ";
            this.append(partialMarker, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            partialMarkerWidth = boldMetrics.stringWidth(partialMarker);
            descWidth += partialMarkerWidth;
        }
        descWidth += fontMetrics.stringWidth(description);
        int numberWidth = 0;
        AbstractVcs vcs = changeList.getVcs();
        if (vcs != null && (provider = vcs.getCachingCommittedChangesProvider()) != null && provider.getChangelistTitle() != null) {
            String number = "#" + changeList.getNumber() + "  ";
            numberWidth = fontMetrics.stringWidth(number);
            descWidth += numberWidth;
            this.append(number, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        int branchWidth = 0;
        String branch = changeList.getBranch();
        if (branch != null) {
            branch = branch + " ";
            branchWidth = italicMetrics.stringWidth(branch);
            descWidth += branchWidth;
            this.append(branch, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
        if (description.isEmpty() && !truncated) {
            this.append(VcsBundle.message((String)"committed.changes.empty.comment", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            this.appendTextPadding(descMaxWidth);
        } else if (descMaxWidth < 0) {
            this.myRenderer.appendTextWithLinks(description);
        } else if (descWidth < descMaxWidth && !truncated) {
            this.myRenderer.appendTextWithLinks(description);
            this.appendTextPadding(descMaxWidth);
        } else {
            String moreMarker = VcsBundle.message((String)"changes.browser.details.marker", (Object[])new Object[0]);
            int moreWidth = fontMetrics.stringWidth(moreMarker);
            int remainingWidth = descMaxWidth - moreWidth - numberWidth - branchWidth - partialMarkerWidth;
            description = CommittedChangeListRenderer.truncateDescription(description, fontMetrics, remainingWidth);
            this.myRenderer.appendTextWithLinks(description);
            if (!StringUtil.isEmpty((String)description)) {
                this.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.append(moreMarker, SimpleTextAttributes.LINK_ATTRIBUTES, new CommittedChangesTreeBrowser.MoreLauncher(this.myProject, changeList));
            } else if (remainingWidth > 0) {
                this.append(moreMarker, SimpleTextAttributes.LINK_ATTRIBUTES, new CommittedChangesTreeBrowser.MoreLauncher(this.myProject, changeList));
            }
            this.appendTextPadding(descMaxWidth);
        }
        this.append(changeList.getCommitterName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        if (changeList.getCommitDate() != null) {
            String date = ", " + CommittedChangeListRenderer.getDateOfChangeList(changeList.getCommitDate());
            this.append(date, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    private static String trimLastWord(String description) {
        int pos = description.trim().lastIndexOf(32);
        if (pos >= 0) {
            return description.substring(0, pos).trim();
        }
        return description.substring(0, description.length() - 1);
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(2000, super.getPreferredSize().height);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/CommittedChangeListRenderer", "getPreferredSize"));
        }
        return dimension;
    }

    public static int getRowX(JTree tree, int depth) {
        if (tree == null) {
            return 0;
        }
        TreeUI ui = tree.getUI();
        if (ui instanceof BasicTreeUI) {
            BasicTreeUI treeUI = (BasicTreeUI)ui;
            return (treeUI.getLeftChildIndent() + treeUI.getRightChildIndent()) * depth;
        }
        int leftIndent = UIUtil.getTreeLeftChildIndent();
        int rightIndent = UIUtil.getTreeRightChildIndent();
        return (leftIndent + rightIndent) * depth;
    }
}

