/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.ColumnFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.LabeledComboBoxAction;
import com.intellij.openapi.vcs.changes.committed.StructureFilteringStrategy;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SelectFilteringAction
extends LabeledComboBoxAction {
    @NotNull
    private final Project myProject;
    @NotNull
    private final CommittedChangesTreeBrowser myBrowser;
    @NotNull
    private ChangeListFilteringStrategy myPreviousSelection;

    public SelectFilteringAction(@NotNull Project project2, @NotNull CommittedChangesTreeBrowser browser) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/committed/SelectFilteringAction", "<init>"));
        }
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/openapi/vcs/changes/committed/SelectFilteringAction", "<init>"));
        }
        super(VcsBundle.message((String)"committed.changes.filter.title", (Object[])new Object[0]));
        this.myProject = project2;
        this.myBrowser = browser;
        this.myPreviousSelection = ChangeListFilteringStrategy.NONE;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/committed/SelectFilteringAction", "update"));
        }
        e.getPresentation().setText(this.myPreviousSelection.toString());
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(ContainerUtil.map(this.collectStrategies(), (Function)((NotNullFunction)strategy -> new SetFilteringAction((ChangeListFilteringStrategy)strategy))));
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/SelectFilteringAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    @NotNull
    protected Condition<AnAction> getPreselectCondition() {
        Condition condition2 = action -> ((SetFilteringAction)((Object)action)).myStrategy.getKey().equals((Object)this.myPreviousSelection.getKey());
        if (condition2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/SelectFilteringAction", "getPreselectCondition"));
        }
        return condition2;
    }

    @NotNull
    private List<ChangeListFilteringStrategy> collectStrategies() {
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.add(ChangeListFilteringStrategy.NONE);
        result2.add(new StructureFilteringStrategy(this.myProject));
        boolean addNameFilter = false;
        for (AbstractVcs vcs : ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()) {
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            if (provider == null) continue;
            addNameFilter = true;
            for (ChangeListColumn column : provider.getColumns()) {
                if (!ChangeListColumn.isCustom((ChangeListColumn)column)) continue;
                result2.add(new ColumnFilteringStrategy(column, provider.getClass()));
            }
        }
        if (addNameFilter) {
            result2.add(new ColumnFilteringStrategy(ChangeListColumn.NAME, CommittedChangesProvider.class));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/SelectFilteringAction", "collectStrategies"));
        }
        return arrayList;
    }

    private class SetFilteringAction
    extends DumbAwareAction {
        @NotNull
        private final ChangeListFilteringStrategy myStrategy;

        private SetFilteringAction(ChangeListFilteringStrategy strategy) {
            if (strategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/openapi/vcs/changes/committed/SelectFilteringAction$SetFilteringAction", "<init>"));
            }
            super(strategy.toString());
            this.myStrategy = strategy;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/committed/SelectFilteringAction$SetFilteringAction", "actionPerformed"));
            }
            if (!ChangeListFilteringStrategy.NONE.equals(SelectFilteringAction.this.myPreviousSelection)) {
                SelectFilteringAction.this.myBrowser.removeFilteringStrategy(SelectFilteringAction.this.myPreviousSelection.getKey());
            }
            if (!ChangeListFilteringStrategy.NONE.equals(this.myStrategy)) {
                SelectFilteringAction.this.myBrowser.setFilteringStrategy(this.myStrategy);
            }
            SelectFilteringAction.this.myPreviousSelection = this.myStrategy;
        }
    }
}

