/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.local;

import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.util.EventDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddList
implements ChangeListCommand {
    @NotNull
    private final String myName;
    @Nullable
    private final String myComment;
    @Nullable
    private final Object myData;
    private LocalChangeList myNewListCopy;
    private String myOldComment;

    public AddList(@NotNull String name2, @Nullable String comment, @Nullable Object data) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/local/AddList", "<init>"));
        }
        this.myName = name2;
        this.myComment = comment;
        this.myData = data;
    }

    @Override
    public void apply(ChangeListWorker worker) {
        LocalChangeList list2 = worker.getChangeListByName(this.myName);
        if (list2 != null) {
            this.myOldComment = worker.editComment(this.myName, this.myComment);
        } else {
            list2 = worker.addChangeList(this.myName, this.myComment, this.myData);
            this.myOldComment = null;
        }
        this.myNewListCopy = list2.copy();
    }

    @Override
    public void doNotify(EventDispatcher<ChangeListListener> dispatcher) {
        if (this.myOldComment != null) {
            ((ChangeListListener)dispatcher.getMulticaster()).changeListCommentChanged((ChangeList)this.myNewListCopy, this.myOldComment);
        } else {
            ((ChangeListListener)dispatcher.getMulticaster()).changeListAdded((ChangeList)this.myNewListCopy);
        }
    }

    public LocalChangeList getNewListCopy() {
        return this.myNewListCopy;
    }
}

