/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class BlobIndexUtil {
    public static final String NOT_COMMITTED_HASH = StringUtil.repeat((String)"0", (int)40);

    @NotNull
    public static String getSha1(@NotNull File file2) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/BlobIndexUtil", "getSha1"));
        }
        String string = BlobIndexUtil.getSha1(Files.toByteArray((File)file2));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/BlobIndexUtil", "getSha1"));
        }
        return string;
    }

    @NotNull
    public static String getSha1(@NotNull byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/vcs/changes/patch/BlobIndexUtil", "getSha1"));
        }
        String prefix = "blob " + bytes.length + '\u0000';
        String string = Hashing.sha1().newHasher().putBytes(prefix.getBytes(Charsets.UTF_8)).putBytes(bytes).hash().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/BlobIndexUtil", "getSha1"));
        }
        return string;
    }

    @NotNull
    public static Couple<String> getBeforeAfterSha1(@NotNull Change change) throws VcsException {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/patch/BlobIndexUtil", "getBeforeAfterSha1"));
        }
        ContentRevision beforeRevision = change.getBeforeRevision();
        ContentRevision afterRevision = change.getAfterRevision();
        Charset detectCharset = ((ContentRevision)ObjectUtils.chooseNotNull((Object)afterRevision, (Object)beforeRevision)).getFile().getCharset();
        String before = beforeRevision == null ? NOT_COMMITTED_HASH : BlobIndexUtil.getSha1(BlobIndexUtil.getContentBytes(beforeRevision, detectCharset));
        String after2 = afterRevision == null ? NOT_COMMITTED_HASH : BlobIndexUtil.getSha1(BlobIndexUtil.getContentBytes(afterRevision, detectCharset));
        Couple couple = new Couple((Object)before, (Object)after2);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/BlobIndexUtil", "getBeforeAfterSha1"));
        }
        return couple;
    }

    @NotNull
    private static byte[] getContentBytes(@NotNull ContentRevision revision, @NotNull Charset charset) throws VcsException {
        String stringContent;
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/changes/patch/BlobIndexUtil", "getContentBytes"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vcs/changes/patch/BlobIndexUtil", "getContentBytes"));
        }
        byte[] binaryContent = revision instanceof ByteBackedContentRevision ? ((ByteBackedContentRevision)revision).getContentAsBytes() : ((stringContent = revision.getContent()) != null ? stringContent.getBytes(charset) : ArrayUtil.EMPTY_BYTE_ARRAY);
        byte[] byArray = binaryContent != null ? binaryContent : ArrayUtil.EMPTY_BYTE_ARRAY;
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/BlobIndexUtil", "getContentBytes"));
        }
        return byArray;
    }
}

