/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.FilePatchStatus;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class CommonBinaryFilePatchInProgress<T extends FilePatch>
extends AbstractFilePatchInProgress<T> {
    protected CommonBinaryFilePatchInProgress(T patch, Collection<VirtualFile> autoBases, VirtualFile baseDir) {
        super(patch, autoBases, baseDir);
    }

    @Override
    public ContentRevision getNewContentRevision() {
        if (FilePatchStatus.DELETED.equals((Object)this.myStatus)) {
            return null;
        }
        if (this.myNewContentRevision != null) {
            return this.myNewContentRevision;
        }
        if (this.myPatch.getAfterFileName() != null) {
            FilePath newFilePath = this.getFilePath();
            this.myNewContentRevision = this.createNewContentRevision(newFilePath);
        }
        return this.myNewContentRevision;
    }

    @NotNull
    protected abstract BinaryContentRevision createNewContentRevision(@NotNull FilePath var1);

    @NotNull
    protected abstract Change createChange(Project var1);

    @NotNull
    protected FilePath getFilePath() {
        FilePath filePath = FilePatchStatus.ADDED.equals((Object)this.myStatus) ? VcsUtil.getFilePath((File)this.myIoCurrentBase, (boolean)false) : this.detectNewFilePathForMovedOrModified();
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/CommonBinaryFilePatchInProgress", "getFilePath"));
        }
        return filePath;
    }

    @Override
    @NotNull
    public DiffRequestProducer getDiffRequestProducers(final Project project2, PatchReader baseContents) {
        DiffRequestProducer diffRequestProducer = new DiffRequestProducer(){

            @NotNull
            public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/patch/CommonBinaryFilePatchInProgress$1", "process"));
                }
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/patch/CommonBinaryFilePatchInProgress$1", "process"));
                }
                DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(project2, CommonBinaryFilePatchInProgress.this.createChange(project2), this.getName(), context, indicator);
                if (diffRequest == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/CommonBinaryFilePatchInProgress$1", "process"));
                }
                return diffRequest;
            }

            @NotNull
            public String getName() {
                File file1 = new File(VfsUtilCore.virtualToIoFile((VirtualFile)CommonBinaryFilePatchInProgress.this.getBase()), CommonBinaryFilePatchInProgress.this.myPatch.getAfterName() == null ? CommonBinaryFilePatchInProgress.this.myPatch.getBeforeName() : CommonBinaryFilePatchInProgress.this.myPatch.getAfterName());
                String string = FileUtil.toSystemDependentName((String)file1.getPath());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/CommonBinaryFilePatchInProgress$1", "getName"));
                }
                return string;
            }
        };
        if (diffRequestProducer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/CommonBinaryFilePatchInProgress", "getDiffRequestProducers"));
        }
        return diffRequestProducer;
    }
}

