/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class CreatePatchToClipboardAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(CreatePatchToClipboardAction.class);

    public CreatePatchToClipboardAction() {
        super(VcsBundle.message((String)"create.patch.to.clipboard.title", (Object[])new Object[0]), VcsBundle.message((String)"create.patch.to.clipboard.description", (Object[])new Object[0]), null);
    }

    public void update(AnActionEvent e) {
        Project project2 = e.getProject();
        e.getPresentation().setEnabled(project2 != null && !ArrayUtil.isEmpty((Object[])((Object[])e.getData(VcsDataKeys.CHANGES))));
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        List<Object> changes = Arrays.asList((Object[])e.getRequiredData(VcsDataKeys.CHANGES));
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                String base = PatchWriter.calculateBaseForWritingPatch(project2, changes).getPath();
                List<FilePatch> patches = IdeaTextPatchBuilder.buildPatch(project2, changes, base, false);
                PatchWriter.writeAsPatchToClipboard(project2, patches, base, new CommitContext());
                VcsNotifier.getInstance(project2).notifySuccess("Patch copied to clipboard");
            }
            catch (VcsException | IOException exception) {
                LOG.error("Can't create patch", exception);
                VcsNotifier.getInstance(project2).notifyWeakError("Patch creation failed");
            }
        }, VcsBundle.message((String)"create.patch.commit.action.progress", (Object[])new Object[0]), true, project2);
    }
}

