/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.AutoMatchStrategy;
import com.intellij.openapi.vcs.changes.patch.BinaryFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.PatchBaseDirectoryDetector;
import com.intellij.openapi.vcs.changes.patch.ShelvedBinaryFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatchPatchPaths {
    private static final int BIG_FILE_BOUND = 100000;
    private final Project myProject;
    private final VirtualFile myBaseDir;
    private boolean myUseProjectRootAsPredefinedBase;

    public MatchPatchPaths(Project project2) {
        this.myProject = project2;
        this.myBaseDir = this.myProject.getBaseDir();
    }

    public List<AbstractFilePatchInProgress> execute(@NotNull List<? extends FilePatch> list2) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "execute"));
        }
        return this.execute(list2, false);
    }

    public List<AbstractFilePatchInProgress> execute(@NotNull List<? extends FilePatch> list2, boolean useProjectRootAsPredefinedBase) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "execute"));
        }
        PatchBaseDirectoryDetector directoryDetector = PatchBaseDirectoryDetector.getInstance(this.myProject);
        this.myUseProjectRootAsPredefinedBase = useProjectRootAsPredefinedBase;
        ArrayList<PatchAndVariants> candidates = new ArrayList<PatchAndVariants>(list2.size());
        ArrayList<FilePatch> newOrWithoutMatches = new ArrayList<FilePatch>();
        this.findCandidates(list2, directoryDetector, candidates, newOrWithoutMatches);
        MultiMap result2 = new MultiMap();
        MatchPatchPaths.filterExactMatches(candidates, (MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2);
        MatchPatchPaths.selectByContextOrByStrip(candidates, (MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2);
        this.workWithNotExisting(directoryDetector, newOrWithoutMatches, (MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2);
        return new ArrayList<AbstractFilePatchInProgress>(result2.values());
    }

    private void workWithNotExisting(@NotNull PatchBaseDirectoryDetector directoryDetector, @NotNull List<FilePatch> newOrWithoutMatches, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2) {
        if (directoryDetector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryDetector", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "workWithNotExisting"));
        }
        if (newOrWithoutMatches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOrWithoutMatches", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "workWithNotExisting"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "workWithNotExisting"));
        }
        for (FilePatch patch : newOrWithoutMatches) {
            AbstractFilePatchInProgress patchInProgress;
            String afterName = patch.getAfterName();
            String[] strings = afterName != null ? afterName.replace('\\', '/').split("/") : ArrayUtil.EMPTY_STRING_ARRAY;
            Pair<VirtualFile, Integer> best = null;
            for (int i2 = strings.length - 2; i2 >= 0; --i2) {
                String name2 = strings[i2];
                Collection<VirtualFile> files = this.findFilesFromIndex(directoryDetector, name2);
                if (files.isEmpty()) continue;
                for (VirtualFile file2 : files) {
                    Pair<VirtualFile, Integer> pair2 = MatchPatchPaths.compareNamesImpl(strings, file2, i2);
                    if (pair2 == null || (Integer)pair2.getSecond() >= i2 || best != null && (Integer)pair2.getSecond() >= (Integer)best.getSecond() && !this.isGoodAndProjectBased(best, pair2)) continue;
                    best = pair2;
                }
            }
            if (best != null) {
                patchInProgress = MatchPatchPaths.createPatchInProgress(patch, (VirtualFile)best.getFirst());
                if (patchInProgress == null) break;
                AutoMatchStrategy.processStipUp(patchInProgress, (Integer)best.getSecond());
                result2.putValue(best.getFirst(), (Object)patchInProgress);
                continue;
            }
            patchInProgress = MatchPatchPaths.createPatchInProgress(patch, this.myBaseDir);
            if (patchInProgress == null) break;
            result2.putValue((Object)this.myBaseDir, (Object)patchInProgress);
        }
    }

    private boolean isGoodAndProjectBased(@NotNull Pair<VirtualFile, Integer> bestVariant, @NotNull Pair<VirtualFile, Integer> currentVariant) {
        if (bestVariant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bestVariant", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "isGoodAndProjectBased"));
        }
        if (currentVariant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentVariant", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "isGoodAndProjectBased"));
        }
        return ((Integer)currentVariant.getSecond()).equals(bestVariant.getSecond()) && this.myBaseDir.equals(currentVariant.getFirst());
    }

    private static void selectByContextOrByStrip(@NotNull List<PatchAndVariants> candidates, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "selectByContextOrByStrip"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "selectByContextOrByStrip"));
        }
        for (PatchAndVariants candidate : candidates) {
            candidate.findAndAddBestVariant(result2);
        }
    }

    private static void filterExactMatches(@NotNull List<PatchAndVariants> candidates, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "filterExactMatches"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "filterExactMatches"));
        }
        Iterator<PatchAndVariants> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            PatchAndVariants candidate = iterator.next();
            if (candidate.getVariants().size() == 1) {
                AbstractFilePatchInProgress oneCandidate = candidate.getVariants().get(0);
                result2.putValue((Object)oneCandidate.getBase(), (Object)oneCandidate);
                iterator.remove();
                continue;
            }
            ArrayList<AbstractFilePatchInProgress> exact = new ArrayList<AbstractFilePatchInProgress>(candidate.getVariants().size());
            for (AbstractFilePatchInProgress patch : candidate.getVariants()) {
                if (patch.getCurrentStrip() != 0) continue;
                exact.add(patch);
            }
            if (exact.size() == 1) {
                AbstractFilePatchInProgress patchInProgress = (AbstractFilePatchInProgress)exact.get(0);
                MatchPatchPaths.putSelected(result2, candidate.getVariants(), patchInProgress);
                iterator.remove();
                continue;
            }
            if (exact.isEmpty()) continue;
            candidate.getVariants().retainAll(exact);
        }
    }

    private void findCandidates(@NotNull List<? extends FilePatch> list2, @NotNull PatchBaseDirectoryDetector directoryDetector, @NotNull List<PatchAndVariants> candidates, @NotNull List<FilePatch> newOrWithoutMatches) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "findCandidates"));
        }
        if (directoryDetector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryDetector", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "findCandidates"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "findCandidates"));
        }
        if (newOrWithoutMatches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOrWithoutMatches", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "findCandidates"));
        }
        for (FilePatch filePatch : list2) {
            VirtualFile relativeFile;
            String fileName = filePatch.getBeforeFileName();
            if (filePatch.isNewFile() || filePatch.getBeforeName() == null) {
                newOrWithoutMatches.add(filePatch);
                continue;
            }
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.findFilesFromIndex(directoryDetector, fileName));
            if (filePatch.getBeforeName() != null && filePatch.getBeforeName().startsWith("..") && (relativeFile = VfsUtil.findRelativeFile((VirtualFile)this.myBaseDir, (String[])filePatch.getBeforeName().replace('\\', '/').split("/"))) != null) {
                files.add(relativeFile);
            }
            if (files.isEmpty()) {
                newOrWithoutMatches.add(filePatch);
                continue;
            }
            List variants = ContainerUtil.mapNotNull(files, file2 -> MatchPatchPaths.processMatch(patch, file2));
            if (variants.isEmpty()) {
                newOrWithoutMatches.add(filePatch);
                continue;
            }
            candidates.add(new PatchAndVariants(variants));
        }
    }

    private Collection<VirtualFile> findFilesFromIndex(@NotNull PatchBaseDirectoryDetector directoryDetector, @NotNull String fileName) {
        if (directoryDetector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryDetector", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "findFilesFromIndex"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "findFilesFromIndex"));
        }
        Collection files = (Collection)ReadAction.compute(() -> {
            if (directoryDetector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryDetector", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "lambda$findFilesFromIndex$1"));
            }
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "lambda$findFilesFromIndex$1"));
            }
            return directoryDetector.findFiles(fileName);
        });
        File shelfResourcesDirectory = ShelveChangesManager.getInstance(this.myProject).getShelfResourcesDirectory();
        return ContainerUtil.filter((Collection)files, file2 -> !FileUtil.isAncestor((File)shelfResourcesDirectory, (File)VfsUtilCore.virtualToIoFile((VirtualFile)file2), (boolean)false));
    }

    private static void putSelected(@NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2, @NotNull List<AbstractFilePatchInProgress> variants, @NotNull AbstractFilePatchInProgress patchInProgress) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "putSelected"));
        }
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "putSelected"));
        }
        if (patchInProgress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchInProgress", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "putSelected"));
        }
        patchInProgress.setAutoBases(ContainerUtil.mapNotNull(variants, AbstractFilePatchInProgress::getBase));
        result2.putValue((Object)patchInProgress.getBase(), (Object)patchInProgress);
    }

    private static int getMatchingLines(AbstractFilePatchInProgress<TextFilePatch> patch) {
        String text2;
        VirtualFile base = patch.getCurrentBase();
        if (base == null) {
            return -1;
        }
        try {
            text2 = base.getLength() > 100000L ? VfsUtilCore.loadText((VirtualFile)base, (int)100000) : VfsUtilCore.loadText((VirtualFile)base);
        }
        catch (IOException e) {
            return 0;
        }
        return new GenericPatchApplier(text2, patch.getPatch().getHunks()).weightContextMatch(100, 5);
    }

    private boolean variantMatchedToProjectDir(@NotNull AbstractFilePatchInProgress variant) {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "variantMatchedToProjectDir"));
        }
        return variant.getCurrentStrip() == 0 && this.myProject.getBaseDir().equals(variant.getBase());
    }

    private static Pair<VirtualFile, Integer> compareNames(String beforeName, VirtualFile file2) {
        if (beforeName == null) {
            return null;
        }
        String[] parts = beforeName.replace('\\', '/').split("/");
        return MatchPatchPaths.compareNamesImpl(parts, file2.getParent(), parts.length - 2);
    }

    private static Pair<VirtualFile, Integer> compareNamesImpl(String[] parts, VirtualFile parent, int idx) {
        while (parent != null && idx >= 0) {
            if (!parent.getName().equals(parts[idx])) {
                return new Pair((Object)parent, (Object)(idx + 1));
            }
            parent = parent.getParent();
            --idx;
        }
        return new Pair((Object)parent, (Object)(idx + 1));
    }

    @Nullable
    private static AbstractFilePatchInProgress processMatch(FilePatch patch, VirtualFile file2) {
        String beforeName = patch.getBeforeName();
        Pair<VirtualFile, Integer> pair2 = MatchPatchPaths.compareNames(beforeName, file2);
        if (pair2 == null) {
            return null;
        }
        VirtualFile parent = (VirtualFile)pair2.getFirst();
        if (parent == null) {
            return null;
        }
        AbstractFilePatchInProgress result2 = MatchPatchPaths.createPatchInProgress(patch, parent);
        if (result2 != null) {
            AutoMatchStrategy.processStipUp(result2, (Integer)pair2.getSecond());
        }
        return result2;
    }

    @Nullable
    private static AbstractFilePatchInProgress createPatchInProgress(@NotNull FilePatch patch, @NotNull VirtualFile dir) {
        if (patch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "createPatchInProgress"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths", "createPatchInProgress"));
        }
        if (patch instanceof TextFilePatch) {
            return new TextFilePatchInProgress((TextFilePatch)patch, null, dir);
        }
        if (patch instanceof ShelvedBinaryFilePatch) {
            return new ShelvedBinaryFilePatchInProgress((ShelvedBinaryFilePatch)patch, null, dir);
        }
        if (patch instanceof BinaryFilePatch) {
            return new BinaryFilePatchInProgress((BinaryFilePatch)patch, null, dir);
        }
        return null;
    }

    private class PatchAndVariants {
        @NotNull
        private final List<AbstractFilePatchInProgress> myVariants;

        private PatchAndVariants(List<AbstractFilePatchInProgress> variants) {
            if (variants == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths$PatchAndVariants", "<init>"));
            }
            this.myVariants = variants;
        }

        @NotNull
        public List<AbstractFilePatchInProgress> getVariants() {
            List<AbstractFilePatchInProgress> list2 = this.myVariants;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths$PatchAndVariants", "getVariants"));
            }
            return list2;
        }

        public void findAndAddBestVariant(@NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2) {
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths$PatchAndVariants", "findAndAddBestVariant"));
            }
            AbstractFilePatchInProgress best = (AbstractFilePatchInProgress)ContainerUtil.getFirstItem(this.myVariants);
            if (best == null) {
                return;
            }
            if (best instanceof TextFilePatchInProgress) {
                int maxLines = -100;
                for (AbstractFilePatchInProgress variant : this.myVariants) {
                    TextFilePatchInProgress textFilePAch = (TextFilePatchInProgress)variant;
                    if (MatchPatchPaths.this.myUseProjectRootAsPredefinedBase && MatchPatchPaths.this.variantMatchedToProjectDir(textFilePAch)) {
                        best = textFilePAch;
                        break;
                    }
                    int lines = MatchPatchPaths.getMatchingLines(textFilePAch);
                    if (lines <= maxLines) continue;
                    maxLines = lines;
                    best = textFilePAch;
                }
                MatchPatchPaths.putSelected((MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2, this.myVariants, best);
            } else {
                int stripCounter = Integer.MAX_VALUE;
                for (AbstractFilePatchInProgress variant : this.myVariants) {
                    int currentStrip = variant.getCurrentStrip();
                    if (MatchPatchPaths.this.variantMatchedToProjectDir(variant)) {
                        best = variant;
                        break;
                    }
                    if (currentStrip >= stripCounter) continue;
                    best = variant;
                    stripCounter = currentStrip;
                }
                MatchPatchPaths.putSelected((MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2, this.myVariants, best);
            }
        }
    }
}

