/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchNameChecker {
    public static final int MAX = 100;
    private static final int MAX_PATH = 255;

    @Nullable
    public static String validateName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/patch/PatchNameChecker", "validateName"));
        }
        String fileName = new File(name2).getName();
        if (StringUtil.isEmptyOrSpaces((String)fileName)) {
            return "File name cannot be empty";
        }
        if (name2.length() > 255) {
            return "File path should not be too long.";
        }
        return null;
    }
}

