/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.BinaryPatchWriter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchWriter {
    public static void writePatches(@NotNull Project project2, @NotNull String fileName, @NotNull String basePath, @NotNull List<FilePatch> patches, @Nullable CommitContext commitContext, @NotNull Charset charset) throws IOException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writePatches"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writePatches"));
        }
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writePatches"));
        }
        if (patches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patches", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writePatches"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writePatches"));
        }
        PatchWriter.writePatches(project2, fileName, basePath, patches, commitContext, charset, false);
    }

    public static void writePatches(@NotNull Project project2, @NotNull String fileName, @Nullable String basePath, @NotNull List<FilePatch> patches, @Nullable CommitContext commitContext, @NotNull Charset charset, boolean includeBinaries) throws IOException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writePatches"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writePatches"));
        }
        if (patches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patches", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writePatches"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writePatches"));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), charset);){
            PatchWriter.write(project2, writer, basePath, patches, commitContext, includeBinaries);
        }
    }

    private static void write(@NotNull Project project2, @NotNull Writer writer, @Nullable String basePath, @NotNull List<FilePatch> patches, @Nullable CommitContext commitContext, boolean includeBinaries) throws IOException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "write"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "write"));
        }
        if (patches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patches", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "write"));
        }
        String lineSeparator = CodeStyleFacade.getInstance((Project)project2).getLineSeparator();
        UnifiedDiffWriter.write((Project)project2, (String)basePath, patches, (Writer)writer, (String)lineSeparator, (PatchEP[])((PatchEP[])Extensions.getExtensions((ExtensionPointName)PatchEP.EP_NAME, (AreaInstance)project2)), (CommitContext)commitContext);
        if (includeBinaries) {
            BinaryPatchWriter.writeBinaries(basePath, ContainerUtil.findAll(patches, BinaryFilePatch.class), writer);
        }
    }

    public static void writeAsPatchToClipboard(@NotNull Project project2, @NotNull List<FilePatch> patches, @NotNull String basePath, @Nullable CommitContext commitContext) throws IOException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writeAsPatchToClipboard"));
        }
        if (patches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patches", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writeAsPatchToClipboard"));
        }
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "writeAsPatchToClipboard"));
        }
        StringWriter writer = new StringWriter();
        PatchWriter.write(project2, writer, basePath, patches, commitContext, true);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(writer.toString()));
    }

    @NotNull
    public static VirtualFile calculateBaseForWritingPatch(@NotNull Project project2, @NotNull Collection<Change> changes) {
        boolean multiVcs;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "calculateBaseForWritingPatch"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "calculateBaseForWritingPatch"));
        }
        File commonAncestor = ChangesUtil.findCommonAncestor(changes);
        boolean bl = multiVcs = ChangesUtil.getAffectedVcses(changes, (Project)project2).size() != 1;
        if (multiVcs || commonAncestor == null) {
            VirtualFile virtualFile = project2.getBaseDir();
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "calculateBaseForWritingPatch"));
            }
            return virtualFile;
        }
        VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)project2, (FilePath)VcsUtil.getFilePath((File)commonAncestor));
        VirtualFile virtualFile = (VirtualFile)ObjectUtils.chooseNotNull((Object)vcsRoot, (Object)project2.getBaseDir());
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchWriter", "calculateBaseForWritingPatch"));
        }
        return virtualFile;
    }
}

