/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchRequest;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchMergeRequest
extends MergeRequest
implements ApplyPatchRequest {
    @Nullable
    private final Project myProject;
    @NotNull
    private final DocumentContent myResultContent;
    @NotNull
    private final AppliedTextPatch myAppliedPatch;
    @NotNull
    private final CharSequence myOriginalContent;
    @NotNull
    private final String myLocalContent;
    @Nullable
    private final String myWindowTitle;
    @NotNull
    private final String myLocalTitle;
    @NotNull
    private final String myResultTitle;
    @NotNull
    private final String myPatchTitle;
    @Nullable
    private final Consumer<MergeResult> myCallback;

    public ApplyPatchMergeRequest(@Nullable Project project2, @NotNull DocumentContent resultContent, @NotNull AppliedTextPatch appliedPatch, @NotNull String localContent, @Nullable String windowTitle, @NotNull String localTitle, @NotNull String resultTitle, @NotNull String patchTitle, @Nullable Consumer<MergeResult> callback) {
        if (resultContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultContent", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeRequest", "<init>"));
        }
        if (appliedPatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appliedPatch", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeRequest", "<init>"));
        }
        if (localContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localContent", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeRequest", "<init>"));
        }
        if (localTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localTitle", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeRequest", "<init>"));
        }
        if (resultTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultTitle", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeRequest", "<init>"));
        }
        if (patchTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchTitle", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeRequest", "<init>"));
        }
        this.myProject = project2;
        this.myResultContent = resultContent;
        this.myAppliedPatch = appliedPatch;
        this.myOriginalContent = (CharSequence)ReadAction.compute(() -> this.myResultContent.getDocument().getImmutableCharSequence());
        this.myLocalContent = localContent;
        this.myWindowTitle = windowTitle;
        this.myLocalTitle = localTitle;
        this.myResultTitle = resultTitle;
        this.myPatchTitle = patchTitle;
        this.myCallback = callback;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public DocumentContent getResultContent() {
        DocumentContent documentContent = this.myResultContent;
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeRequest", "getResultContent"));
        }
        return documentContent;
    }

    @Override
    @NotNull
    public String getLocalContent() {
        String string = this.myLocalContent;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeRequest", "getLocalContent"));
        }
        return string;
    }

    @Override
    @NotNull
    public AppliedTextPatch getPatch() {
        AppliedTextPatch appliedTextPatch = this.myAppliedPatch;
        if (appliedTextPatch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeRequest", "getPatch"));
        }
        return appliedTextPatch;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.myWindowTitle;
    }

    @Override
    @NotNull
    public String getLocalTitle() {
        String string = this.myLocalTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeRequest", "getLocalTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getResultTitle() {
        String string = this.myResultTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeRequest", "getResultTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getPatchTitle() {
        String string = this.myPatchTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeRequest", "getPatchTitle"));
        }
        return string;
    }

    public void applyResult(@NotNull MergeResult result2) {
        CharSequence applyContent;
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeRequest", "applyResult"));
        }
        switch (result2) {
            case CANCEL: {
                applyContent = this.myOriginalContent;
                break;
            }
            case LEFT: {
                applyContent = this.myLocalContent;
                break;
            }
            case RIGHT: {
                throw new UnsupportedOperationException();
            }
            case RESOLVED: {
                applyContent = null;
                break;
            }
            default: {
                throw new IllegalArgumentException(result2.name());
            }
        }
        if (applyContent != null) {
            new WriteCommandAction.Simple(this.myProject, new PsiFile[0]){

                protected void run() throws Throwable {
                    ApplyPatchMergeRequest.this.myResultContent.getDocument().setText(applyContent);
                }
            }.execute();
        }
        if (this.myCallback != null) {
            this.myCallback.consume((Object)result2);
        }
    }
}

