/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.patch.tool.PatchChangeBuilder;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.ui.components.panels.Wrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchDiffTool
implements FrameDiffTool {
    @NotNull
    public String getName() {
        if ("Patch content viewer" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool", "getName"));
        }
        return "Patch content viewer";
    }

    public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool", "canShow"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool", "canShow"));
        }
        return request instanceof PatchDiffRequest;
    }

    @NotNull
    public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool", "createComponent"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool", "createComponent"));
        }
        MyPatchViewer myPatchViewer = new MyPatchViewer(context, (PatchDiffRequest)request);
        if (myPatchViewer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool", "createComponent"));
        }
        return myPatchViewer;
    }

    private static class MyPatchViewer
    implements FrameDiffTool.DiffViewer,
    DataProvider {
        private final Project myProject;
        private final SimpleDiffPanel myPanel;
        private final EditorEx myEditor;
        private final DiffContext myContext;
        private final PatchDiffRequest myRequest;
        private final MyPrevNextDifferenceIterable myPrevNextDifferenceIterable;
        private final List<PatchChangeBuilder.Hunk> myHunks = new ArrayList<PatchChangeBuilder.Hunk>();

        public MyPatchViewer(DiffContext context, PatchDiffRequest request) {
            this.myProject = context.getProject();
            this.myContext = context;
            this.myRequest = request;
            Document document = EditorFactory.getInstance().createDocument((CharSequence)"");
            this.myEditor = DiffUtil.createEditor(document, this.myProject, true, true);
            this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
            Wrapper editorPanel = new Wrapper((LayoutManager)new BorderLayout(0, DiffUtil.TITLE_GAP), this.myEditor.getComponent());
            String panelTitle = request.getPanelTitle();
            if (panelTitle != null) {
                editorPanel.add((Component)DiffUtil.createTitle(panelTitle), (Object)"North");
            }
            this.myPanel = new SimpleDiffPanel((JComponent)editorPanel, (DataProvider)this, context);
        }

        @NotNull
        public JComponent getComponent() {
            SimpleDiffPanel simpleDiffPanel = this.myPanel;
            if (simpleDiffPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool$MyPatchViewer", "getComponent"));
            }
            return simpleDiffPanel;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myEditor.getContentComponent();
        }

        @NotNull
        public FrameDiffTool.ToolbarComponents init() {
            this.myPanel.setPersistentNotifications(DiffUtil.getCustomNotifications((UserDataHolder)this.myContext, (UserDataHolder)this.myRequest));
            this.onInit();
            FrameDiffTool.ToolbarComponents toolbarComponents = new FrameDiffTool.ToolbarComponents();
            if (toolbarComponents == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool$MyPatchViewer", "init"));
            }
            return toolbarComponents;
        }

        public void dispose() {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        }

        private void onInit() {
            PatchChangeBuilder builder = new PatchChangeBuilder();
            builder.exec(this.myRequest.getPatch().getHunks());
            this.myHunks.addAll(builder.getHunks());
            DocumentEx patchDocument = this.myEditor.getDocument();
            WriteAction.run(() -> patchDocument.setText(builder.getPatchContent().toString()));
            this.myEditor.getGutterComponentEx().setLineNumberConvertor(builder.getLineConvertor1().createConvertor(), builder.getLineConvertor2().createConvertor());
            for (int line : builder.getSeparatorLines().toNativeArray()) {
                int offset = patchDocument.getLineStartOffset(line);
                DiffDrawUtil.createLineSeparatorHighlighter(this.myEditor, offset, offset, BooleanGetter.TRUE);
            }
            Object object = this.myHunks.iterator();
            while (object.hasNext()) {
                PatchChangeBuilder.Hunk hunk = (PatchChangeBuilder.Hunk)object.next();
                DiffDrawUtil.createUnifiedChunkHighlighters(this.myEditor, hunk.getPatchDeletionRange(), hunk.getPatchInsertionRange(), null);
            }
            this.myEditor.getGutterComponentEx().revalidateMarkup();
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myProject;
            }
            if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
                return this.myPrevNextDifferenceIterable;
            }
            if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
                return this.myEditor;
            }
            if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId)) {
                return this.myPrevNextDifferenceIterable.getHunkRangeByLine(this.myEditor.getCaretModel().getLogicalPosition().line);
            }
            return null;
        }

        private class MyPrevNextDifferenceIterable
        extends PrevNextDifferenceIterableBase<PatchChangeBuilder.Hunk> {
            private MyPrevNextDifferenceIterable() {
            }

            @Override
            @NotNull
            protected List<PatchChangeBuilder.Hunk> getChanges() {
                List list2 = MyPatchViewer.this.myHunks;
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool$MyPatchViewer$MyPrevNextDifferenceIterable", "getChanges"));
                }
                return list2;
            }

            @Override
            @NotNull
            protected EditorEx getEditor() {
                EditorEx editorEx = MyPatchViewer.this.myEditor;
                if (editorEx == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool$MyPatchViewer$MyPrevNextDifferenceIterable", "getEditor"));
                }
                return editorEx;
            }

            @Override
            protected int getStartLine(@NotNull PatchChangeBuilder.Hunk change) {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool$MyPatchViewer$MyPrevNextDifferenceIterable", "getStartLine"));
                }
                return change.getPatchDeletionRange().start;
            }

            @Override
            protected int getEndLine(@NotNull PatchChangeBuilder.Hunk change) {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool$MyPatchViewer$MyPrevNextDifferenceIterable", "getEndLine"));
                }
                return change.getPatchInsertionRange().end;
            }

            @Nullable
            LineRange getHunkRangeByLine(int line) {
                for (PatchChangeBuilder.Hunk hunk : this.getChanges()) {
                    int start = hunk.getPatchDeletionRange().start;
                    int end = hunk.getPatchInsertionRange().end;
                    if (start <= line && end > line) {
                        return new LineRange(start, end);
                    }
                    if (start <= line) continue;
                    return null;
                }
                return null;
            }
        }
    }
}

