/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ShelvedChangeList
implements JDOMExternalizable,
ExternalizableScheme {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList");
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    @NonNls
    private static final String ATTRIBUTE_DATE = "date";
    @NonNls
    private static final String ATTRIBUTE_RECYCLED_CHANGELIST = "recycled";
    @NonNls
    private static final String ATTRIBUTE_TOBE_DELETED_CHANGELIST = "toDelete";
    @NonNls
    private static final String ELEMENT_BINARY = "binary";
    public String PATH;
    public String DESCRIPTION;
    public Date DATE;
    private List<ShelvedChange> myChanges;
    private List<ShelvedBinaryFile> myBinaryFiles;
    private boolean myRecycled;
    private boolean myToDelete;
    private String mySchemeName;

    public ShelvedChangeList() {
    }

    public ShelvedChangeList(String path, String description, List<ShelvedBinaryFile> binaryFiles) {
        this(path, description, binaryFiles, System.currentTimeMillis());
    }

    public ShelvedChangeList(String path, String description, List<ShelvedBinaryFile> binaryFiles, long time) {
        this.PATH = FileUtil.toSystemIndependentName((String)path);
        this.DESCRIPTION = description;
        this.DATE = new Date(time);
        this.myBinaryFiles = binaryFiles;
        this.mySchemeName = this.DESCRIPTION;
    }

    public static ShelvedChangeList copy(@NotNull ShelvedChangeList list2) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangeList", "copy"));
        }
        ShelvedChangeList copied = new ShelvedChangeList();
        copied.PATH = list2.PATH;
        copied.DESCRIPTION = list2.DESCRIPTION;
        copied.DATE = list2.DATE;
        copied.myBinaryFiles = new ArrayList<ShelvedBinaryFile>();
        for (ShelvedBinaryFile file2 : list2.getBinaryFiles()) {
            copied.myBinaryFiles.add(new ShelvedBinaryFile(file2.BEFORE_PATH, file2.AFTER_PATH, file2.SHELVED_PATH));
        }
        copied.mySchemeName = list2.DESCRIPTION;
        copied.myRecycled = list2.isRecycled();
        copied.myToDelete = list2.isMarkedToDelete();
        return copied;
    }

    public boolean isRecycled() {
        return this.myRecycled;
    }

    public void setRecycled(boolean recycled) {
        this.myRecycled = recycled;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.PATH = FileUtil.toSystemIndependentName((String)this.PATH);
        this.mySchemeName = element.getAttributeValue(NAME_ATTRIBUTE);
        this.DATE = new Date(Long.parseLong(element.getAttributeValue(ATTRIBUTE_DATE)));
        this.myRecycled = Boolean.parseBoolean(element.getAttributeValue(ATTRIBUTE_RECYCLED_CHANGELIST));
        this.myToDelete = Boolean.parseBoolean(element.getAttributeValue(ATTRIBUTE_TOBE_DELETED_CHANGELIST));
        List children2 = element.getChildren(ELEMENT_BINARY);
        this.myBinaryFiles = new ArrayList<ShelvedBinaryFile>(children2.size());
        for (Element child : children2) {
            ShelvedBinaryFile binaryFile = new ShelvedBinaryFile();
            binaryFile.readExternal(child);
            this.myBinaryFiles.add(binaryFile);
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangeList", "writeExternal"));
        }
        ShelvedChangeList.writeExternal(element, this);
    }

    private static void writeExternal(@NotNull Element element, @NotNull ShelvedChangeList shelvedChangeList) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangeList", "writeExternal"));
        }
        if (shelvedChangeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shelvedChangeList", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangeList", "writeExternal"));
        }
        DefaultJDOMExternalizer.writeExternal((Object)shelvedChangeList, (Element)element);
        element.setAttribute(NAME_ATTRIBUTE, shelvedChangeList.getName());
        element.setAttribute(ATTRIBUTE_DATE, Long.toString(shelvedChangeList.DATE.getTime()));
        element.setAttribute(ATTRIBUTE_RECYCLED_CHANGELIST, Boolean.toString(shelvedChangeList.isRecycled()));
        if (shelvedChangeList.isMarkedToDelete()) {
            element.setAttribute(ATTRIBUTE_TOBE_DELETED_CHANGELIST, Boolean.toString(shelvedChangeList.isMarkedToDelete()));
        }
        for (ShelvedBinaryFile file2 : shelvedChangeList.getBinaryFiles()) {
            Element child = new Element(ELEMENT_BINARY);
            file2.writeExternal(child);
            element.addContent(child);
        }
    }

    public String toString() {
        return this.DESCRIPTION;
    }

    public List<ShelvedChange> getChanges(Project project2) {
        if (this.myChanges == null) {
            try {
                this.myChanges = new ArrayList<ShelvedChange>();
                List<? extends FilePatch> list2 = ShelveChangesManager.loadPatchesWithoutContent(project2, this.PATH, null);
                for (FilePatch filePatch : list2) {
                    FileStatus status = filePatch.isNewFile() ? FileStatus.ADDED : (filePatch.isDeletedFile() ? FileStatus.DELETED : FileStatus.MODIFIED);
                    this.myChanges.add(new ShelvedChange(this.PATH, filePatch.getBeforeName(), filePatch.getAfterName(), status));
                }
            }
            catch (Exception e) {
                LOG.error("Failed to parse the file patch: [" + this.PATH + "]", (Throwable)e);
            }
        }
        return this.myChanges;
    }

    public void clearLoadedChanges() {
        this.myChanges = null;
    }

    public List<ShelvedBinaryFile> getBinaryFiles() {
        return this.myBinaryFiles;
    }

    @NotNull
    public String getName() {
        String string = this.mySchemeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangeList", "getName"));
        }
        return string;
    }

    @Override
    public void setName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangeList", "setName"));
        }
        this.mySchemeName = newName;
    }

    public boolean isValid() {
        return new File(this.PATH).exists();
    }

    public void markToDelete(boolean toDeleted) {
        this.myToDelete = toDeleted;
    }

    public boolean isMarkedToDelete() {
        return this.myToDelete;
    }

    public void updateDate() {
        this.DATE = new Date(System.currentTimeMillis());
    }
}

