/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.ui.CommitHelper;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DefaultCommitResultHandler
implements CommitResultHandler {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Collection<Change> myIncludedChanges;
    @NotNull
    private final String myCommitMessage;
    @NotNull
    private final CommitHelper.GeneralCommitProcessor myCommitProcessor;
    @NotNull
    private final Set<String> myFeedback;

    public DefaultCommitResultHandler(@NotNull Project project2, @NotNull Collection<Change> includedChanges, @NotNull String commitMessage, @NotNull CommitHelper.GeneralCommitProcessor commitProcessor, @NotNull Set<String> feedback) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/DefaultCommitResultHandler", "<init>"));
        }
        if (includedChanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includedChanges", "com/intellij/openapi/vcs/changes/ui/DefaultCommitResultHandler", "<init>"));
        }
        if (commitMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "com/intellij/openapi/vcs/changes/ui/DefaultCommitResultHandler", "<init>"));
        }
        if (commitProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitProcessor", "com/intellij/openapi/vcs/changes/ui/DefaultCommitResultHandler", "<init>"));
        }
        if (feedback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "feedback", "com/intellij/openapi/vcs/changes/ui/DefaultCommitResultHandler", "<init>"));
        }
        this.myProject = project2;
        this.myIncludedChanges = includedChanges;
        this.myCommitMessage = commitMessage;
        this.myCommitProcessor = commitProcessor;
        this.myFeedback = feedback;
    }

    public void onSuccess(@NotNull String commitMessage) {
        if (commitMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "com/intellij/openapi/vcs/changes/ui/DefaultCommitResultHandler", "onSuccess"));
        }
        this.reportResult();
    }

    public void onFailure() {
        this.reportResult();
    }

    private void reportResult() {
        List<VcsException> errors = CommitHelper.collectErrors(this.myCommitProcessor.getVcsExceptions());
        int errorsSize = errors.size();
        int warningsSize = this.myCommitProcessor.getVcsExceptions().size() - errorsSize;
        VcsNotifier notifier = VcsNotifier.getInstance(this.myProject);
        String message2 = this.getCommitSummary();
        if (errorsSize > 0) {
            String title = StringUtil.pluralize((String)VcsBundle.message((String)"message.text.commit.failed.with.error", (Object[])new Object[0]), (int)errorsSize);
            notifier.notifyError(title, message2);
        } else if (warningsSize > 0) {
            String title = StringUtil.pluralize((String)VcsBundle.message((String)"message.text.commit.finished.with.warning", (Object[])new Object[0]), (int)warningsSize);
            notifier.notifyImportantWarning(title, message2);
        } else {
            notifier.notifySuccess(message2);
        }
    }

    @NotNull
    private String getCommitSummary() {
        List<VcsException> exceptions;
        StringBuilder content = new StringBuilder(this.getFileSummaryReport(this.myCommitProcessor.getChangesFailedToCommit()));
        if (!StringUtil.isEmpty((String)this.myCommitMessage)) {
            content.append(": ").append(DefaultCommitResultHandler.escape(this.myCommitMessage));
        }
        if (!this.myFeedback.isEmpty()) {
            content.append("<br/>");
            content.append(StringUtil.join(this.myFeedback, (String)"<br/>"));
        }
        if (!CommitHelper.hasOnlyWarnings(exceptions = this.myCommitProcessor.getVcsExceptions())) {
            content.append("<br/>");
            content.append(StringUtil.join(exceptions, Throwable::getMessage, (String)"<br/>"));
        }
        String string = content.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/DefaultCommitResultHandler", "getCommitSummary"));
        }
        return string;
    }

    @NotNull
    private String getFileSummaryReport(@NotNull List<Change> changesFailedToCommit) {
        if (changesFailedToCommit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changesFailedToCommit", "com/intellij/openapi/vcs/changes/ui/DefaultCommitResultHandler", "getFileSummaryReport"));
        }
        int failed = changesFailedToCommit.size();
        int committed = this.myIncludedChanges.size() - failed;
        String fileSummary = committed + " " + StringUtil.pluralize((String)"file", (int)committed) + " committed";
        if (failed > 0) {
            fileSummary = fileSummary + ", " + failed + " " + StringUtil.pluralize((String)"file", (int)failed) + " failed to commit";
        }
        String string = fileSummary;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/DefaultCommitResultHandler", "getFileSummaryReport"));
        }
        return string;
    }

    private static String escape(String s) {
        String[] FROM = new String[]{"<", ">"};
        String[] TO = new String[]{"&lt;", "&gt;"};
        return StringUtil.replace((String)s, (String[])FROM, (String[])TO);
    }
}

