/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.IgnoreSettingsType;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.ui.IgnoreUnversionedDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IgnoredSettingsPanel
implements SearchableConfigurable,
Configurable.NoScroll {
    private JBList myList;
    private JPanel myPanel;
    private final Project myProject;
    private DefaultListModel myModel;
    private final ChangeListManagerImpl myChangeListManager;
    private final Set<String> myDirectoriesManuallyRemovedFromIgnored = new HashSet<String>();

    public IgnoredSettingsPanel(Project project2) {
        this.myList = new JBList();
        this.myList.setCellRenderer((ListCellRenderer)((Object)new MyCellRenderer()));
        this.myList.getEmptyText().setText(VcsBundle.message((String)"no.ignored.files", (Object[])new Object[0]));
        this.myProject = project2;
        this.myChangeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
    }

    private void setItems(IgnoredFileBean[] filesToIgnore) {
        this.myModel = new DefaultListModel();
        for (IgnoredFileBean bean : filesToIgnore) {
            this.myModel.addElement(bean);
        }
        this.myList.setModel((ListModel)this.myModel);
    }

    public IgnoredFileBean[] getItems() {
        int count = this.myList.getModel().getSize();
        IgnoredFileBean[] result2 = new IgnoredFileBean[count];
        for (int i2 = 0; i2 < count; ++i2) {
            result2[i2] = (IgnoredFileBean)this.myList.getModel().getElementAt(i2);
        }
        return result2;
    }

    private void addItem() {
        IgnoreUnversionedDialog dlg = new IgnoreUnversionedDialog(this.myProject);
        if (dlg.showAndGet()) {
            IgnoredFileBean[] ignoredFiles;
            for (IgnoredFileBean bean : ignoredFiles = dlg.getSelectedIgnoredFiles()) {
                this.myModel.addElement(bean);
            }
        }
    }

    private void editItem() {
        IgnoredFileBean bean = (IgnoredFileBean)this.myList.getSelectedValue();
        if (bean == null) {
            return;
        }
        IgnoreUnversionedDialog dlg = new IgnoreUnversionedDialog(this.myProject);
        dlg.setIgnoredFile(bean);
        if (dlg.showAndGet()) {
            IgnoredFileBean[] beans = dlg.getSelectedIgnoredFiles();
            assert (beans.length == 1);
            int selectedIndex = this.myList.getSelectedIndex();
            this.myModel.setElementAt(beans[0], selectedIndex);
        }
    }

    private void deleteItems() {
        for (Object o : this.myList.getSelectedValues()) {
            IgnoredFileBean bean = (IgnoredFileBean)o;
            if (bean.getType() != IgnoreSettingsType.UNDER_DIR) continue;
            this.myDirectoriesManuallyRemovedFromIgnored.add(bean.getPath());
        }
        ListUtil.removeSelectedItems((JList)this.myList);
    }

    public void reset() {
        this.setItems(this.myChangeListManager.getFilesToIgnore());
        this.myDirectoriesManuallyRemovedFromIgnored.clear();
        this.myDirectoriesManuallyRemovedFromIgnored.addAll(this.myChangeListManager.getIgnoredFilesComponent().getDirectoriesManuallyRemovedFromIgnored());
    }

    public void apply() {
        IgnoredFileBean[] toIgnore = this.getItems();
        this.myChangeListManager.setFilesToIgnore(toIgnore);
        for (IgnoredFileBean bean : toIgnore) {
            if (bean.getType() != IgnoreSettingsType.UNDER_DIR) continue;
            this.myDirectoriesManuallyRemovedFromIgnored.remove(bean.getPath());
        }
        this.myChangeListManager.getIgnoredFilesComponent().setDirectoriesManuallyRemovedFromIgnored(this.myDirectoriesManuallyRemovedFromIgnored);
    }

    public boolean isModified() {
        return !Comparing.equal((Object[])this.myChangeListManager.getFilesToIgnore(), (Object[])this.getItems());
    }

    public JComponent createComponent() {
        if (this.myPanel == null) {
            this.myPanel = ToolbarDecorator.createDecorator((JList)this.myList).setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    IgnoredSettingsPanel.this.addItem();
                }
            }).setEditAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    IgnoredSettingsPanel.this.editItem();
                }
            }).setRemoveAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    IgnoredSettingsPanel.this.deleteItems();
                }
            }).disableUpDownActions().createPanel();
        }
        return this.myPanel;
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return "Ignored Files";
    }

    public String getHelpTopic() {
        return "project.propVCSSupport.Ignored.Files";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/IgnoredSettingsPanel", "getId"));
        }
        return string;
    }

    private static class MyCellRenderer
    extends ColoredListCellRenderer {
        private MyCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index, boolean selected, boolean hasFocus) {
            IgnoredFileBean bean;
            String path;
            if (list2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ui/IgnoredSettingsPanel$MyCellRenderer", "customizeCellRenderer"));
            }
            if (UIUtil.isUnderGTKLookAndFeel()) {
                Color background = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
                UIUtil.changeBackGround((Component)((Object)this), (Color)background);
            }
            if ((path = (bean = (IgnoredFileBean)value2).getPath()) != null) {
                if (path.endsWith("/")) {
                    this.append(VcsBundle.message((String)"ignored.configure.item.directory", (Object[])new Object[]{path}), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else {
                    this.append(VcsBundle.message((String)"ignored.configure.item.file", (Object[])new Object[]{path}), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            } else if (bean.getMask() != null) {
                this.append(VcsBundle.message((String)"ignored.configure.item.mask", (Object[])new Object[]{bean.getMask()}), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }
    }
}

