/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticFilePath {
    private final String myKey;
    private final String myPath;
    private final boolean myIsDirectory;
    private final VirtualFile myVf;

    public StaticFilePath(boolean isDirectory, @NotNull String path, @Nullable VirtualFile vf) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/ui/StaticFilePath", "<init>"));
        }
        this(isDirectory, path, FilePathsHelper.convertPath((String)path), vf);
    }

    private StaticFilePath(boolean isDirectory, @NotNull String path, @NotNull String key2, @Nullable VirtualFile vf) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/ui/StaticFilePath", "<init>"));
        }
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/vcs/changes/ui/StaticFilePath", "<init>"));
        }
        this.myIsDirectory = isDirectory;
        this.myPath = path;
        this.myKey = key2;
        this.myVf = vf;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/StaticFilePath", "getPath"));
        }
        return string;
    }

    @NotNull
    public String getKey() {
        String string = this.myKey;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/StaticFilePath", "getKey"));
        }
        return string;
    }

    @Nullable
    public VirtualFile getVf() {
        return this.myVf;
    }

    @Nullable
    public StaticFilePath getParent() {
        int idx = this.myKey.lastIndexOf(47);
        if (idx == -1 || idx == 0) {
            return null;
        }
        return new StaticFilePath(true, this.myPath.substring(0, idx), this.myKey.substring(0, idx), this.myVf == null ? null : this.myVf.getParent());
    }
}

