/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.CustomChangelistTodosTreeBuilder;
import com.intellij.ide.todo.SetTodoFilterAction;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeBuilderFactory;
import com.intellij.ide.todo.TodoView;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerUtil;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandlerWorker;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TodoCheckinHandler
extends CheckinHandler {
    private final Project myProject;
    private final CheckinProjectPanel myCheckinProjectPanel;
    private final VcsConfiguration myConfiguration;
    private TodoFilter myTodoFilter;

    public TodoCheckinHandler(CheckinProjectPanel checkinProjectPanel) {
        this.myProject = checkinProjectPanel.getProject();
        this.myCheckinProjectPanel = checkinProjectPanel;
        this.myConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
    }

    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        final JCheckBox checkBox = new JCheckBox(VcsBundle.message((String)"before.checkin.new.todo.check", (Object[])new Object[]{""}));
        return new RefreshableOnComponent(){

            public JComponent getComponent() {
                JPanel panel2 = new JPanel(new BorderLayout(4, 0));
                panel2.add((Component)checkBox, "West");
                this.setFilterText(((TodoCheckinHandler)TodoCheckinHandler.this).myConfiguration.myTodoPanelSettings.todoFilterName);
                if (((TodoCheckinHandler)TodoCheckinHandler.this).myConfiguration.myTodoPanelSettings.todoFilterName != null) {
                    TodoCheckinHandler.this.myTodoFilter = TodoConfiguration.getInstance().getTodoFilter(((TodoCheckinHandler)TodoCheckinHandler.this).myConfiguration.myTodoPanelSettings.todoFilterName);
                }
                final Consumer consumer = todoFilter -> {
                    String name2;
                    TodoCheckinHandler.this.myTodoFilter = todoFilter;
                    ((TodoCheckinHandler)TodoCheckinHandler.this).myConfiguration.myTodoPanelSettings.todoFilterName = name2 = todoFilter == null ? null : todoFilter.getName();
                    this.setFilterText(name2);
                };
                final LinkLabel linkLabel = new LinkLabel("Configure", null);
                linkLabel.setListener(new LinkListener(){

                    public void linkSelected(LinkLabel aSource, Object aLinkData) {
                        DefaultActionGroup group = SetTodoFilterAction.createPopupActionGroup(TodoCheckinHandler.this.myProject, ((TodoCheckinHandler)TodoCheckinHandler.this).myConfiguration.myTodoPanelSettings, (Consumer<TodoFilter>)consumer);
                        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("TodoViewToolbar", (ActionGroup)group);
                        popupMenu.getComponent().show((Component)linkLabel, 0, linkLabel.getHeight());
                    }
                }, null);
                panel2.add((Component)linkLabel, "Center");
                CheckinHandlerUtil.disableWhenDumb(TodoCheckinHandler.this.myProject, checkBox, "TODO check is impossible until indices are up-to-date");
                return panel2;
            }

            private void setFilterText(String filterName) {
                if (filterName == null) {
                    checkBox.setText(VcsBundle.message((String)"before.checkin.new.todo.check", (Object[])new Object[]{IdeBundle.message((String)"action.todo.show.all", (Object[])new Object[0])}));
                } else {
                    checkBox.setText(VcsBundle.message((String)"before.checkin.new.todo.check", (Object[])new Object[]{"Filter: " + filterName}));
                }
            }

            public void refresh() {
            }

            public void saveState() {
                ((TodoCheckinHandler)TodoCheckinHandler.this).myConfiguration.CHECK_NEW_TODO = checkBox.isSelected();
            }

            public void restoreState() {
                checkBox.setSelected(((TodoCheckinHandler)TodoCheckinHandler.this).myConfiguration.CHECK_NEW_TODO);
            }
        };
    }

    public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer) {
        if (!this.myConfiguration.CHECK_NEW_TODO) {
            return CheckinHandler.ReturnResult.COMMIT;
        }
        if (DumbService.getInstance((Project)this.myProject).isDumb()) {
            String todoName = VcsBundle.message((String)"before.checkin.new.todo.check.title", (Object[])new Object[0]);
            if (Messages.showOkCancelDialog((Project)this.myProject, (String)(todoName + " can't be performed while " + ApplicationNamesInfo.getInstance().getFullProductName() + " updates the indices in background.\nYou can commit the changes without running checks, or you can wait until indices are built."), (String)(todoName + " is not possible right now"), (String)"&Wait", (String)"&Commit", null) == 0) {
                return CheckinHandler.ReturnResult.CANCEL;
            }
            return CheckinHandler.ReturnResult.COMMIT;
        }
        Collection changes = this.myCheckinProjectPanel.getSelectedChanges();
        final TodoCheckinHandlerWorker worker = new TodoCheckinHandlerWorker(this.myProject, changes, this.myTodoFilter, true);
        final Ref completed = Ref.create((Object)Boolean.FALSE);
        ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, "Looking for New and Edited TODO Items...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/checkin/TodoCheckinHandler$2", "run"));
                }
                indicator.setIndeterminate(true);
                worker.execute();
            }

            public void onSuccess() {
                completed.set((Object)Boolean.TRUE);
            }
        });
        if (((Boolean)completed.get()).booleanValue() && worker.getAddedOrEditedTodos().isEmpty() && worker.getInChangedTodos().isEmpty() && worker.getSkipped().isEmpty()) {
            return CheckinHandler.ReturnResult.COMMIT;
        }
        if (!((Boolean)completed.get()).booleanValue()) {
            return CheckinHandler.ReturnResult.CANCEL;
        }
        return this.showResults(worker, executor);
    }

    private CheckinHandler.ReturnResult showResults(TodoCheckinHandlerWorker worker, CommitExecutor executor) {
        String commitButtonText = executor != null ? executor.getActionText() : this.myCheckinProjectPanel.getCommitActionName();
        commitButtonText = StringUtil.trimEnd((String)commitButtonText, (String)"...");
        String text2 = TodoCheckinHandler.createMessage(worker);
        boolean thereAreTodoFound = worker.getAddedOrEditedTodos().size() + worker.getInChangedTodos().size() > 0;
        String title = "TODO";
        if (thereAreTodoFound) {
            return this.askReviewOrCommit(worker, commitButtonText, text2, title);
        }
        if (0 == Messages.showYesNoDialog((Project)this.myProject, (String)text2, (String)title, (String)commitButtonText, (String)CommonBundle.getCancelButtonText(), (Icon)UIUtil.getWarningIcon())) {
            return CheckinHandler.ReturnResult.COMMIT;
        }
        return CheckinHandler.ReturnResult.CANCEL;
    }

    @NotNull
    private CheckinHandler.ReturnResult askReviewOrCommit(@NotNull TodoCheckinHandlerWorker worker, @NotNull String commitButton, @NotNull String text2, @NotNull String title) {
        if (worker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "worker", "com/intellij/openapi/vcs/checkin/TodoCheckinHandler", "askReviewOrCommit"));
        }
        if (commitButton == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitButton", "com/intellij/openapi/vcs/checkin/TodoCheckinHandler", "askReviewOrCommit"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/vcs/checkin/TodoCheckinHandler", "askReviewOrCommit"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/checkin/TodoCheckinHandler", "askReviewOrCommit"));
        }
        String yesButton = VcsBundle.message((String)"todo.in.new.review.button", (Object[])new Object[0]);
        switch (Messages.showYesNoCancelDialog((Project)this.myProject, (String)text2, (String)title, (String)yesButton, (String)commitButton, (String)CommonBundle.getCancelButtonText(), (Icon)UIUtil.getWarningIcon())) {
            case 0: {
                this.showTodo(worker);
                CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.CLOSE_WINDOW;
                if (returnResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/checkin/TodoCheckinHandler", "askReviewOrCommit"));
                }
                return returnResult;
            }
            case 1: {
                CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.COMMIT;
                if (returnResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/checkin/TodoCheckinHandler", "askReviewOrCommit"));
                }
                return returnResult;
            }
        }
        CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.CANCEL;
        if (returnResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/checkin/TodoCheckinHandler", "askReviewOrCommit"));
        }
        return returnResult;
    }

    private void showTodo(final TodoCheckinHandlerWorker worker) {
        final String title = "For commit (" + DateFormatUtil.formatDateTime((long)System.currentTimeMillis()) + ")";
        ((TodoView)ServiceManager.getService((Project)this.myProject, TodoView.class)).addCustomTodoView(new TodoTreeBuilderFactory(){

            @Override
            public TodoTreeBuilder createTreeBuilder(JTree tree, DefaultTreeModel treeModel, Project project2) {
                return new CustomChangelistTodosTreeBuilder(tree, treeModel, TodoCheckinHandler.this.myProject, title, worker.inOneList());
            }
        }, title, new TodoPanelSettings(this.myConfiguration.myTodoPanelSettings));
        ApplicationManager.getApplication().invokeLater(() -> {
            ToolWindow window;
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)this.myProject);
            if (manager != null && (window = manager.getToolWindow("TODO")) != null) {
                window.show(() -> {
                    ContentManager cm = window.getContentManager();
                    Content[] contents = cm.getContents();
                    if (contents.length > 0) {
                        cm.setSelectedContent(contents[contents.length - 1], true);
                    }
                });
            }
        }, ModalityState.NON_MODAL, this.myProject.getDisposed());
    }

    private static String createMessage(TodoCheckinHandlerWorker worker) {
        int added = worker.getAddedOrEditedTodos().size();
        int changed = worker.getInChangedTodos().size();
        int skipped = worker.getSkipped().size();
        if (added == 0 && changed == 0) {
            return VcsBundle.message((String)"todo.handler.only.skipped", (Object[])new Object[]{skipped});
        }
        if (changed == 0) {
            return VcsBundle.message((String)"todo.handler.only.added", (Object[])new Object[]{added, skipped});
        }
        if (added == 0) {
            return VcsBundle.message((String)"todo.handler.only.in.changed", (Object[])new Object[]{changed, skipped});
        }
        return VcsBundle.message((String)"todo.handler.only.both", (Object[])new Object[]{added, changed, skipped});
    }
}

